/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.BreakpointManagerListener;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Icons;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;

public class BreakpointTree
extends CheckboxTree {
    private static final String DEFAULT_PACKAGE_NAME = DebuggerBundle.message((String)"default.package.name", (Object[])new Object[0]);
    private final CheckedTreeNode myRootNode;
    private final List<Breakpoint> myBreakpoints = new ArrayList<Breakpoint>();
    private final Map<TreeDescriptor, CheckedTreeNode> myDescriptorToNodeMap = new HashMap<TreeDescriptor, CheckedTreeNode>();
    private boolean myGroupByMethods = false;
    private boolean myGroupByClasses = true;
    private boolean myFlattenPackages = true;
    private final NodeAppender[] myAppenders = new NodeAppender[]{new BreakpointToMethodAppender(), new BreakpointToClassAppender(), new BreakpointToPackageAppender(), new MethodToClassAppender(), new MethodToPackageAppender(), new ClassToPackageAppender(), new PackageToPackageAppender()};
    private final Comparator<CheckedTreeNode> myNodeComparator = new Comparator<CheckedTreeNode>(){

        @Override
        public int compare(CheckedTreeNode o1, CheckedTreeNode o2) {
            int w2;
            int w1 = this.getWeight(o1);
            if (w1 != (w2 = this.getWeight(o2))) {
                return w1 - w2;
            }
            TreeDescriptor d1 = (TreeDescriptor)o1.getUserObject();
            TreeDescriptor d2 = (TreeDescriptor)o2.getUserObject();
            if (d1 instanceof BreakpointDescriptor && d2 instanceof BreakpointDescriptor) {
                return 0;
            }
            return d1.getDisplayString().compareTo(d2.getDisplayString());
        }

        private int getWeight(CheckedTreeNode node) {
            if (node.getUserObject() instanceof BreakpointDescriptor) {
                return 100;
            }
            if (node.getUserObject() instanceof MethodDescriptor) {
                return 90;
            }
            if (node.getUserObject() instanceof PackageDescriptor) {
                return 80;
            }
            if (node.getUserObject() instanceof ClassDescriptor) {
                return 70;
            }
            return 50;
        }
    };
    private final BreakpointManager myBreakpointManager;
    private final BreakpointManagerListener myNodeUpdateListener;

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, new Convertor<TreePath, String>(){

            public String convert(TreePath path) {
                CheckedTreeNode node = (CheckedTreeNode)path.getLastPathComponent();
                return ((TreeDescriptor)node.getUserObject()).getDisplayString();
            }
        });
    }

    public boolean getExpandsSelectedPaths() {
        return true;
    }

    public Breakpoint[] getSelectedBreakpoints() {
        TreePath[] selectionPaths = this.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length == 0) {
            return Breakpoint.EMPTY_ARRAY;
        }
        final ArrayList breakpoints = new ArrayList(selectionPaths.length);
        for (TreePath path : selectionPaths) {
            CheckedTreeNode node = (CheckedTreeNode)path.getLastPathComponent();
            TreeUtil.traverseDepth((TreeNode)node, (TreeUtil.Traverse)new TreeUtil.Traverse(){

                public boolean accept(Object _node) {
                    CheckedTreeNode node = (CheckedTreeNode)_node;
                    TreeDescriptor descriptor = (TreeDescriptor)node.getUserObject();
                    if (descriptor instanceof BreakpointDescriptor) {
                        breakpoints.add(((BreakpointDescriptor)descriptor).getBreakpoint());
                    }
                    return true;
                }
            });
        }
        return breakpoints.toArray(new Breakpoint[breakpoints.size()]);
    }

    public void selectBreakpoint(Breakpoint breakpoint) {
        CheckedTreeNode node = this.myDescriptorToNodeMap.get(new BreakpointDescriptor(breakpoint));
        if (node == null) {
            return;
        }
        TreeUtil.selectNode((JTree)((Object)this), (TreeNode)node);
    }

    public void selectBreakpoints(Breakpoint[] breakpoints) {
        ArrayList<CheckedTreeNode> nodes = new ArrayList<CheckedTreeNode>(breakpoints.length);
        for (Breakpoint breakpoint : breakpoints) {
            CheckedTreeNode node = this.myDescriptorToNodeMap.get(new BreakpointDescriptor(breakpoint));
            if (node == null) continue;
            nodes.add(node);
        }
        this.clearSelection();
        for (CheckedTreeNode node : nodes) {
            this.addSelectionPath(new TreePath(node.getPath()));
        }
    }

    public void selectFirstBreakpoint() {
        TreeUtil.traverseDepth((TreeNode)this.myRootNode, (TreeUtil.Traverse)new TreeUtil.Traverse(){

            public boolean accept(Object node) {
                CheckedTreeNode treeNode = (CheckedTreeNode)node;
                TreeDescriptor descriptor = (TreeDescriptor)treeNode.getUserObject();
                if (descriptor instanceof BreakpointDescriptor) {
                    TreeUtil.selectNode((JTree)((Object)BreakpointTree.this), (TreeNode)treeNode);
                    return false;
                }
                return true;
            }
        });
    }

    public List<Breakpoint> getBreakpoints() {
        return Collections.unmodifiableList(this.myBreakpoints);
    }

    public void dispose() {
        KeyStroke[] treeStrokes;
        for (KeyStroke stroke : treeStrokes = this.getRegisteredKeyStrokes()) {
            this.unregisterKeyboardAction(stroke);
        }
        this.myBreakpointManager.removeBreakpointManagerListener(this.myNodeUpdateListener);
    }

    public BreakpointTree(Project project) {
        super(new BreakpointTreeCellRenderer(), new CheckedTreeNode((Object)new RootDescriptor()));
        this.myRootNode = (CheckedTreeNode)this.getModel().getRoot();
        this.myDescriptorToNodeMap.put((TreeDescriptor)this.myRootNode.getUserObject(), this.myRootNode);
        this.myBreakpointManager = DebuggerManagerEx.getInstanceEx(project).getBreakpointManager();
        this.myNodeUpdateListener = new BreakpointManagerListener(){

            @Override
            public void breakpointsChanged() {
                BreakpointTree.this.repaint();
            }
        };
        this.myBreakpointManager.addBreakpointManagerListener(this.myNodeUpdateListener);
    }

    public boolean isGroupByMethods() {
        return this.myGroupByMethods;
    }

    public void setGroupByMethods(boolean groupByMethods) {
        if (this.myGroupByMethods != groupByMethods) {
            this.myGroupByMethods = groupByMethods;
            this.rebuildTree();
        }
    }

    public boolean isGroupByClasses() {
        return this.myGroupByClasses;
    }

    public void setGroupByClasses(boolean groupByClasses) {
        if (this.myGroupByClasses != groupByClasses) {
            this.myGroupByClasses = groupByClasses;
            this.rebuildTree();
        }
    }

    public boolean isFlattenPackages() {
        return this.myFlattenPackages;
    }

    public void setFlattenPackages(boolean flattenPackages) {
        if (this.myFlattenPackages != flattenPackages) {
            this.myFlattenPackages = flattenPackages;
            this.rebuildTree();
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        Breakpoint breakpoint;
        Object descriptor = node.getUserObject();
        if (descriptor instanceof BreakpointDescriptor) {
            breakpoint = ((BreakpointDescriptor)descriptor).getBreakpoint();
            if (this.myBreakpointManager.findMasterBreakpoint(breakpoint) != null) {
                return;
            }
        } else {
            breakpoint = null;
        }
        if (breakpoint != null) {
            this.myBreakpointManager.setBreakpointEnabled(breakpoint, node.isChecked());
        }
    }

    public void addBreakpoint(Breakpoint breakpoint) {
        this.myBreakpoints.add(breakpoint);
        breakpoint.updateUI(new Runnable(){

            @Override
            public void run() {
                BreakpointTree.this.rebuildTree();
            }
        });
        this.rebuildTree();
        this.selectBreakpoint(breakpoint);
    }

    public void removeBreakpoint(Breakpoint breakpoint) {
        this.myBreakpoints.remove(breakpoint);
        this.rebuildTree();
    }

    public void removeBreakpoints(Breakpoint[] breakpoints) {
        this.myBreakpoints.removeAll(Arrays.asList(breakpoints));
        this.rebuildTree();
    }

    public void setBreakpoints(Breakpoint[] breakpoints) {
        this.myBreakpoints.clear();
        this.myBreakpoints.addAll(Arrays.asList(breakpoints));
        this.rebuildTree();
    }

    public Breakpoint getPreviousSibling(Breakpoint breakpoint) {
        return this.getSibling(breakpoint, false);
    }

    public Breakpoint getNextSibling(Breakpoint breakpoint) {
        return this.getSibling(breakpoint, true);
    }

    private Breakpoint getSibling(Breakpoint breakpoint, boolean nextSibling) {
        CheckedTreeNode node = this.myDescriptorToNodeMap.get(new BreakpointDescriptor(breakpoint));
        if (node == null) {
            return null;
        }
        CheckedTreeNode sibling = (CheckedTreeNode)(nextSibling ? node.getNextSibling() : node.getPreviousSibling());
        if (sibling == null) {
            return null;
        }
        TreeDescriptor descriptor = (TreeDescriptor)sibling.getUserObject();
        return descriptor instanceof BreakpointDescriptor ? ((BreakpointDescriptor)descriptor).getBreakpoint() : null;
    }

    private void rebuildTree() {
        TreeStateSnapshot treeStateSnapshot = new TreeStateSnapshot(this);
        this.myRootNode.removeAllChildren();
        this.myDescriptorToNodeMap.clear();
        this.myDescriptorToNodeMap.put((TreeDescriptor)this.myRootNode.getUserObject(), this.myRootNode);
        for (Breakpoint breakpoint : this.myBreakpoints) {
            CheckedTreeNode node = this.createNode(new BreakpointDescriptor(breakpoint));
            node.setChecked(breakpoint.ENABLED);
            this.addNode(node);
        }
        int count = this.myRootNode.getChildCount();
        ArrayList<CheckedTreeNode> children = new ArrayList<CheckedTreeNode>();
        for (int idx = 0; idx < count; ++idx) {
            CheckedTreeNode child = (CheckedTreeNode)this.myRootNode.getChildAt(idx);
            if (!(child.getUserObject() instanceof PackageDescriptor)) {
                children.add(child);
                continue;
            }
            while (child.getUserObject() instanceof PackageDescriptor && child.getChildCount() <= 1) {
                child = (CheckedTreeNode)child.getChildAt(0);
            }
            if (!(child.getUserObject() instanceof PackageDescriptor)) {
                child = (CheckedTreeNode)child.getParent();
            }
            CheckedTreeNode childToRemove = (CheckedTreeNode)child.getParent();
            while (!childToRemove.equals(this.myRootNode)) {
                this.myDescriptorToNodeMap.remove(childToRemove.getUserObject());
                childToRemove = (CheckedTreeNode)childToRemove.getParent();
            }
            children.add(child);
        }
        for (CheckedTreeNode aChildren : children) {
            aChildren.removeFromParent();
        }
        this.myRootNode.removeAllChildren();
        for (CheckedTreeNode child : children) {
            this.myRootNode.add((MutableTreeNode)child);
        }
        this.sortChildren(this.myRootNode);
        ((DefaultTreeModel)this.getModel()).nodeStructureChanged((TreeNode)this.myRootNode);
        treeStateSnapshot.restore(this);
        this.expandPath(new TreePath(this.myRootNode));
    }

    private void sortChildren(CheckedTreeNode node) {
        int childCount = node.getChildCount();
        if (childCount == 0) {
            return;
        }
        ArrayList<CheckedTreeNode> children = new ArrayList<CheckedTreeNode>(childCount);
        for (int idx = 0; idx < childCount; ++idx) {
            children.add((CheckedTreeNode)node.getChildAt(idx));
        }
        for (CheckedTreeNode child : children) {
            this.sortChildren(child);
            child.removeFromParent();
        }
        Collections.sort(children, this.myNodeComparator);
        for (CheckedTreeNode child : children) {
            node.add((MutableTreeNode)child);
        }
    }

    @NotNull
    private CheckedTreeNode createNode(TreeDescriptor descriptor) {
        CheckedTreeNode node = new CheckedTreeNode((Object)descriptor);
        this.myDescriptorToNodeMap.put(descriptor, node);
        CheckedTreeNode checkedTreeNode = node;
        if (checkedTreeNode == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/breakpoints/BreakpointTree.createNode must not return null");
        }
        return checkedTreeNode;
    }

    private void addNode(CheckedTreeNode node) {
        NodeAppender appender;
        NodeAppender[] arr$ = this.myAppenders;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (node = (appender = arr$[i$]).append(node)) != null; ++i$) {
        }
        if (node != null) {
            this.attachNodeToParent(BreakpointTree.getDescriptor(this.myRootNode), node);
        }
    }

    private static TreeDescriptor getDescriptor(CheckedTreeNode node) {
        return (TreeDescriptor)node.getUserObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CheckedTreeNode attachNodeToParent(TreeDescriptor parentDescriptor, CheckedTreeNode childNode) {
        CheckedTreeNode parentNode = this.myDescriptorToNodeMap.get(parentDescriptor);
        try {
            if (parentNode != null) {
                parentNode.add((MutableTreeNode)childNode);
                CheckedTreeNode checkedTreeNode = null;
                return checkedTreeNode;
            }
            parentNode = this.createNode(parentDescriptor);
            parentNode.add((MutableTreeNode)childNode);
            CheckedTreeNode checkedTreeNode = parentNode;
            return checkedTreeNode;
        }
        finally {
            if (parentNode != null && parentNode.getChildCount() == 1) {
                this.expandPath(new TreePath(parentNode.getPath()));
            }
        }
    }

    private static class TreeStateSnapshot {
        private final Object[] myExpandedUserObjects;
        private final Object[] mySelectedUserObjects;

        public TreeStateSnapshot(BreakpointTree tree) {
            List expandedPaths = TreeUtil.collectExpandedPaths((JTree)((Object)tree));
            this.myExpandedUserObjects = TreeStateSnapshot.getUserObjects(expandedPaths.toArray(new TreePath[expandedPaths.size()]));
            this.mySelectedUserObjects = TreeStateSnapshot.getUserObjects(tree.getSelectionPaths());
        }

        private static Object[] getUserObjects(TreePath[] treePaths) {
            if (treePaths == null) {
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }
            Object[] userObjects = new Object[treePaths.length];
            int index = 0;
            for (TreePath path : treePaths) {
                userObjects[index++] = ((CheckedTreeNode)path.getLastPathComponent()).getUserObject();
            }
            return userObjects;
        }

        public void restore(BreakpointTree tree) {
            List<TreePath> pathsToSelect;
            List<TreePath> pathsToExpand = TreeStateSnapshot.getPaths(tree, this.myExpandedUserObjects);
            if (!pathsToExpand.isEmpty()) {
                TreeUtil.restoreExpandedPaths((JTree)((Object)tree), pathsToExpand);
            }
            if (!(pathsToSelect = TreeStateSnapshot.getPaths(tree, this.mySelectedUserObjects)).isEmpty()) {
                tree.getSelectionModel().clearSelection();
                tree.setSelectionPaths(pathsToSelect.toArray(new TreePath[pathsToSelect.size()]));
            }
        }

        private static List<TreePath> getPaths(BreakpointTree tree, Object[] userObjects) {
            ArrayList<TreePath> paths = new ArrayList<TreePath>(userObjects.length);
            for (Object descriptor : userObjects) {
                CheckedTreeNode node = (CheckedTreeNode)tree.myDescriptorToNodeMap.get(descriptor);
                if (node == null) continue;
                paths.add(new TreePath(node.getPath()));
            }
            return paths;
        }
    }

    private static class RootDescriptor
    extends TreeDescriptor {
        private RootDescriptor() {
        }

        @Override
        protected String getDisplayString() {
            return "";
        }

        @Override
        protected Icon getDisplayIcon() {
            return Icons.PROJECT_ICON;
        }
    }

    private class PackageToPackageAppender
    extends NodeAppender {
        private PackageToPackageAppender() {
        }

        @Override
        public CheckedTreeNode append(CheckedTreeNode node) {
            if (BreakpointTree.this.myFlattenPackages) {
                return node;
            }
            TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
            if (!(descriptor instanceof PackageDescriptor)) {
                return node;
            }
            PackageDescriptor packageDescriptor = (PackageDescriptor)descriptor;
            String parentPackageName = packageDescriptor.getParentPackageName();
            if (parentPackageName == null) {
                return node;
            }
            CheckedTreeNode parentNode = BreakpointTree.this.attachNodeToParent(new PackageDescriptor(parentPackageName), node);
            if (parentNode == null) {
                return null;
            }
            return this.append(parentNode);
        }
    }

    private class ClassToPackageAppender
    extends NodeAppender {
        private ClassToPackageAppender() {
        }

        @Override
        public CheckedTreeNode append(CheckedTreeNode node) {
            TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
            if (!(descriptor instanceof ClassDescriptor)) {
                return node;
            }
            String packageName = ((ClassDescriptor)descriptor).getPackageName();
            return BreakpointTree.this.attachNodeToParent(new PackageDescriptor(packageName), node);
        }
    }

    private class MethodToPackageAppender
    extends NodeAppender {
        private MethodToPackageAppender() {
        }

        @Override
        public CheckedTreeNode append(CheckedTreeNode node) {
            TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
            if (!(descriptor instanceof MethodDescriptor)) {
                return node;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)descriptor;
            String packageName = methodDescriptor.getPackageName();
            return BreakpointTree.this.attachNodeToParent(new PackageDescriptor(packageName), node);
        }
    }

    private class MethodToClassAppender
    extends NodeAppender {
        private MethodToClassAppender() {
        }

        @Override
        public CheckedTreeNode append(CheckedTreeNode node) {
            if (!BreakpointTree.this.myGroupByClasses) {
                return node;
            }
            TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
            if (!(descriptor instanceof MethodDescriptor)) {
                return node;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)descriptor;
            String className = methodDescriptor.getClassName();
            String packageName = methodDescriptor.getPackageName();
            return BreakpointTree.this.attachNodeToParent(new ClassDescriptor(className, packageName), node);
        }
    }

    private class BreakpointToPackageAppender
    extends NodeAppender {
        private BreakpointToPackageAppender() {
        }

        @Override
        public CheckedTreeNode append(CheckedTreeNode node) {
            TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
            if (!(descriptor instanceof BreakpointDescriptor)) {
                return node;
            }
            Breakpoint breakpoint = ((BreakpointDescriptor)descriptor).getBreakpoint();
            String packageName = breakpoint instanceof ExceptionBreakpoint ? breakpoint.getPackageName() : (breakpoint instanceof BreakpointWithHighlighter ? breakpoint.getPackageName() : null);
            if (packageName == null) {
                return node;
            }
            return BreakpointTree.this.attachNodeToParent(new PackageDescriptor(packageName), node);
        }
    }

    private class BreakpointToClassAppender
    extends NodeAppender {
        private BreakpointToClassAppender() {
        }

        @Override
        public CheckedTreeNode append(CheckedTreeNode node) {
            if (!BreakpointTree.this.myGroupByClasses) {
                return node;
            }
            TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
            if (!(descriptor instanceof BreakpointDescriptor)) {
                return node;
            }
            Breakpoint breakpoint = ((BreakpointDescriptor)descriptor).getBreakpoint();
            String className = breakpoint.getShortClassName();
            if (className == null) {
                return node;
            }
            String packageName = breakpoint.getPackageName();
            if (packageName == null) {
                return node;
            }
            return BreakpointTree.this.attachNodeToParent(new ClassDescriptor(className, packageName), node);
        }
    }

    private class BreakpointToMethodAppender
    extends NodeAppender {
        private BreakpointToMethodAppender() {
        }

        @Override
        public CheckedTreeNode append(CheckedTreeNode node) {
            if (!BreakpointTree.this.myGroupByMethods) {
                return node;
            }
            TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
            if (!(descriptor instanceof BreakpointDescriptor)) {
                return node;
            }
            Breakpoint breakpoint = ((BreakpointDescriptor)descriptor).getBreakpoint();
            if (!(breakpoint instanceof LineBreakpoint)) {
                return node;
            }
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            String methodName = lineBreakpoint.getMethodName();
            String className = lineBreakpoint.getShortClassName();
            String packageName = lineBreakpoint.getPackageName();
            if (methodName == null || className == null || packageName == null) {
                return node;
            }
            return BreakpointTree.this.attachNodeToParent(new MethodDescriptor(methodName, className, packageName), node);
        }
    }

    private static abstract class NodeAppender {
        private NodeAppender() {
        }

        public abstract CheckedTreeNode append(CheckedTreeNode var1);
    }

    private static class BreakpointTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private BreakpointTreeCellRenderer() {
        }

        public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof CheckedTreeNode) {
                CheckedTreeNode node = (CheckedTreeNode)value;
                TreeDescriptor descriptor = BreakpointTree.getDescriptor(node);
                descriptor.customizeCellRenderer(this.getTextRenderer(), node, selected, node.isChecked(), expanded, leaf, hasFocus);
                if (descriptor instanceof BreakpointDescriptor) {
                    this.myCheckbox.setEnabled(node.isEnabled() && !((BreakpointDescriptor)descriptor).isSlave());
                }
            }
        }
    }

    private static final class PackageDescriptor
    extends TreeDescriptor {
        private final String myPackageName;

        public PackageDescriptor(String packageName) {
            this.myPackageName = "".equals(packageName) ? DEFAULT_PACKAGE_NAME : packageName;
        }

        public String getPackageName() {
            return this.myPackageName;
        }

        public String getParentPackageName() {
            int dotIndex = this.myPackageName.lastIndexOf(46);
            return dotIndex >= 0 ? this.myPackageName.substring(0, dotIndex) : null;
        }

        @Override
        public void customizeCellRenderer(ColoredTreeCellRenderer targetRenderer, CheckedTreeNode node, boolean selected, boolean checked, boolean expanded, boolean leaf, boolean hasFocus) {
            String parentPackageInTree;
            targetRenderer.setIcon(Icons.PACKAGE_ICON);
            CheckedTreeNode parent = (CheckedTreeNode)node.getParent();
            String displayName = parent != null && parent.getUserObject() instanceof PackageDescriptor ? (this.myPackageName.startsWith(parentPackageInTree = ((PackageDescriptor)parent.getUserObject()).getPackageName() + ".") ? this.myPackageName.substring(parentPackageInTree.length()) : this.myPackageName) : this.myPackageName;
            targetRenderer.append(displayName, checked ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        @Override
        protected String getDisplayString() {
            return this.myPackageName;
        }

        @Override
        protected Icon getDisplayIcon() {
            return Icons.PACKAGE_ICON;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PackageDescriptor packageDescriptor = (PackageDescriptor)o;
            return this.myPackageName.equals(packageDescriptor.myPackageName);
        }

        public int hashCode() {
            return this.myPackageName.hashCode();
        }
    }

    private static final class ClassDescriptor
    extends TreeDescriptor {
        @NotNull
        private final String myClassName;
        @NotNull
        private final String myPackageName;

        public ClassDescriptor(@NotNull String className, @NotNull String packageName) {
            if (className == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/ui/breakpoints/BreakpointTree$ClassDescriptor.<init> must not be null");
            }
            if (packageName == null) {
                throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/debugger/ui/breakpoints/BreakpointTree$ClassDescriptor.<init> must not be null");
            }
            this.myClassName = className;
            this.myPackageName = packageName.length() == 0 ? DEFAULT_PACKAGE_NAME : packageName;
        }

        @NotNull
        public String getPackageName() {
            String string = this.myPackageName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/breakpoints/BreakpointTree$ClassDescriptor.getPackageName must not return null");
            }
            return string;
        }

        @NotNull
        public String getClassName() {
            String string = this.myClassName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/breakpoints/BreakpointTree$ClassDescriptor.getClassName must not return null");
            }
            return string;
        }

        @Override
        protected String getDisplayString() {
            return this.getClassName();
        }

        @Override
        protected Icon getDisplayIcon() {
            return Icons.CLASS_ICON;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)o;
            return this.myClassName.equals(classDescriptor.myClassName);
        }

        public int hashCode() {
            return this.myClassName.hashCode();
        }
    }

    private static final class MethodDescriptor
    extends TreeDescriptor {
        private final String myClassName;
        private final String myMethodName;
        @NotNull
        private final String myPackageName;

        public MethodDescriptor(String methodName, String className, @NotNull String packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/debugger/ui/breakpoints/BreakpointTree$MethodDescriptor.<init> must not be null");
            }
            this.myClassName = className;
            this.myMethodName = methodName;
            this.myPackageName = packageName;
        }

        @NotNull
        public String getPackageName() {
            String string = this.myPackageName;
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/breakpoints/BreakpointTree$MethodDescriptor.getPackageName must not return null");
            }
            return string;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public String getMethodName() {
            return this.myMethodName;
        }

        @Override
        protected String getDisplayString() {
            return this.myMethodName;
        }

        @Override
        protected Icon getDisplayIcon() {
            return Icons.METHOD_ICON;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDescriptor methodDescriptor = (MethodDescriptor)o;
            if (!this.myClassName.equals(methodDescriptor.myClassName)) {
                return false;
            }
            return this.myMethodName.equals(methodDescriptor.myMethodName);
        }

        public int hashCode() {
            int result = this.myClassName.hashCode();
            result = 29 * result + this.myMethodName.hashCode();
            return result;
        }
    }

    private final class BreakpointDescriptor
    extends TreeDescriptor {
        private final Breakpoint myBreakpoint;

        public BreakpointDescriptor(Breakpoint breakpoint) {
            this.myBreakpoint = breakpoint;
        }

        @NotNull
        public Breakpoint getBreakpoint() {
            Breakpoint breakpoint = this.myBreakpoint;
            if (breakpoint == null) {
                throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/breakpoints/BreakpointTree$BreakpointDescriptor.getBreakpoint must not return null");
            }
            return breakpoint;
        }

        @Override
        protected Icon getDisplayIcon() {
            return this.myBreakpoint instanceof BreakpointWithHighlighter ? (this.myBreakpoint.ENABLED ? ((BreakpointWithHighlighter)this.myBreakpoint).getSetIcon(false) : ((BreakpointWithHighlighter)this.myBreakpoint).getDisabledIcon(false)) : this.myBreakpoint.getIcon();
        }

        @Override
        public String getDisplayString() {
            return this.myBreakpoint.getDisplayName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BreakpointDescriptor breakpointDescriptor = (BreakpointDescriptor)o;
            return this.myBreakpoint.equals(breakpointDescriptor.myBreakpoint);
        }

        public int hashCode() {
            return this.myBreakpoint.hashCode();
        }

        public boolean isSlave() {
            Breakpoint breakpoint = this.getBreakpoint();
            return BreakpointTree.this.myBreakpointManager.findMasterBreakpoint(breakpoint) != null;
        }
    }

    private static abstract class TreeDescriptor {
        private TreeDescriptor() {
        }

        protected void customizeCellRenderer(ColoredTreeCellRenderer targetRenderer, CheckedTreeNode node, boolean selected, boolean checked, boolean expanded, boolean leaf, boolean hasFocus) {
            targetRenderer.setIcon(this.getDisplayIcon());
            targetRenderer.append(this.getDisplayString(), checked ? SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }

        protected abstract String getDisplayString();

        protected abstract Icon getDisplayIcon();
    }
}

