/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.UpdatableDebuggerView;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.PopupHandler;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public abstract class DebuggerTreePanel
extends UpdatableDebuggerView
implements DataProvider {
    public static final DataKey<DebuggerTreePanel> DATA_KEY = DataKey.create((String)"DebuggerPanel");
    protected final DebuggerTree myTree = this.createTreeView();

    public DebuggerTreePanel(Project project, DebuggerStateManager stateManager) {
        super(project, stateManager);
        final PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = DebuggerTreePanel.this.createPopupMenu();
                if (popupMenu != null) {
                    DebuggerTreePanel.this.myTree.myTipManager.registerPopup(popupMenu.getComponent()).show(comp, x, y);
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)popupHandler);
        this.setFocusTraversalPolicy(new IdeFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponentImpl(Container focusCycleRoot) {
                return DebuggerTreePanel.this.myTree;
            }
        });
        this.registerDisposable(new Disposable(){

            public void dispose() {
                DebuggerTreePanel.this.myTree.removeMouseListener((MouseListener)popupHandler);
            }
        });
        Shortcut[] shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("ToggleBookmark");
        CustomShortcutSet shortcutSet = shortcuts.length > 0 ? new CustomShortcutSet(shortcuts) : new CustomShortcutSet(KeyStroke.getKeyStroke(122, 0));
        this.overrideShortcut((JComponent)((Object)this.myTree), "Debugger.MarkObject", shortcutSet);
    }

    protected abstract DebuggerTree createTreeView();

    @Override
    protected void rebuild(boolean updateOnly) {
        DebuggerSession debuggerSession = this.getContext().getDebuggerSession();
        if (debuggerSession == null) {
            return;
        }
        this.getTree().rebuild(this.getContext());
    }

    @Override
    public void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myTree);
    }

    protected abstract ActionPopupMenu createPopupMenu();

    public final DebuggerTree getTree() {
        return this.myTree;
    }

    public void clear() {
        this.myTree.removeAllChildren();
    }

    public Object getData(String dataId) {
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    @Override
    public void requestFocus() {
        this.getTree().requestFocus();
    }
}

