/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import org.jetbrains.annotations.NotNull;

public class CompoundReferenceRenderer
extends CompoundNodeRenderer {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer");

    public CompoundReferenceRenderer(NodeRendererSettings rendererSettings, String name, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        super(rendererSettings, name, labelRenderer, childrenRenderer);
        this.myProperties.setClassName("java.lang.Object");
        LOG.assertTrue(labelRenderer == null || labelRenderer instanceof ReferenceRenderer);
        LOG.assertTrue(childrenRenderer == null || childrenRenderer instanceof ReferenceRenderer);
    }

    @Override
    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        ValueLabelRenderer prevRenderer = this.getLabelRenderer();
        super.setLabelRenderer(this.myRendererSettings.isBase(labelRenderer) ? null : labelRenderer);
        ValueLabelRenderer currentRenderer = this.getLabelRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    @Override
    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        ChildrenRenderer prevRenderer = this.getChildrenRenderer();
        super.setChildrenRenderer(this.myRendererSettings.isBase(childrenRenderer) ? null : childrenRenderer);
        ChildrenRenderer currentRenderer = this.getChildrenRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    @Override
    public ChildrenRenderer getChildrenRenderer() {
        ChildrenRenderer childrenRenderer = super.getChildrenRenderer();
        return childrenRenderer != null ? childrenRenderer : this.getDefaultRenderer();
    }

    private NodeRenderer getDefaultRenderer() {
        return this.getClassName().endsWith("]") ? this.myRendererSettings.getArrayRenderer() : this.myRendererSettings.getClassRenderer();
    }

    @Override
    public ValueLabelRenderer getLabelRenderer() {
        ValueLabelRenderer labelRenderer = super.getLabelRenderer();
        return labelRenderer != null ? labelRenderer : this.getDefaultRenderer();
    }

    private ChildrenRenderer getRawChildrenRenderer() {
        NodeRenderer classRenderer = this.getDefaultRenderer();
        return this.myChildrenRenderer == classRenderer ? null : this.myChildrenRenderer;
    }

    private ValueLabelRenderer getRawLabelRenderer() {
        NodeRenderer classRenderer = this.getDefaultRenderer();
        return this.myLabelRenderer == classRenderer ? null : this.myLabelRenderer;
    }

    @Override
    public boolean isApplicable(Type type) {
        if (type == null || !(type instanceof ReferenceType) || !DebuggerUtils.instanceOf((Type)type, (String)this.getClassName())) {
            return false;
        }
        return super.isApplicable(type);
    }

    public void setClassName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/debugger/ui/tree/render/CompoundReferenceRenderer.setClassName must not be null");
        }
        this.myProperties.setClassName(name);
        if (this.getRawLabelRenderer() != null && this.myLabelRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)this.myLabelRenderer)).setClassName(name);
        }
        if (this.getRawChildrenRenderer() != null && this.myChildrenRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)this.myChildrenRenderer)).setClassName(name);
        }
    }

    @NotNull
    public String getClassName() {
        String string = this.myProperties.getClassName();
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/debugger/ui/tree/render/CompoundReferenceRenderer.getClassName must not return null");
        }
        return string;
    }
}

