/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.errorreport;

import com.intellij.diagnostic.DiagnosticBundle;
import com.intellij.errorreport.bean.ErrorBean;
import com.intellij.errorreport.bean.ExceptionBean;
import com.intellij.errorreport.bean.NotifierBean;
import com.intellij.errorreport.error.InternalEAPException;
import com.intellij.errorreport.error.NewBuildException;
import com.intellij.errorreport.error.NoSuchEAPUserException;
import com.intellij.errorreport.itn.ITNProxy;
import com.intellij.ide.reporter.ConnectionException;
import com.intellij.idea.IdeaLogger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.BuildInfo;
import com.intellij.openapi.updateSettings.impl.UpdateChannel;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.util.Ref;
import com.intellij.util.net.HttpConfigurable;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public class ErrorReportSender {
    @NonNls
    public static final String PREPARE_URL = "http://www.intellij.net/";
    @NonNls
    public static final String PRODUCT_CODE = "idea";
    @NonNls
    private static final String PARAM_EMAIL = "EMAIL";
    @NonNls
    private static final String PARAM_EAP = "eap";
    private SendTask sendTask;

    public static ErrorReportSender getInstance() {
        return new ErrorReportSender();
    }

    protected ErrorReportSender() {
    }

    public void prepareError(Project project, Throwable exception) throws IOException, NewBuildException {
        this.sendTask = new SendTask(project, exception);
        try {
            this.sendTask.checkNewBuild();
        }
        catch (NewBuildException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public int sendError(NotifierBean notifierBean, ErrorBean error) throws IOException, NoSuchEAPUserException, InternalEAPException {
        this.sendTask.setErrorBean(error);
        this.sendTask.setNotifierBean(notifierBean);
        try {
            this.sendTask.sendReport();
            return this.sendTask.getThreadId();
        }
        catch (IOException e) {
            throw e;
        }
        catch (NoSuchEAPUserException e) {
            throw e;
        }
        catch (InternalEAPException e) {
            throw e;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    class SendTask {
        private final Project myProject;
        private NotifierBean notifierBean;
        private ErrorBean errorBean;
        private final Throwable throwable;
        private ExceptionBean exceptionBean;

        public SendTask(Project project, Throwable throwable) {
            this.myProject = project;
            this.throwable = throwable;
        }

        public int getThreadId() {
            return this.exceptionBean.getItnThreadId();
        }

        public void setErrorBean(ErrorBean error) {
            this.errorBean = error;
        }

        public void setNotifierBean(NotifierBean notifierBean) {
            this.notifierBean = notifierBean;
        }

        public void checkNewBuild() throws NewBuildException {
            BuildInfo newVersion = null;
            try {
                UpdateChannel channel = UpdateChecker.checkForUpdates();
                newVersion = channel != null ? channel.getLatestBuild() : null;
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
            if (newVersion != null) {
                throw new NewBuildException(newVersion.getNumber().asString());
            }
            this.exceptionBean = new ExceptionBean(this.throwable);
        }

        public void sendReport() throws Exception {
            this.errorBean.setExceptionHashCode(this.exceptionBean.getHashCode());
            final Ref err = new Ref();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpConfigurable.getInstance().prepareURL(ErrorReportSender.PREPARE_URL);
                        if (SendTask.this.notifierBean.getItnLogin() != null && SendTask.this.notifierBean.getItnLogin().length() > 0) {
                            int threadId = ITNProxy.postNewThread(SendTask.this.notifierBean.getItnLogin(), SendTask.this.notifierBean.getItnPassword(), SendTask.this.errorBean, SendTask.this.exceptionBean, IdeaLogger.getOurCompilationTimestamp());
                            SendTask.this.exceptionBean.setItnThreadId(threadId);
                        }
                    }
                    catch (Exception ex) {
                        err.set((Object)ex);
                    }
                }
            };
            if (this.myProject == null) {
                runnable.run();
            } else {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, DiagnosticBundle.message("title.submitting.error.report", new Object[0]), false, this.myProject);
            }
            if (!err.isNull()) {
                throw (Exception)err.get();
            }
        }
    }
}

