/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.application;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.application.ApplicationConfiguration;
import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.junit2.configuration.ClassBrowser;
import com.intellij.execution.junit2.configuration.CommonJavaParameters;
import com.intellij.execution.junit2.configuration.ConfigurationModuleSelector;
import com.intellij.execution.ui.AlternativeJREPanel;
import com.intellij.execution.util.JreVersionDetector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ApplicationConfigurable2
extends SettingsEditor<ApplicationConfiguration> {
    private CommonJavaParameters myCommonJavaParameters;
    private LabeledComponent<TextFieldWithBrowseButton> myMainClass;
    private LabeledComponent<JComboBox> myModule;
    private JPanel myWholePanel;
    private final ConfigurationModuleSelector myModuleSelector;
    private AlternativeJREPanel myAlternativeJREPanel;
    private JCheckBox myShowSwingInspectorCheckbox;
    private EnvironmentVariablesComponent myEnvVariablesComponent;
    private final JreVersionDetector myVersionDetector;

    public ApplicationConfigurable2(Project project) {
        this.$$$setupUI$$$();
        this.myVersionDetector = new JreVersionDetector();
        this.myModuleSelector = new ConfigurationModuleSelector(project, (JComboBox)this.myModule.getComponent());
        ((JComboBox)this.myModule.getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationConfigurable2.this.myCommonJavaParameters.setModuleContext(ApplicationConfigurable2.this.myModuleSelector.getModule());
            }
        });
        ClassBrowser.createApplicationClassBrowser(project, this.myModuleSelector).setField(this.getMainClassField());
    }

    public void applyEditorTo(ApplicationConfiguration configuration) throws ConfigurationException {
        this.myCommonJavaParameters.applyTo(configuration);
        this.myModuleSelector.applyTo(configuration);
        configuration.MAIN_CLASS_NAME = this.getMainClassField().getText();
        configuration.ALTERNATIVE_JRE_PATH = this.myAlternativeJREPanel.getPath();
        configuration.ALTERNATIVE_JRE_PATH_ENABLED = this.myAlternativeJREPanel.isPathEnabled();
        configuration.ENABLE_SWING_INSPECTOR = this.myVersionDetector.isJre50Configured(configuration) && this.myShowSwingInspectorCheckbox.isSelected();
        configuration.setEnvs(this.myEnvVariablesComponent.getEnvs());
        configuration.PASS_PARENT_ENVS = this.myEnvVariablesComponent.isPassParentEnvs();
        this.updateShowSwingInspector(configuration);
    }

    public void resetEditorFrom(ApplicationConfiguration configuration) {
        this.myCommonJavaParameters.reset(configuration);
        this.myModuleSelector.reset(configuration);
        this.getMainClassField().setText(configuration.MAIN_CLASS_NAME);
        this.myAlternativeJREPanel.init(configuration.ALTERNATIVE_JRE_PATH, configuration.ALTERNATIVE_JRE_PATH_ENABLED);
        this.myEnvVariablesComponent.setEnvs(configuration.getEnvs());
        this.myEnvVariablesComponent.setPassParentEnvs(configuration.PASS_PARENT_ENVS);
        this.updateShowSwingInspector(configuration);
    }

    private void updateShowSwingInspector(ApplicationConfiguration configuration) {
        if (this.myVersionDetector.isJre50Configured(configuration)) {
            this.myShowSwingInspectorCheckbox.setEnabled(true);
            this.myShowSwingInspectorCheckbox.setSelected(configuration.ENABLE_SWING_INSPECTOR);
            this.myShowSwingInspectorCheckbox.setText(ExecutionBundle.message((String)"show.swing.inspector", (Object[])new Object[0]));
        } else {
            this.myShowSwingInspectorCheckbox.setEnabled(false);
            this.myShowSwingInspectorCheckbox.setSelected(false);
            this.myShowSwingInspectorCheckbox.setText(ExecutionBundle.message((String)"show.swing.inspector.disabled", (Object[])new Object[0]));
        }
    }

    public TextFieldWithBrowseButton getMainClassField() {
        return (TextFieldWithBrowseButton)this.myMainClass.getComponent();
    }

    public CommonJavaParameters getCommonJavaParameters() {
        return this.myCommonJavaParameters;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/application/ApplicationConfigurable2.createEditor must not return null");
        }
        return jPanel;
    }

    public void disposeEditor() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        EnvironmentVariablesComponent environmentVariablesComponent;
        JCheckBox jCheckBox;
        AlternativeJREPanel alternativeJREPanel;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        CommonJavaParameters commonJavaParameters;
        JPanel jPanel;
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, 10, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myCommonJavaParameters = commonJavaParameters = new CommonJavaParameters();
        commonJavaParameters.setProgramParametersText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("run.configuration.program.parameters"));
        jPanel.add((Component)commonJavaParameters, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myMainClass = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.main.class.label"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("javax.swing.JComboBox");
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myAlternativeJREPanel = alternativeJREPanel = new AlternativeJREPanel();
        jPanel.add((Component)alternativeJREPanel, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myShowSwingInspectorCheckbox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/ExecutionBundle").getString("show.swing.inspector"));
        jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myEnvVariablesComponent = environmentVariablesComponent = new EnvironmentVariablesComponent();
        jPanel.add((Component)environmentVariablesComponent, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

