/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.impl.ConfigurationSettingsEditorWrapper;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TabbedPaneWrapper;
import javax.swing.Icon;
import javax.swing.JComponent;

class TypeTemplatesConfigurable
implements Configurable {
    private final ConfigurationType myType;
    private final Configurable[] myConfigurables;
    private TabbedPaneWrapper myTabbedPane;

    public TypeTemplatesConfigurable(ConfigurationType type, RunManagerImpl runManager, Project project) {
        this.myType = type;
        this.myConfigurables = new Configurable[this.getFactories().length];
        this.myTabbedPane = new TabbedPaneWrapper((Disposable)project);
        ConfigurationFactory[] factories = this.getFactories();
        for (int i = 0; i < factories.length; ++i) {
            ConfigurationFactory factory = factories[i];
            RunnerAndConfigurationSettingsImpl template = runManager.getConfigurationTemplate(factory);
            TemplateConfigurable configurable = new TemplateConfigurable(template);
            this.myConfigurables[i] = configurable;
            this.myTabbedPane.addTab(factory.getName(), configurable.getIcon(), configurable.createComponent(), null);
        }
    }

    private ConfigurationFactory[] getFactories() {
        return this.myType.getConfigurationFactories();
    }

    public String getDisplayName() {
        return ExecutionBundle.message((String)"template.settings.configurable.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon() {
        return this.myType.getIcon();
    }

    public String getHelpTopic() {
        int index = this.myTabbedPane.getSelectedIndex();
        return this.myConfigurables[index].getHelpTopic();
    }

    public JComponent createComponent() {
        return this.myTabbedPane.getComponent();
    }

    public boolean isModified() {
        for (Configurable configurable : this.myConfigurables) {
            if (!configurable.isModified()) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (Configurable configurable : this.myConfigurables) {
            configurable.apply();
        }
    }

    public void reset() {
        for (Configurable configurable : this.myConfigurables) {
            configurable.reset();
        }
    }

    public void disposeUIResources() {
        for (int i = 0; i < this.myConfigurables.length; ++i) {
            Configurable configurable = this.myConfigurables[i];
            configurable.disposeUIResources();
            this.myConfigurables[i] = null;
        }
        this.myTabbedPane = null;
    }

    public static Configurable createConfigurable(ConfigurationType type, Project project) {
        ConfigurationFactory[] factories = type.getConfigurationFactories();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl(project);
        return factories.length == 1 ? new TemplateConfigurable(runManager.getConfigurationTemplate(factories[0])) : new TypeTemplatesConfigurable(type, runManager, project);
    }

    private static class TemplateConfigurable
    extends SettingsEditorConfigurable<RunnerAndConfigurationSettingsImpl> {
        private final RunnerAndConfigurationSettings myTemplate;

        public TemplateConfigurable(RunnerAndConfigurationSettingsImpl template) {
            super((SettingsEditor)new ConfigurationSettingsEditorWrapper(template), (Object)template);
            this.myTemplate = template;
        }

        public String getDisplayName() {
            return this.myTemplate.getConfiguration().getName();
        }

        public Icon getIcon() {
            return this.myTemplate.getConfiguration().getType().getIcon();
        }

        public String getHelpTopic() {
            return null;
        }
    }
}

