/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.configuration;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;

public class CommonJavaParameters
extends JPanel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.configuration.CommonJavaParameters");
    private static final Icon ICON = IconLoader.getIcon((String)"/runConfigurations/variables.png");
    private static final int[] ourProperties = new int[]{1, 0, 2};
    private JPanel myWholePanel;
    private LabeledComponent<RawCommandLineEditor> myProgramParameters;
    private LabeledComponent<RawCommandLineEditor> myVMParameters;
    private LabeledComponent<JPanel> myWorkingDirectoryComponent;
    private final LabeledComponent[] myFields = new LabeledComponent[3];
    private Module myModule = null;
    private JButton myVariablesButton;
    private TextFieldWithBrowseButton myWorkingDirectoryField;

    public CommonJavaParameters() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myWholePanel, "Center");
        CommonJavaParameters.copyDialogCaption(this.myProgramParameters);
        CommonJavaParameters.copyDialogCaption(this.myVMParameters);
        this.myFields[1] = this.myProgramParameters;
        this.myFields[0] = this.myVMParameters;
        this.myFields[2] = this.myWorkingDirectoryComponent;
    }

    private static void copyDialogCaption(LabeledComponent<RawCommandLineEditor> component) {
        RawCommandLineEditor rawCommandLineEditor = (RawCommandLineEditor)component.getComponent();
        rawCommandLineEditor.setDialogCaption(component.getRawText());
        component.getLabel().setLabelFor(rawCommandLineEditor.getTextField());
    }

    public String getProgramParametersText() {
        return this.getLabeledComponent(1).getText();
    }

    public void setProgramParametersText(String textWithMnemonic) {
        this.getLabeledComponent(1).setText(textWithMnemonic);
        CommonJavaParameters.copyDialogCaption(this.myProgramParameters);
    }

    public void applyTo(RunJavaConfiguration configuration) {
        for (int property : ourProperties) {
            configuration.setProperty(property, this.getText(property));
        }
    }

    public void reset(RunJavaConfiguration configuration) {
        for (int property : ourProperties) {
            this.setText(property, configuration.getProperty(property));
        }
    }

    public void setText(int property, String value) {
        JComponent component = this.getLabeledComponent(property).getComponent();
        if (component instanceof TextFieldWithBrowseButton) {
            ((TextFieldWithBrowseButton)component).setText(value);
        } else if (component instanceof RawCommandLineEditor) {
            ((RawCommandLineEditor)component).setText(value);
        } else if (component instanceof JPanel) {
            this.myWorkingDirectoryField.setText(value);
        } else {
            LOG.error(component.getClass().getName());
        }
    }

    public String getText(int property) {
        JComponent component = this.getLabeledComponent(property).getComponent();
        if (component instanceof TextFieldWithBrowseButton) {
            return ((TextFieldWithBrowseButton)component).getText();
        }
        if (component instanceof RawCommandLineEditor) {
            return ((RawCommandLineEditor)component).getText();
        }
        if (component instanceof JPanel) {
            return this.myWorkingDirectoryField.getText();
        }
        LOG.error(component.getClass().getName());
        return "";
    }

    private LabeledComponent getLabeledComponent(int index) {
        return this.myFields[index];
    }

    public void setModuleContext(Module module) {
        this.myModule = module;
    }

    private void createUIComponents() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myWorkingDirectoryField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
                fileChooserDescriptor.setTitle(ExecutionBundle.message((String)"select.working.directory.message", (Object[])new Object[0]));
                fileChooserDescriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)CommonJavaParameters.this.myModule);
                VirtualFile[] files = FileChooser.chooseFiles((Component)CommonJavaParameters.this.myWorkingDirectoryComponent, (FileChooserDescriptor)fileChooserDescriptor);
                if (files.length != 0) {
                    CommonJavaParameters.this.setText(2, files[0].getPresentableUrl());
                }
            }
        });
        panel.add((Component)this.myWorkingDirectoryField, "Center");
        final FixedSizeButton button = new FixedSizeButton((JComponent)this.myWorkingDirectoryField);
        button.setIcon(ICON);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> macros = new ArrayList<String>(PathMacros.getInstance().getUserMacroNames());
                macros.add("MODULE_DIR");
                final JList<String> list = new JList<String>(ArrayUtil.toStringArray(macros));
                JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder(list).setItemChoosenCallback(new Runnable(){

                    @Override
                    public void run() {
                        Object value = list.getSelectedValue();
                        if (value instanceof String) {
                            CommonJavaParameters.this.setText(2, "$" + value + "$");
                        }
                    }
                }).setMovable(false).setResizable(false).createPopup();
                popup.showUnderneathOf((Component)button);
            }
        });
        panel.add((Component)button, "East");
        this.myWorkingDirectoryComponent = LabeledComponent.create((JComponent)panel, (String)"&Working directory");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        JPanel jPanel;
        this.createUIComponents();
        this.myWholePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, 10, false, false));
        this.myVMParameters = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.vm.parameters.label"));
        labeledComponent2.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        jPanel.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, new Dimension(0, -1), new Dimension(400, -1), null));
        this.myProgramParameters = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("junit.configuration.test.runner.parameters.label"));
        labeledComponent.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        jPanel.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, new Dimension(0, -1), new Dimension(400, -1), null));
        LabeledComponent<JPanel> labeledComponent3 = this.myWorkingDirectoryComponent;
        jPanel.add((Component)labeledComponent3, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 3, new Dimension(0, -1), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }
}

