/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.util.config.Storage;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import org.jetbrains.annotations.Nullable;

public class SMTRunnerConsoleProperties
extends TestConsoleProperties {
    private final RuntimeConfiguration myConfiguration;

    public SMTRunnerConsoleProperties(RuntimeConfiguration config, String testFrameworkName) {
        super((Storage)new Storage.PropertiesComponentStorage(testFrameworkName + "Support.", PropertiesComponent.getInstance()), config.getProject());
        this.myConfiguration = config;
    }

    @Override
    public boolean isDebug() {
        return this.getDebugSession() != null;
    }

    @Override
    public boolean isPaused() {
        XDebugSession debuggerSession = this.getDebugSession();
        return debuggerSession != null && debuggerSession.isPaused();
    }

    @Nullable
    public XDebugSession getDebugSession() {
        XDebugSession[] sessions;
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)this.getProject());
        if (debuggerManager == null) {
            return null;
        }
        for (XDebugSession debuggerSession : sessions = debuggerManager.getDebugSessions()) {
            if (this.getConsole() != debuggerSession.getRunContentDescriptor().getExecutionConsole()) continue;
            return debuggerSession;
        }
        return null;
    }

    @Override
    public RuntimeConfiguration getConfiguration() {
        return this.myConfiguration;
    }
}

