/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.ChangingPrintable;
import com.intellij.execution.testframework.DeferingPrinter;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkPropertyListener;
import com.intellij.execution.testframework.ui.PrintableTestProxy;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.util.config.AbstractProperty;

public class TestsOutputConsolePrinter
implements Printer,
Disposable {
    private final ConsoleView myConsole;
    private final TestConsoleProperties myProperties;
    private ChangingPrintable myCurrentPrintable = ChangingPrintable.DEAF;
    private Printer myOutput;
    private final DeferingPrinter myDeferingPrinter = new DeferingPrinter(false);
    private final Printer.Intermediate myOutputStorage;
    private Printer.Intermediate myCurrentOutputStorage = this.myOutputStorage = new DeferingPrinter(true);
    private int myMarkOffset = 0;
    private final TestFrameworkPropertyListener<Boolean> myPropertyListener = new TestFrameworkPropertyListener<Boolean>(){

        @Override
        public void onChanged(Boolean value) {
            if (!value.booleanValue()) {
                TestsOutputConsolePrinter.this.myMarkOffset = 0;
            }
        }
    };

    public TestsOutputConsolePrinter(ConsoleView console, TestConsoleProperties properties) {
        this.myConsole = console;
        this.myProperties = properties;
        this.myProperties.addListener(TestConsoleProperties.SCROLL_TO_STACK_TRACE, this.myPropertyListener);
        this.myOutput = this;
    }

    public ConsoleView getConsole() {
        return this.myConsole;
    }

    public boolean isPaused() {
        return this.myOutput != this;
    }

    public void pause(boolean doPause) {
        if (doPause) {
            this.myOutput = this.myDeferingPrinter;
        } else {
            this.myOutput = this;
            this.myDeferingPrinter.printOn(this.myOutput);
        }
    }

    @Override
    public void print(String text, ConsoleViewContentType contentType) {
        this.myConsole.print(text, contentType);
    }

    @Override
    public void onNewAvailable(Printable printable) {
        printable.printOn(this.myCurrentOutputStorage);
        printable.printOn(this.myOutput);
    }

    public void updateOnTestSelected(PrintableTestProxy test) {
        if (this.myCurrentPrintable == test) {
            return;
        }
        this.myCurrentPrintable.setPrintLinstener(DEAF);
        this.myConsole.clear();
        this.myMarkOffset = 0;
        if (test == null) {
            this.myCurrentPrintable = ChangingPrintable.DEAF;
            return;
        }
        this.myCurrentPrintable = test;
        this.myCurrentPrintable.setPrintLinstener(this);
        if (test.isRoot()) {
            this.myOutputStorage.printOn(this);
        }
        this.myCurrentPrintable.printOn(this);
        this.scrollToBeginning();
    }

    @Override
    public void printHyperlink(String text, HyperlinkInfo info) {
        this.myConsole.printHyperlink(text, info);
    }

    @Override
    public void mark() {
        if (TestConsoleProperties.SCROLL_TO_STACK_TRACE.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myMarkOffset = this.myConsole.getContentSize();
        }
    }

    public void dispose() {
        this.myProperties.removeListener(TestConsoleProperties.SCROLL_TO_STACK_TRACE, this.myPropertyListener);
    }

    public void setCollectOutput(boolean doCollect) {
        this.myCurrentOutputStorage = doCollect ? this.myOutputStorage : DEAF;
    }

    public boolean canPause() {
        if (this.myCurrentPrintable instanceof AbstractTestProxy) {
            AbstractTestProxy test = (AbstractTestProxy)((Object)this.myCurrentPrintable);
            return test.isInProgress();
        }
        return false;
    }

    protected void scrollToBeginning() {
        this.myConsole.performWhenNoDeferredOutput(new Runnable(){

            @Override
            public void run() {
                TestsOutputConsolePrinter.this.myConsole.scrollTo(TestsOutputConsolePrinter.this.myMarkOffset);
            }
        });
    }
}

