/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CantRunException;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.PathUtilEx;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import java.util.HashMap;

public class JavaParametersUtil {
    public static void configureConfiguration(JavaParameters parameters, RunJavaConfiguration configuration) {
        String vmParameters;
        Project project = configuration.getProject();
        parameters.getProgramParametersList().addParametersString(configuration.getProperty(1));
        Module module = null;
        if (configuration instanceof ModuleBasedConfiguration) {
            module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule();
        }
        if ((vmParameters = configuration.getProperty(0)) != null) {
            vmParameters = JavaParametersUtil.expandPath(vmParameters, module, project);
        }
        if (parameters.getEnv() != null) {
            HashMap<String, String> envs = new HashMap<String, String>();
            for (String env : parameters.getEnv().keySet()) {
                String value = JavaParametersUtil.expandPath((String)parameters.getEnv().get(env), module, project);
                envs.put(env, value);
                if (vmParameters == null) continue;
                vmParameters = StringUtil.replace((String)vmParameters, (String)("$" + env + "$"), (String)value, (boolean)false);
            }
            parameters.setEnv(envs);
        }
        parameters.getVMParametersList().addParametersString(vmParameters);
        String workingDirectory = configuration.getProperty(2);
        if (workingDirectory == null || workingDirectory.trim().length() == 0) {
            workingDirectory = PathUtil.getLocalPath((VirtualFile)project.getBaseDir());
        }
        parameters.setWorkingDirectory(JavaParametersUtil.expandPath(workingDirectory, module, project));
    }

    private static String expandPath(String path, Module module, Project project) {
        path = PathMacroManager.getInstance((ComponentManager)project).expandPath(path);
        if (module != null) {
            path = PathMacroManager.getInstance((ComponentManager)module).expandPath(path);
        }
        return path;
    }

    public static int getClasspathType(RunConfigurationModule configurationModule, String mainClassName, boolean classMustHaveSource) throws CantRunException {
        Module module = configurationModule.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)configurationModule.getModuleName());
        }
        PsiClass psiClass = JavaExecutionUtil.findMainClass((Module)module, (String)mainClassName);
        if (psiClass == null) {
            if (!classMustHaveSource) {
                return 7;
            }
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        PsiFile psiFile = psiClass.getContainingFile();
        if (psiFile == null) {
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            throw CantRunException.classNotFound((String)mainClassName, (Module)module);
        }
        Module classModule = new JUnitUtil.ModuleOfClass().convert(psiClass);
        if (classModule == null) {
            classModule = module;
        }
        return ModuleRootManager.getInstance((Module)classModule).getFileIndex().isInTestSourceContent(virtualFile) ? 7 : 3;
    }

    public static void configureModule(RunConfigurationModule runConfigurationModule, JavaParameters parameters, int classPathType, String jreHome) throws CantRunException {
        Module module = runConfigurationModule.getModule();
        if (module == null) {
            throw CantRunException.noModuleConfigured((String)runConfigurationModule.getModuleName());
        }
        parameters.configureByModule(module, classPathType, JavaParametersUtil.createModuleJdk(module, jreHome));
    }

    public static void configureProject(Project project, JavaParameters parameters, int classPathType, String jreHome) throws CantRunException {
        parameters.configureByProject(project, classPathType, JavaParametersUtil.createProjectJdk(project, jreHome));
    }

    private static Sdk createModuleJdk(Module module, String jreHome) throws CantRunException {
        return jreHome == null ? JavaParameters.getModuleJdk((Module)module) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    private static Sdk createProjectJdk(Project project, String jreHome) throws CantRunException {
        return jreHome == null ? JavaParametersUtil.createProjectJdk(project) : JavaParametersUtil.createAlternativeJdk(jreHome);
    }

    private static Sdk createProjectJdk(Project project) throws CantRunException {
        Sdk jdk = PathUtilEx.getAnyJdk(project);
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return jdk;
    }

    private static Sdk createAlternativeJdk(String jreHome) throws CantRunException {
        Sdk jdk = JavaSdk.getInstance().createJdk("", jreHome);
        if (jdk == null) {
            throw CantRunException.noJdkConfigured();
        }
        return jdk;
    }
}

