/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.RunJavaConfiguration;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;

public class JreVersionDetector {
    private String myLastAlternativeJrePath = null;
    private boolean myLastIsJre50;

    public <T extends ModuleBasedConfiguration> boolean isJre50Configured(T configuration) {
        if (((RunJavaConfiguration)configuration).isAlternativeJrePathEnabled()) {
            if (((RunJavaConfiguration)configuration).getAlternativeJrePath().equals(this.myLastAlternativeJrePath)) {
                return this.myLastIsJre50;
            }
            this.myLastAlternativeJrePath = ((RunJavaConfiguration)configuration).getAlternativeJrePath();
            String versionString = JavaSdkImpl.getJdkVersion((String)this.myLastAlternativeJrePath);
            this.myLastIsJre50 = versionString != null && JreVersionDetector.isJre50(versionString);
            return this.myLastIsJre50;
        }
        Module module = configuration.getConfigurationModule().getModule();
        if (module != null && !module.isDisposed()) {
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
            Sdk jdk = rootManager.getSdk();
            return JreVersionDetector.isJre50(jdk);
        }
        Sdk projectJdk = ProjectRootManager.getInstance((Project)configuration.getProject()).getProjectJdk();
        return JreVersionDetector.isJre50(projectJdk);
    }

    private static boolean isJre50(Sdk jdk) {
        if (jdk == null) {
            return false;
        }
        String versionString = jdk.getVersionString();
        return versionString != null && JreVersionDetector.isJre50(versionString);
    }

    private static boolean isJre50(String versionString) {
        return versionString.contains("5.0") || versionString.contains("1.5") || versionString.contains("1.6");
    }
}

