/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.autodetecting.model;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.ProjectWideFacetAdapter;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfo;
import com.intellij.facet.impl.autodetecting.model.DetectedFacetInfoImpl;
import com.intellij.facet.impl.autodetecting.model.FacetInfo2;
import com.intellij.facet.impl.autodetecting.model.FacetInfoBackedByFacet;
import com.intellij.facet.impl.autodetecting.model.FacetInfoSet;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProjectFacetInfoSet
extends FacetInfoSet<Module> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.autodetecting.model.ProjectFacetInfoSet");
    private final Map<Facet, FacetInfoBackedByFacet> myFacetInfos = new HashMap<Facet, FacetInfoBackedByFacet>();
    private final EventDispatcher<DetectedFacetListener> myDispatcher = EventDispatcher.create(DetectedFacetListener.class);
    private int myNextId;
    private final Project myProject;

    public ProjectFacetInfoSet(Project project, Disposable parentDisposable) {
        this.myProject = project;
        ProjectWideFacetListenersRegistry.getInstance((Project)project).registerListener((ProjectWideFacetListener)new MyProjectWideFacetAdapter(), parentDisposable);
    }

    public FacetInfoBackedByFacet getOrCreateInfo(@NotNull Facet facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/ProjectFacetInfoSet.getOrCreateInfo must not be null");
        }
        FacetInfoBackedByFacet info = this.myFacetInfos.get(facet);
        if (info == null) {
            info = new FacetInfoBackedByFacet(facet, this);
            this.myFacetInfos.put(facet, info);
        }
        return info;
    }

    @Override
    public void addFacetInfo(@NotNull FacetInfo2<Module> facetInfo) {
        if (facetInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/ProjectFacetInfoSet.addFacetInfo must not be null");
        }
        super.addFacetInfo(facetInfo);
        if (facetInfo instanceof DetectedFacetInfo) {
            ((DetectedFacetListener)this.myDispatcher.getMulticaster()).facetDetected((DetectedFacetInfo)facetInfo);
        }
    }

    @Override
    public void removeFacetInfo(@NotNull FacetInfo2<Module> facetInfo) {
        if (facetInfo == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/ProjectFacetInfoSet.removeFacetInfo must not be null");
        }
        super.removeFacetInfo(facetInfo);
        if (facetInfo instanceof DetectedFacetInfo) {
            ((DetectedFacetListener)this.myDispatcher.getMulticaster()).facetRemoved((DetectedFacetInfo)facetInfo);
        }
    }

    public void loadDetectedFacets(@NotNull File file) {
        Document document;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/ProjectFacetInfoSet.loadDetectedFacets must not be null");
        }
        if (!file.exists()) {
            return;
        }
        FacetTypeRegistry facetTypeRegistry = FacetTypeRegistry.getInstance();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        try {
            document = JDOMUtil.loadDocument((File)file);
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            return;
        }
        DetectedFacetsBean detectedFacetsBean = (DetectedFacetsBean)XmlSerializer.deserialize((Document)document, DetectedFacetsBean.class);
        if (detectedFacetsBean == null) {
            return;
        }
        for (DetectedFacetBean facetBean : detectedFacetsBean.myFacets) {
            FacetType type = facetTypeRegistry.findFacetType(facetBean.myTypeId);
            if (type == null) {
                LOG.info("facet type '" + facetBean.myTypeId + " not found");
                continue;
            }
            Module module = moduleManager.findModuleByName(facetBean.myModuleName);
            if (module == null) {
                LOG.info("module '" + facetBean.myModuleName + "' not found");
                continue;
            }
            FacetInfo2 underlyingFacet = null;
            String underlyingId = facetBean.myUnderlyingId;
            if (underlyingId != null) {
                Facet facet;
                underlyingFacet = underlyingId.startsWith("/") ? this.findById(Integer.parseInt(underlyingId.substring(1))) : ((facet = FacetPointersManager.getInstance((Project)this.myProject).create(underlyingId).getFacet()) != null ? this.getOrCreateInfo(facet) : null);
            }
            FacetConfiguration configuration = type.createDefaultConfiguration();
            try {
                FacetUtil.loadFacetConfiguration(configuration, facetBean.myConfiguration);
            }
            catch (InvalidDataException e) {
                LOG.info((Throwable)e);
                continue;
            }
            int id = facetBean.myId;
            this.myNextId = Math.max(this.myNextId, id + 1);
            this.addFacetInfo((FacetInfo2<Module>)new DetectedFacetInfoImpl<Module>(facetBean.myFacetName, configuration, type, module, underlyingFacet, null, id, facetBean.myDetectorId));
        }
    }

    public void saveDetectedFacets(File file) {
        DetectedFacetsBean facetsBean = new DetectedFacetsBean();
        Collection facets = this.getAllDetectedFacets();
        HashSet<DetectedFacetInfo<Module>> added = new HashSet<DetectedFacetInfo<Module>>();
        for (DetectedFacetInfo<Module> detectedFacetInfo : facets) {
            ProjectFacetInfoSet.addFacetBean(detectedFacetInfo, facetsBean, added);
        }
        Element element = XmlSerializer.serialize((Object)facetsBean, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        try {
            FileUtil.delete((File)file);
            JDOMUtil.writeDocument((Document)new Document(element), (File)file, (String)SystemProperties.getLineSeparator());
        }
        catch (IOException iOException) {
            LOG.info((Throwable)iOException);
        }
    }

    private static boolean addFacetBean(DetectedFacetInfo<Module> facet, DetectedFacetsBean facetsBean, Set<DetectedFacetInfo<Module>> added) {
        if (!added.add(facet)) {
            return true;
        }
        FacetInfo2 underlyingInfo = facet.getUnderlyingFacetInfo();
        if (underlyingInfo instanceof DetectedFacetInfo && !ProjectFacetInfoSet.addFacetBean((DetectedFacetInfo)underlyingInfo, facetsBean, added)) {
            return false;
        }
        try {
            Element configuration = FacetUtil.saveFacetConfiguration(facet.getConfiguration());
            String underlyingId = underlyingInfo instanceof FacetInfoBackedByFacet ? FacetPointersManager.constructId((Facet)((FacetInfoBackedByFacet)underlyingInfo).getFacet()) : (underlyingInfo != null ? "/" + ((DetectedFacetInfo)underlyingInfo).getId() : null);
            DetectedFacetBean facetBean = new DetectedFacetBean(facet.getId(), facet.getFacetName(), ((Module)facet.getModule()).getName(), configuration, facet.getFacetType().getStringId(), underlyingId, facet.getDetectorId());
            facetsBean.myFacets.add(facetBean);
            return true;
        }
        catch (WriteExternalException e) {
            LOG.info((Throwable)e);
            return false;
        }
    }

    public void addListener(@NotNull DetectedFacetListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/autodetecting/model/ProjectFacetInfoSet.addListener must not be null");
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public <C extends FacetConfiguration, F extends Facet<C>> DetectedFacetInfo<Module> createInfo(Module module, String url, FacetInfo2<Module> underlyingFacet, C detectedConfiguration, String name, FacetType<F, C> facetType, String detectorId) {
        return new DetectedFacetInfoImpl<Module>(name, detectedConfiguration, facetType, module, underlyingFacet, url, this.generateId(), detectorId);
    }

    private int generateId() {
        return this.myNextId++;
    }

    @Tag(value="facet")
    public static class DetectedFacetBean {
        @Attribute(value="type")
        public String myTypeId;
        @Attribute(value="facet-name")
        public String myFacetName;
        @Attribute(value="id")
        public int myId;
        @Tag(value="configuration")
        public Element myConfiguration;
        @Attribute(value="underlying-id")
        public String myUnderlyingId;
        @Attribute(value="module-name")
        public String myModuleName;
        @Attribute(value="detector-id")
        public String myDetectorId;

        public DetectedFacetBean() {
        }

        public DetectedFacetBean(int id, String facetName, String moduleName, Element configuration, String typeId, String underlyingId, String detectorId) {
            this.myId = id;
            this.myFacetName = facetName;
            this.myConfiguration = configuration;
            this.myTypeId = typeId;
            this.myModuleName = moduleName;
            this.myUnderlyingId = underlyingId;
            this.myDetectorId = detectorId;
        }
    }

    public static class DetectedFacetsBean {
        @Tag(value="facets")
        @AbstractCollection(surroundWithTag=false)
        public List<DetectedFacetBean> myFacets = new ArrayList<DetectedFacetBean>();
    }

    public static interface DetectedFacetListener
    extends EventListener {
        public void facetDetected(DetectedFacetInfo<Module> var1);

        public void facetRemoved(DetectedFacetInfo<Module> var1);
    }

    private class MyProjectWideFacetAdapter
    extends ProjectWideFacetAdapter<Facet> {
        private MyProjectWideFacetAdapter() {
        }

        public void facetAdded(Facet facet) {
            ProjectFacetInfoSet.this.addFacetInfo(ProjectFacetInfoSet.this.getOrCreateInfo(facet));
        }

        public void facetRemoved(Facet facet) {
            FacetInfoBackedByFacet detected = (FacetInfoBackedByFacet)ProjectFacetInfoSet.this.myFacetInfos.remove(facet);
            if (detected != null) {
                ProjectFacetInfoSet.this.removeFacetInfo(detected);
            }
        }
    }
}

