/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.pointers;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.pointers.FacetPointersManagerImpl;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetPointerImpl<F extends Facet>
implements FacetPointer<F> {
    private final FacetPointersManagerImpl myManager;
    private String myModuleName;
    private String myFacetTypeId;
    private String myFacetName;
    private F myFacet;

    public FacetPointerImpl(FacetPointersManagerImpl manager, String id) {
        this.myManager = manager;
        int i = id.indexOf(47);
        this.myModuleName = id.substring(0, i);
        int j = id.lastIndexOf(47);
        this.myFacetTypeId = id.substring(i + 1, j);
        this.myFacetName = id.substring(j + 1);
    }

    public FacetPointerImpl(FacetPointersManagerImpl manager, @NotNull F facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointerImpl.<init> must not be null");
        }
        this.myManager = manager;
        this.myFacet = facet;
        this.updateInfo(this.myFacet);
        this.registerDisposable();
    }

    public void refresh() {
        this.findAndSetFacet();
        if (this.myFacet != null) {
            this.updateInfo(this.myFacet);
        }
    }

    private void findAndSetFacet() {
        if (this.myFacet == null) {
            this.myFacet = this.findFacet();
            if (this.myFacet != null) {
                this.registerDisposable();
            }
        }
    }

    private void registerDisposable() {
        Disposer.register(this.myFacet, (Disposable)new Disposable(){

            public void dispose() {
                FacetPointerImpl.this.myManager.dispose(FacetPointerImpl.this);
                FacetPointerImpl.this.myFacet = null;
            }
        });
    }

    private void updateInfo(@NotNull F facet) {
        if (facet == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointerImpl.updateInfo must not be null");
        }
        this.myModuleName = facet.getModule().getName();
        this.myFacetTypeId = facet.getType().getStringId();
        this.myFacetName = facet.getName();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myManager.getProject();
        if (project == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getProject must not return null");
        }
        return project;
    }

    public F getFacet() {
        this.findAndSetFacet();
        return this.myFacet;
    }

    @Nullable
    private F findFacet() {
        Module module = ModuleManager.getInstance((Project)this.myManager.getProject()).findModuleByName(this.myModuleName);
        if (module == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)FacetManager.getInstance((Module)module).findFacet(type.getId(), this.myFacetName);
    }

    @Nullable
    public F findFacet(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointerImpl.findFacet must not be null");
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointerImpl.findFacet must not be null");
        }
        Module module = modulesProvider.getModule(this.myModuleName);
        if (module == null) {
            return null;
        }
        FacetType<F, ?> type = this.getFacetType();
        if (type == null) {
            return null;
        }
        return (F)facetsProvider.findFacet(module, type.getId(), this.myFacetName);
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getModuleName must not return null");
        }
        return string;
    }

    @NotNull
    public String getFacetName() {
        String string = this.myFacetName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getFacetName must not return null");
        }
        return string;
    }

    @NotNull
    public String getId() {
        String string = FacetPointersManager.constructId((String)this.myModuleName, (String)this.myFacetTypeId, (String)this.myFacetName);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getId must not return null");
        }
        return string;
    }

    @NotNull
    public String getFacetTypeId() {
        String string = this.myFacetTypeId;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getFacetTypeId must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getModuleName(@Nullable ModifiableModuleModel moduleModel) {
        String string;
        String newName;
        if (moduleModel != null && this.myFacet != null && (newName = moduleModel.getNewName(this.myFacet.getModule())) != null) {
            string = newName;
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getModuleName must not return null");
            return string;
        }
        string = this.myModuleName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getModuleName must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getFacetName(@NotNull ModulesProvider modulesProvider, @NotNull FacetsProvider facetsProvider) {
        String string;
        if (modulesProvider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointerImpl.getFacetName must not be null");
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/facet/impl/pointers/FacetPointerImpl.getFacetName must not be null");
        }
        if (this.myFacet != null) {
            string = modulesProvider.getFacetModel(this.myFacet.getModule()).getFacetName(this.myFacet);
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getFacetName must not return null");
            return string;
        }
        string = this.myFacetName;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/facet/impl/pointers/FacetPointerImpl.getFacetName must not return null");
    }

    @Nullable
    public FacetType<F, ?> getFacetType() {
        return FacetTypeRegistry.getInstance().findFacetType(this.myFacetTypeId);
    }
}

