/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui;

import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.BidirectionalMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetTreeModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.FacetTreeModel");
    private static final FacetInfo ROOT = new FacetInfo(null, "", null, null);
    private final List<FacetInfo> myFacetInfos = new ArrayList<FacetInfo>();
    private final BidirectionalMap<FacetInfo, FacetInfo> myParents = new BidirectionalMap();

    public void addFacetInfo(FacetInfo info) {
        this.myFacetInfos.add(info);
        this.myParents.put((Object)info, (Object)FacetTreeModel.null2Root(info.getUnderlyingFacet()));
    }

    @NotNull
    private static FacetInfo null2Root(@Nullable FacetInfo info) {
        FacetInfo facetInfo = info == null ? ROOT : info;
        if (facetInfo == null) {
            throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/FacetTreeModel.null2Root must not return null");
        }
        return facetInfo;
    }

    @Nullable
    private static FacetInfo root2Null(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/FacetTreeModel.root2Null must not be null");
        }
        return info == ROOT ? null : info;
    }

    public FacetInfo[] getFacetInfos() {
        return this.myFacetInfos.toArray(new FacetInfo[this.myFacetInfos.size()]);
    }

    public void removeFacetInfo(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/FacetTreeModel.removeFacetInfo must not be null");
        }
        boolean removed = this.myFacetInfos.remove(info);
        LOG.assertTrue(removed);
        this.myParents.remove((Object)info);
    }

    @Nullable
    public FacetInfo getParent(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/FacetTreeModel.getParent must not be null");
        }
        return FacetTreeModel.root2Null((FacetInfo)this.myParents.get((Object)info));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public List<FacetInfo> getChildren(@Nullable FacetInfo info) {
        List<FacetInfo> list;
        List list2 = this.myParents.getKeysByValue((Object)FacetTreeModel.null2Root(info));
        if (list2 == null) {
            list = Collections.emptyList();
            if (list == null) throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/FacetTreeModel.getChildren must not return null");
            return list;
        }
        list = Collections.unmodifiableList(list2);
        if (list != null) return list;
        throw new IllegalStateException("@NotNull method com/intellij/facet/impl/ui/FacetTreeModel.getChildren must not return null");
    }

    public List<FacetInfo> getTopLevelFacets() {
        return this.getChildren(null);
    }

    public void deleteFacetWithChildren(FacetInfo info) {
        List<FacetInfo> children = this.getChildren(info);
        for (FacetInfo child : children) {
            this.deleteFacetWithChildren(child);
        }
        this.removeFacetInfo(info);
    }

    @Nullable
    public FacetInfo findNearestFacet(@NotNull FacetInfo info) {
        if (info == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/FacetTreeModel.findNearestFacet must not be null");
        }
        FacetInfo parent = this.getParent(info);
        List<FacetInfo> children = this.getChildren(parent);
        int index = children.indexOf(info);
        if (index < children.size() - 1) {
            return children.get(index + 1);
        }
        if (index > 0) {
            return children.get(index - 1);
        }
        return parent;
    }

    public boolean hasFacetOfType(@Nullable FacetInfo parent, FacetTypeId typeId) {
        List<FacetInfo> list = this.getChildren(parent);
        for (FacetInfo info : list) {
            if (info.getFacetType().getId() != typeId) continue;
            return true;
        }
        return false;
    }

    public Collection<FacetInfo> getFacetInfos(FacetType<?, ?> type) {
        FacetInfo[] facetInfos = this.getFacetInfos();
        ArrayList<FacetInfo> infos = new ArrayList<FacetInfo>();
        for (FacetInfo facetInfo : facetInfos) {
            if (!facetInfo.getFacetType().equals(type)) continue;
            infos.add(facetInfo);
        }
        return infos;
    }
}

