/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.libraries;

import com.intellij.facet.Facet;
import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionOptionsPanel;
import com.intellij.facet.impl.ui.libraries.LibraryCompositionSettings;
import com.intellij.facet.impl.ui.libraries.LibraryDownloadingMirrorsMap;
import com.intellij.facet.impl.ui.libraries.RequiredLibrariesInfo;
import com.intellij.facet.ui.FacetConfigurationQuickFix;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FacetLibrariesValidator;
import com.intellij.facet.ui.libraries.FacetLibrariesValidatorDescription;
import com.intellij.facet.ui.libraries.LibraryDownloadInfo;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.facet.ui.libraries.RemoteRepositoryInfo;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesContainer;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FacetLibrariesValidatorImpl
extends FacetLibrariesValidator {
    private final LibrariesValidatorContext myContext;
    private final FacetValidatorsManager myValidatorsManager;
    private RequiredLibrariesInfo myRequiredLibraries;
    private FacetLibrariesValidatorDescription myDescription;
    private final List<Library> myAddedLibraries = new ArrayList<Library>();

    public FacetLibrariesValidatorImpl(LibraryInfo[] requiredLibraries, FacetLibrariesValidatorDescription description, LibrariesValidatorContext context, FacetValidatorsManager validatorsManager) {
        this.myContext = context;
        this.myValidatorsManager = validatorsManager;
        this.myRequiredLibraries = new RequiredLibrariesInfo(requiredLibraries);
        this.myDescription = description;
    }

    public void setRequiredLibraries(LibraryInfo[] requiredLibraries) {
        this.myRequiredLibraries = new RequiredLibrariesInfo(requiredLibraries);
        this.onChange();
    }

    public boolean isLibrariesAdded() {
        return false;
    }

    public void setDescription(@NotNull FacetLibrariesValidatorDescription description) {
        if (description == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/facet/impl/ui/libraries/FacetLibrariesValidatorImpl.setDescription must not be null");
        }
        this.myDescription = description;
        this.onChange();
    }

    public ValidationResult check() {
        if (this.myRequiredLibraries == null) {
            return ValidationResult.OK;
        }
        ModuleRootModel rootModel = this.myContext.getRootModel();
        List<VirtualFile> roots = this.collectRoots(rootModel);
        RequiredLibrariesInfo.RequiredClassesNotFoundInfo info = this.myRequiredLibraries.checkLibraries(VfsUtil.toVirtualFileArray(roots), false);
        if (info == null) {
            return ValidationResult.OK;
        }
        String missingJars = IdeBundle.message((String)"label.missed.libraries.prefix", (Object[])new Object[0]) + " " + info.getMissingJarsText();
        String text = IdeBundle.message((String)"label.missed.libraries.text", (Object[])new Object[]{missingJars, info.getClassNames()[0]});
        LibraryInfo[] missingLibraries = info.getLibraryInfos();
        VirtualFile baseDir = this.myContext.getModule().getProject().getBaseDir();
        String baseDirPath = baseDir != null ? baseDir.getPath() : "";
        LibraryCompositionSettings libraryCompositionSettings = new LibraryCompositionSettings(missingLibraries, this.myDescription.getDefaultLibraryName(), baseDirPath, this.myDescription.getDefaultLibraryName(), null);
        return new ValidationResult(text, (FacetConfigurationQuickFix)new LibrariesQuickFix(libraryCompositionSettings));
    }

    private void onChange() {
        if (this.myValidatorsManager != null) {
            this.myValidatorsManager.validate();
        }
    }

    public void onFacetInitialized(Facet facet) {
        for (Library addedLibrary : this.myAddedLibraries) {
            this.myDescription.onLibraryAdded(facet, addedLibrary);
        }
    }

    private List<VirtualFile> collectRoots(@Nullable ModuleRootModel rootModel) {
        ArrayList<VirtualFile> roots = new ArrayList<VirtualFile>();
        if (rootModel != null) {
            CollectingLibrariesPolicy policy = new CollectingLibrariesPolicy();
            rootModel.processOrder((RootPolicy)policy, roots);
        }
        return roots;
    }

    private class LibraryCompositionDialog
    extends DialogWrapper {
        private final LibraryCompositionOptionsPanel myPanel;
        private final LibraryDownloadingMirrorsMap myMirrorsMap;

        private LibraryCompositionDialog(JComponent parent, LibraryCompositionOptionsPanel panel, LibraryDownloadingMirrorsMap mirrorsMap) {
            super((Component)parent, true);
            this.setTitle(IdeBundle.message((String)"specify.libraries.dialog.title", (Object[])new Object[0]));
            this.myPanel = panel;
            this.myMirrorsMap = mirrorsMap;
            this.init();
        }

        protected JComponent createCenterPanel() {
            return this.myPanel.getMainPanel();
        }

        protected void doOKAction() {
            this.myPanel.apply();
            final LibraryCompositionSettings settings = this.myPanel.getLibraryCompositionSettings();
            final LibrariesContainer librariesContainer = FacetLibrariesValidatorImpl.this.myContext.getLibrariesContainer();
            if (settings.downloadFiles(this.myMirrorsMap, librariesContainer, this.myPanel.getMainPanel(), false)) {
                ModifiableRootModel rootModel = FacetLibrariesValidatorImpl.this.myContext.getModifiableRootModel();
                if (rootModel == null) {
                    final ModifiableRootModel model = ModuleRootManager.getInstance((Module)FacetLibrariesValidatorImpl.this.myContext.getModule()).getModifiableModel();
                    new WriteAction(){

                        protected void run(Result result) {
                            settings.addLibraries(model, FacetLibrariesValidatorImpl.this.myAddedLibraries, librariesContainer);
                            model.commit();
                        }
                    }.execute();
                } else {
                    settings.addLibraries(rootModel, FacetLibrariesValidatorImpl.this.myAddedLibraries, librariesContainer);
                }
                super.doOKAction();
            }
        }
    }

    private class LibrariesQuickFix
    extends FacetConfigurationQuickFix {
        private final LibraryCompositionSettings myLibrarySettings;

        public LibrariesQuickFix(LibraryCompositionSettings libraryCompositionSettings) {
            super(IdeBundle.message((String)"missing.libraries.fix.button", (Object[])new Object[0]));
            this.myLibrarySettings = libraryCompositionSettings;
        }

        public void run(JComponent place) {
            LibraryDownloadingMirrorsMap mirrorsMap = new LibraryDownloadingMirrorsMap();
            for (LibraryInfo libraryInfo : this.myLibrarySettings.getLibraryInfos()) {
                RemoteRepositoryInfo repositoryInfo;
                LibraryDownloadInfo downloadingInfo = libraryInfo.getDownloadingInfo();
                if (downloadingInfo == null || (repositoryInfo = downloadingInfo.getRemoteRepository()) == null) continue;
                mirrorsMap.registerRepository(repositoryInfo);
            }
            LibraryCompositionOptionsPanel panel = new LibraryCompositionOptionsPanel(FacetLibrariesValidatorImpl.this.myContext.getLibrariesContainer(), this.myLibrarySettings, mirrorsMap);
            LibraryCompositionDialog dialog = new LibraryCompositionDialog(place, panel, mirrorsMap);
            dialog.show();
            FacetLibrariesValidatorImpl.this.onChange();
        }
    }

    private class CollectingLibrariesPolicy
    extends RootPolicy<List<VirtualFile>> {
        private final Set<Module> myProcessedModules = new HashSet<Module>();

        private CollectingLibrariesPolicy() {
        }

        public List<VirtualFile> visitLibraryOrderEntry(LibraryOrderEntry libraryOrderEntry, List<VirtualFile> value) {
            Library library = libraryOrderEntry.getLibrary();
            if (library != null) {
                value.addAll(Arrays.asList(FacetLibrariesValidatorImpl.this.myContext.getLibrariesContainer().getLibraryFiles(library, OrderRootType.CLASSES)));
            }
            return value;
        }

        public List<VirtualFile> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, List<VirtualFile> value) {
            ModuleRootModel dependency;
            Module module = moduleOrderEntry.getModule();
            if (module != null && this.myProcessedModules.add(module) && (dependency = FacetLibrariesValidatorImpl.this.myContext.getModulesProvider().getRootModel(module)) != null) {
                return (List)dependency.processOrder((RootPolicy)this, value);
            }
            return value;
        }
    }
}

