/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.jetbrains.annotations.Nullable;

class IndentInside {
    public int whiteSpaces = 0;
    public int tabs = 0;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.FormatProcessor");

    IndentInside() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentInside indent = (IndentInside)o;
        if (this.tabs != indent.tabs) {
            return false;
        }
        return this.whiteSpaces == indent.whiteSpaces;
    }

    public int hashCode() {
        int result = this.whiteSpaces;
        result = 29 * result + this.tabs;
        return result;
    }

    public int getTabsCount(CodeStyleSettings.IndentOptions options) {
        int tabsFromSpaces = this.whiteSpaces / options.TAB_SIZE;
        return this.tabs + tabsFromSpaces;
    }

    public int getSpacesCount(CodeStyleSettings.IndentOptions options) {
        return this.whiteSpaces + this.tabs * options.TAB_SIZE;
    }

    static IndentInside getLastLineIndent(String text) {
        String lastLine = IndentInside.getLastLine(text);
        if (lastLine == null) {
            return new IndentInside();
        }
        return IndentInside.createIndentOn(lastLine);
    }

    static IndentInside createIndentOn(@Nullable String lastLine) {
        IndentInside result = new IndentInside();
        if (lastLine == null) {
            return result;
        }
        for (int i = 0; i < lastLine.length(); ++i) {
            if (lastLine.charAt(i) == ' ') {
                ++result.whiteSpaces;
            }
            if (lastLine.charAt(i) != '\t') continue;
            ++result.tabs;
        }
        return result;
    }

    @Nullable
    static String getLastLine(String text) {
        if (text.endsWith("\n")) {
            return "";
        }
        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(text));
        String result = null;
        try {
            String line;
            while ((line = lineNumberReader.readLine()) != null) {
                result = line;
            }
        }
        catch (IOException e) {
            LOG.assertTrue(false);
        }
        return result;
    }
}

