/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.core.storage;

import com.intellij.history.core.storage.BrokenStorageException;
import com.intellij.history.core.storage.CachingContentStorage;
import com.intellij.history.core.storage.CompressingContentStorage;
import com.intellij.history.core.storage.IContentStorage;
import com.intellij.history.core.storage.ThreadSafeContentStorage;
import com.intellij.util.io.storage.Storage;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

public class ContentStorage
implements IContentStorage {
    private final Storage myStore;

    public ContentStorage(File f) throws IOException {
        this.myStore = Storage.create((String)f.getPath());
    }

    public static IContentStorage createContentStorage(File f) throws IOException {
        IContentStorage s = new ContentStorage(f);
        s = new CachingContentStorage(s);
        s = new CompressingContentStorage(s);
        s = new ThreadSafeContentStorage(s);
        return s;
    }

    @Override
    public void save() {
        this.myStore.force();
    }

    @Override
    public void close() {
        this.myStore.dispose();
    }

    @Override
    public int store(byte[] content) throws BrokenStorageException {
        try {
            Storage.StorageDataOutput r = this.myStore.createStream();
            r.writeInt(content.length);
            r.write(content);
            r.close();
            return r.getRecordId();
        }
        catch (Throwable e) {
            throw new BrokenStorageException(e);
        }
    }

    @Override
    public byte[] load(int id) throws BrokenStorageException {
        try {
            DataInputStream r = this.myStore.readStream(id);
            byte[] buffer = new byte[r.readInt()];
            r.readFully(buffer);
            r.close();
            return buffer;
        }
        catch (Throwable e) {
            throw new BrokenStorageException(e);
        }
    }

    @Override
    public void remove(int id) {
        this.myStore.deleteRecord(id);
    }

    @Override
    public int getVersion() {
        return this.myStore.getVersion();
    }

    @Override
    public void setVersion(int version) {
        this.myStore.setVersion(version);
    }
}

