/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.actions;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;

public abstract class LocalHistoryAction
extends AnAction {
    public void update(AnActionEvent e) {
        Presentation p = e.getPresentation();
        if (this.getProject(e) == null) {
            p.setVisible(false);
            p.setEnabled(false);
            return;
        }
        p.setVisible(true);
        p.setText(this.getText(e), true);
        p.setEnabled(this.isEnabled(this.getVcs(e), this.getGateway(e), this.getFile(e), e));
    }

    protected String getText(AnActionEvent e) {
        return e.getPresentation().getTextWithMnemonic();
    }

    protected boolean isEnabled(LocalVcs vcs, IdeaGateway gw, VirtualFile f, AnActionEvent e) {
        return true;
    }

    protected LocalVcs getVcs(AnActionEvent e) {
        return LocalHistoryComponent.getLocalVcsFor(this.getProject(e));
    }

    protected IdeaGateway getGateway(AnActionEvent e) {
        return LocalHistoryComponent.getGatewayFor(this.getProject(e));
    }

    protected VirtualFile getFile(AnActionEvent e) {
        VirtualFile[] ff = this.getFiles(e);
        return ff == null || ff.length != 1 ? null : ff[0];
    }

    private VirtualFile[] getFiles(AnActionEvent e) {
        return (VirtualFile[])e.getData(PlatformDataKeys.VIRTUAL_FILE_ARRAY);
    }

    private Project getProject(AnActionEvent e) {
        return (Project)e.getData(PlatformDataKeys.PROJECT);
    }
}

