/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.history.core.LocalVcs;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.ui.models.EntireFileHistoryDialogModel;
import com.intellij.history.integration.ui.models.FileHistoryDialogModel;
import com.intellij.history.integration.ui.views.HistoryDialog;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffPanel;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JComponent;

public class FileHistoryDialog
extends HistoryDialog<FileHistoryDialogModel> {
    private DiffPanel myDiffPanel;

    public FileHistoryDialog(IdeaGateway gw, VirtualFile f) {
        this(gw, f, true);
    }

    protected FileHistoryDialog(IdeaGateway gw, VirtualFile f, boolean doInit) {
        super(gw, f, doInit);
    }

    @Override
    protected void dispose() {
        this.myDiffPanel.dispose();
        super.dispose();
    }

    @Override
    protected FileHistoryDialogModel createModel(LocalVcs vcs) {
        return new EntireFileHistoryDialogModel(this.myGateway, vcs, this.myFile);
    }

    @Override
    protected Dimension getInitialSize() {
        Dimension ss = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(ss.width - 40, ss.height - 40);
    }

    @Override
    protected JComponent createDiffPanel() {
        this.myDiffPanel = DiffManager.getInstance().createDiffPanel(this.getWindow(), this.getProject());
        DiffPanelOptions o = ((DiffPanelEx)this.myDiffPanel).getOptions();
        o.setRequestFocusOnNewContent(false);
        this.updateDiffs();
        return this.myDiffPanel.getComponent();
    }

    @Override
    protected void updateDiffs() {
        this.myDiffPanel.setDiffRequest((DiffRequest)this.createDifference(((FileHistoryDialogModel)this.myModel).getDifferenceModel()));
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.showhistory";
    }
}

