/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class FileListPasteProvider
implements PasteProvider {
    public void performPaste(DataContext dataContext) {
        PsiDirectory dir;
        List fileList;
        Project project = (Project)LangDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || ideView == null) {
            return;
        }
        try {
            Transferable contents = CopyPasteManager.getInstance().getContents();
            fileList = (List)contents.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException e) {
            return;
        }
        catch (IOException e) {
            return;
        }
        if (fileList == null) {
            return;
        }
        ArrayList<PsiDirectory> elements = new ArrayList<PsiDirectory>();
        for (File file : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            if (vFile == null) continue;
            PsiManager instance = PsiManager.getInstance((Project)project);
            Object item = vFile.isDirectory() ? instance.findDirectory(vFile) : instance.findFile(vFile);
            if (item == null) continue;
            elements.add((PsiDirectory)item);
        }
        if (elements.size() > 0 && (dir = ideView.getOrChooseDirectory()) != null) {
            new CopyFilesOrDirectoriesHandler().doCopy(elements.toArray(new PsiElement[elements.size()]), dir);
        }
    }

    public boolean isPastePossible(DataContext dataContext) {
        return true;
    }

    public boolean isPasteEnabled(DataContext dataContext) {
        Transferable contents = CopyPasteManager.getInstance().getContents();
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        return contents.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && ideView != null;
    }
}

