/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.util.TipDialog;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.wm.ToolWindowManager;

public class TipOfTheDayManager
extends ProjectManagerAdapter
implements ApplicationComponent {
    private boolean myDoNotShowThisTime = false;
    private boolean myVeryFirstProjectOpening = true;

    public static TipOfTheDayManager getInstance() {
        return (TipOfTheDayManager)((Object)ApplicationManager.getApplication().getComponent(TipOfTheDayManager.class));
    }

    public TipOfTheDayManager(ProjectManager projectManager) {
        projectManager.addProjectManagerListener((ProjectManagerListener)this);
    }

    public String getComponentName() {
        return "TipOfTheDayManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this);
    }

    public void projectOpened(final Project project) {
        if (!this.myVeryFirstProjectOpening || !GeneralSettings.getInstance().showTipsOnStartup()) {
            return;
        }
        this.myVeryFirstProjectOpening = false;
        StartupManager.getInstance((Project)project).registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                if (TipOfTheDayManager.this.myDoNotShowThisTime) {
                    return;
                }
                ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (project.isDisposed()) {
                            return;
                        }
                        ToolWindowManager.getInstance((Project)project).invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (project.isDisposed()) {
                                    return;
                                }
                                new TipDialog().show();
                            }
                        });
                    }
                });
            }
        });
    }

    public void doNotShowThisTime() {
        this.myDoNotShowThisTime = true;
    }
}

