/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.LightColors;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.IconUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class BaseShowRecentFilesAction
extends AnAction
implements DumbAware {
    private static final Color BORDER_COLOR = new Color(135, 135, 135);

    public void actionPerformed(AnActionEvent e) {
        this.show((Project)PlatformDataKeys.PROJECT.getData(e.getDataContext()));
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(event.getDataContext());
        presentation.setEnabled(project != null);
    }

    private void show(final Project project) {
        final DefaultListModel<VirtualFile> model = new DefaultListModel<VirtualFile>();
        Object[] selectedFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles();
        VirtualFile[] files = this.filesToShow(project);
        FileEditorProviderManager editorProviderManager = FileEditorProviderManager.getInstance();
        for (int i = files.length - 1; i >= 0; --i) {
            VirtualFile file = files[i];
            if (ArrayUtil.find((Object[])selectedFiles, (Object)file) != -1 || editorProviderManager.getProviders(project, file).length <= 0) continue;
            model.addElement(file);
        }
        final JLabel pathLabel = new JLabel(" ");
        pathLabel.setHorizontalAlignment(4);
        Font font = pathLabel.getFont();
        pathLabel.setFont(font.deriveFont(10.0f));
        final JList list = new JList(model);
        list.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    Object[] values;
                    int index = list.getSelectedIndex();
                    if (index == -1 || index >= list.getModel().getSize()) {
                        return;
                    }
                    for (Object value : values = list.getSelectedValues()) {
                        VirtualFile file = (VirtualFile)value;
                        model.removeElement(file);
                        if (model.getSize() > 0) {
                            if (model.getSize() == index) {
                                list.setSelectedIndex(model.getSize() - 1);
                            } else if (model.getSize() > index) {
                                list.setSelectedIndex(index);
                            }
                        } else {
                            list.clearSelection();
                        }
                        EditorHistoryManager.getInstance(project).removeFile(file);
                    }
                }
            }
        });
        list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            private String getTitle2Text(String fullText) {
                int labelWidth = pathLabel.getWidth();
                if (fullText == null || fullText.length() == 0) {
                    return " ";
                }
                while (pathLabel.getFontMetrics(pathLabel.getFont()).stringWidth(fullText) > labelWidth) {
                    int sep = fullText.indexOf(File.separatorChar, 4);
                    if (sep < 0) {
                        return fullText;
                    }
                    fullText = "..." + fullText.substring(sep);
                }
                return fullText;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.updatePathLabel();
                    }
                });
            }

            private void updatePathLabel() {
                Object[] values = list.getSelectedValues();
                if (values != null && values.length == 1) {
                    VirtualFile parent = ((VirtualFile)values[0]).getParent();
                    if (parent != null) {
                        pathLabel.setText(this.getTitle2Text(parent.getPresentableUrl()));
                    } else {
                        pathLabel.setText(" ");
                    }
                } else {
                    pathLabel.setText(" ");
                }
            }
        });
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Object[] values;
                for (Object value : values = list.getSelectedValues()) {
                    VirtualFile file = (VirtualFile)value;
                    FileEditorManager.getInstance((Project)project).openFile(file, true);
                }
            }
        };
        if (list.getModel().getSize() == 0) {
            list.clearSelection();
        }
        list.setCellRenderer(new RecentFilesRenderer(project));
        JPanel footerPanel = new JPanel(new BorderLayout()){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(BORDER_COLOR);
                g.drawLine(0, 0, this.getWidth(), 0);
            }
        };
        footerPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        footerPanel.add(pathLabel);
        new PopupChooserBuilder(list).setTitle(this.getTitle()).setMovable(true).setSouthComponent((JComponent)footerPanel).setItemChoosenCallback(runnable).addAdditionalChooseKeystroke(BaseShowRecentFilesAction.getAdditionalSelectKeystroke()).setFilteringEnabled((Function)new Function<Object, String>(){

            public String fun(Object o) {
                return o instanceof VirtualFile ? ((VirtualFile)o).getName() : "";
            }
        }).createPopup().showCenteredInCurrentWindow(project);
    }

    protected abstract String getTitle();

    protected abstract VirtualFile[] filesToShow(Project var1);

    private static KeyStroke getAdditionalSelectKeystroke() {
        Shortcut[] shortcuts;
        for (Shortcut shortcut : shortcuts = KeymapManager.getInstance().getActiveKeymap().getShortcuts("EditSource")) {
            if (!(shortcut instanceof KeyboardShortcut)) continue;
            return ((KeyboardShortcut)shortcut).getFirstKeyStroke();
        }
        return null;
    }

    private static class RecentFilesRenderer
    extends ColoredListCellRenderer {
        private final Project myProject;

        public RecentFilesRenderer(Project project) {
            this.myProject = project;
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof VirtualFile) {
                VirtualFile virtualFile = (VirtualFile)value;
                String name = virtualFile.getPresentableName();
                this.setIcon(IconUtil.getIcon((VirtualFile)virtualFile, (int)2, (Project)this.myProject));
                FileStatus fileStatus = FileStatusManager.getInstance((Project)this.myProject).getStatus(virtualFile);
                TextAttributes attributes = new TextAttributes(fileStatus.getColor(), null, null, EffectType.LINE_UNDERSCORE, 0);
                this.append(name, SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
                if (!selected && FileEditorManager.getInstance((Project)this.myProject).isFileOpen(virtualFile)) {
                    this.setBackground(LightColors.SLIGHTLY_GREEN);
                }
            }
        }
    }
}

