/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CreateTemplateInPackageAction<T extends PsiElement>
extends AnAction {
    private final boolean myinSourceOnly;

    protected CreateTemplateInPackageAction(String text, String description, Icon icon, boolean inSourceOnly) {
        super(text, description, icon);
        this.myinSourceOnly = inSourceOnly;
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        final PsiDirectory dir = view.getOrChooseDirectory();
        if (dir == null) {
            return;
        }
        Object createdElement = this.buildDialog(project, dir).show(this.getErrorTitle(), new CreateFileFromTemplateDialog.FileCreator<T>(){

            @Override
            public void checkBeforeCreate(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateTemplateInPackageAction$1.checkBeforeCreate must not be null");
                }
                if (templateName == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/CreateTemplateInPackageAction$1.checkBeforeCreate must not be null");
                }
                CreateTemplateInPackageAction.this.checkOrCreate(name, dir, templateName, true);
            }

            @Override
            public T createFile(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateTemplateInPackageAction$1.createFile must not be null");
                }
                if (templateName == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/CreateTemplateInPackageAction$1.createFile must not be null");
                }
                return CreateTemplateInPackageAction.this.checkOrCreate(name, dir, templateName, false);
            }

            @Override
            @NotNull
            public String getActionName(@NotNull String name, @NotNull String templateName) {
                if (name == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/actions/CreateTemplateInPackageAction$1.getActionName must not be null");
                }
                if (templateName == null) {
                    throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/ide/actions/CreateTemplateInPackageAction$1.getActionName must not be null");
                }
                String string = CreateTemplateInPackageAction.this.getActionName(dir, name, templateName);
                if (string == null) {
                    throw new IllegalStateException("@NotNull method com/intellij/ide/actions/CreateTemplateInPackageAction$1.getActionName must not return null");
                }
                return string;
            }
        });
        if (createdElement != null) {
            view.selectElement(createdElement);
        }
    }

    @Nullable
    protected abstract PsiElement getNavigationElement(@NotNull T var1);

    @NotNull
    protected abstract CreateFileFromTemplateDialog.Builder buildDialog(Project var1, PsiDirectory var2);

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        boolean enabled = this.isAvailable(dataContext);
        presentation.setVisible(enabled);
        presentation.setEnabled(enabled);
    }

    protected boolean isAvailable(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project == null || view == null || view.getDirectories().length == 0) {
            return false;
        }
        if (!this.myinSourceOnly) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        for (PsiDirectory dir : view.getDirectories()) {
            if (!projectFileIndex.isInSourceContent(dir.getVirtualFile()) || JavaDirectoryService.getInstance().getPackage(dir) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private T checkOrCreate(String newName, PsiDirectory directory, String templateName, boolean check) throws IncorrectOperationException {
        PsiDirectory dir = directory;
        String className = newName;
        if (newName.contains(".")) {
            String[] names = newName.split("\\.");
            for (int i = 0; i < names.length - 1; ++i) {
                String name = names[i];
                PsiDirectory subDir = dir.findSubdirectory(name);
                if (subDir == null) {
                    if (check) {
                        dir.checkCreateSubdirectory(name);
                        return null;
                    }
                    subDir = dir.createSubdirectory(name);
                }
                dir = subDir;
            }
            className = names[names.length - 1];
        }
        if (check) {
            this.doCheckCreate(dir, className, templateName);
            return null;
        }
        return this.doCreate(dir, className, templateName);
    }

    protected void doCheckCreate(PsiDirectory dir, String className, String templateName) throws IncorrectOperationException {
        JavaDirectoryService.getInstance().checkCreateClass(dir, className);
    }

    protected abstract T doCreate(PsiDirectory var1, String var2, String var3) throws IncorrectOperationException;

    protected abstract String getActionName(PsiDirectory var1, String var2, String var3);

    protected abstract String getErrorTitle();
}

