/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.awt.RelativePoint;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class ShowPopupMenuAction
extends AnAction
implements DumbAware {
    public ShowPopupMenuAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        RelativePoint relPoint = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = focusManager.getFocusOwner();
        Point popupMenuPoint = relPoint.getPoint(focusOwner);
        Editor editor = (Editor)e.getData(PlatformDataKeys.EDITOR);
        int coord = editor != null ? Math.max(0, popupMenuPoint.y - 1) : popupMenuPoint.y;
        focusOwner.dispatchEvent(new MouseEvent(focusOwner, 501, System.currentTimeMillis(), 0, popupMenuPoint.x, coord, 1, true));
    }

    public void update(AnActionEvent e) {
        KeyboardFocusManager focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        e.getPresentation().setEnabled(focusManager.getFocusOwner() instanceof JComponent);
    }
}

