/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.commander;

import com.intellij.ide.commander.CommanderPanel;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

final class ColoredCommanderRenderer
extends ColoredListCellRenderer {
    private final CommanderPanel myCommanderPanel;

    public ColoredCommanderRenderer(@NotNull CommanderPanel commanderPanel) {
        if (commanderPanel == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/commander/ColoredCommanderRenderer.<init> must not be null");
        }
        this.myCommanderPanel = commanderPanel;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        hasFocus = selected;
        if (!this.myCommanderPanel.isActive()) {
            selected = false;
        }
        return super.getListCellRendererComponent(list, value, index, selected, hasFocus);
    }

    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        String text;
        Color color = UIUtil.getListForeground();
        SimpleTextAttributes attributes = null;
        String locationString = null;
        if (value instanceof NodeDescriptor) {
            NodeDescriptor descriptor = (NodeDescriptor)value;
            this.setIcon(descriptor.getClosedIcon());
            Color elementColor = descriptor.getColor();
            if (elementColor != null) {
                color = elementColor;
            }
            if (descriptor instanceof AbstractTreeNode) {
                TextAttributes textAttributes;
                AbstractTreeNode treeNode = (AbstractTreeNode)descriptor;
                TextAttributesKey attributesKey = treeNode.getAttributesKey();
                if (attributesKey != null && (textAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey)) != null) {
                    attributes = SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes);
                }
                locationString = treeNode.getLocationString();
            }
        }
        if (attributes == null) {
            attributes = new SimpleTextAttributes(0, color);
        }
        this.append((text = value.toString()) != null ? text : "", attributes);
        if (locationString != null && locationString.length() > 0) {
            this.append(" (" + locationString + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }
}

