/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;

public class DeleteFromFavoritesAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)("#" + DeleteFromFavoritesAction.class.getName()));

    public DeleteFromFavoritesAction() {
        super(IdeBundle.message((String)"action.remove.from.current.favorites", (Object[])new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return;
        }
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        assert (roots != null);
        assert (listName != null);
        for (FavoritesTreeNodeDescriptor root : roots) {
            Object value = root.getElement().getValue();
            LOG.assertTrue(value != null, (Object)root.getElement());
            favoritesManager.removeRoot(listName, value);
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        e.getPresentation().setEnabled(listName != null && roots != null && roots.length != 0);
    }
}

