/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView.actions;

import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesTreeNodeDescriptor;
import com.intellij.ide.favoritesTreeView.FavoritesTreeViewPanel;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import java.util.Collections;

public class SendToFavoritesAction
extends AnAction {
    private final String toName;

    public SendToFavoritesAction(String name) {
        super(name);
        this.toName = name;
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        FavoritesManager favoritesManager = FavoritesManager.getInstance(project);
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        this.doSend(favoritesManager, roots, listName);
    }

    public void doSend(FavoritesManager favoritesManager, FavoritesTreeNodeDescriptor[] roots, String listName) {
        for (FavoritesTreeNodeDescriptor root : roots) {
            AbstractTreeNode rootElement = root.getElement();
            favoritesManager.removeRoot(listName, rootElement.getValue());
            favoritesManager.addRoots(this.toName, Collections.singletonList(rootElement));
        }
    }

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FavoritesTreeNodeDescriptor[] roots = (FavoritesTreeNodeDescriptor[])FavoritesTreeViewPanel.CONTEXT_FAVORITES_ROOTS_DATA_KEY.getData(dataContext);
        if (roots == null || roots.length == 0) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String listName = (String)FavoritesTreeViewPanel.FAVORITES_LIST_NAME_DATA_KEY.getData(dataContext);
        e.getPresentation().setEnabled(listName != null);
    }
}

