/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKeys;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import org.jetbrains.annotations.Nullable;

public final class FilePackageMacro
extends Macro {
    @Override
    public String getName() {
        return "FilePackage";
    }

    @Override
    public String getDescription() {
        return IdeBundle.message((String)"macro.file.package", (Object[])new Object[0]);
    }

    @Override
    public String expand(DataContext dataContext) {
        PsiPackage aPackage = FilePackageMacro.getFilePackage(dataContext);
        if (aPackage == null) {
            return null;
        }
        return aPackage.getName();
    }

    @Nullable
    static PsiPackage getFilePackage(DataContext dataContext) {
        PsiFile psiFile = (PsiFile)DataKeys.PSI_FILE.getData(dataContext);
        if (psiFile == null) {
            return null;
        }
        PsiDirectory containingDirectory = psiFile.getContainingDirectory();
        if (containingDirectory == null || !containingDirectory.isValid()) {
            return null;
        }
        return JavaDirectoryService.getInstance().getPackage(containingDirectory);
    }
}

