/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl;

import com.intellij.ide.projectView.actions.MoveModulesOutsideGroupAction;
import com.intellij.ide.projectView.actions.MoveModulesToSubGroupAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.MoveModuleToGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveModuleToGroupTopLevel
extends ActionGroup {
    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        Module[] modules = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        boolean active = project != null && modules != null && modules.length != 0;
        e.getPresentation().setVisible(active);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        AnAction[] anActionArray;
        if (e == null) {
            anActionArray = EMPTY_ARRAY;
            if (EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/MoveModuleToGroupTopLevel.getChildren must not return null");
            return anActionArray;
        }
        ArrayList<String> topLevelGroupNames = new ArrayList<String>(MoveModuleToGroupTopLevel.getTopLevelGroupNames(e.getDataContext()));
        Collections.sort(topLevelGroupNames);
        ArrayList<Object> result = new ArrayList<Object>();
        result.add((Object)new MoveModulesOutsideGroupAction());
        result.add((Object)new MoveModulesToSubGroupAction(null));
        result.add(Separator.getInstance());
        for (String name : topLevelGroupNames) {
            result.add((Object)new MoveModuleToGroup(new ModuleGroup(new String[]{name})));
        }
        anActionArray = result.toArray(new AnAction[result.size()]);
        if (anActionArray != null) return anActionArray;
        throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/MoveModuleToGroupTopLevel.getChildren must not return null");
    }

    private static Collection<String> getTopLevelGroupNames(DataContext dataContext) {
        Project project = (Project)PlatformDataKeys.PROJECT.getData(dataContext);
        ModifiableModuleModel model = (ModifiableModuleModel)LangDataKeys.MODIFIABLE_MODULE_MODEL.getData(dataContext);
        Module[] allModules = model != null ? model.getModules() : ModuleManager.getInstance((Project)project).getModules();
        HashSet<String> topLevelGroupNames = new HashSet<String>();
        for (Module child : allModules) {
            String[] group = model != null ? model.getModuleGroupPath(child) : ModuleManager.getInstance((Project)project).getModuleGroupPath(child);
            if (group == null) continue;
            topLevelGroupNames.add(group[0]);
        }
        return topLevelGroupNames;
    }
}

