/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.Icons;
import com.intellij.util.PathUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalLibrariesNode
extends ProjectViewNode<String> {
    public ExternalLibrariesNode(Project project, ViewSettings viewSettings) {
        super(project, (Object)"External Libraries", viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode.contains must not be null");
        }
        return this.someChildContainsFile(file);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        THashSet processedLibraries = new THashSet();
        THashSet processedSdk = new THashSet();
        for (Module module : modules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                Sdk jdk;
                if (orderEntry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || processedLibraries.contains(library)) continue;
                    processedLibraries.add(library);
                    if (!ExternalLibrariesNode.hasExternalEntries(fileIndex, (OrderEntry)libraryOrderEntry)) continue;
                    String libraryName = library.getName();
                    if (libraryName == null || libraryName.length() == 0) {
                        ExternalLibrariesNode.addLibraryChildren(orderEntry, children, this.getProject(), this);
                        continue;
                    }
                    children.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(null, orderEntry), this.getSettings()));
                    continue;
                }
                if (!(orderEntry instanceof JdkOrderEntry) || (jdk = ((JdkOrderEntry)orderEntry).getJdk()) == null || processedSdk.contains(jdk)) continue;
                processedSdk.add(jdk);
                children.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(null, orderEntry), this.getSettings()));
            }
        }
        ArrayList<AbstractTreeNode> arrayList = children;
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode.getChildren must not return null");
        }
        return arrayList;
    }

    public static void addLibraryChildren(OrderEntry entry, List<AbstractTreeNode> children, Project project, ProjectViewNode node) {
        VirtualFile[] files;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file : files = entry.getFiles(OrderRootType.CLASSES)) {
            PsiDirectory psiDir = psiManager.findDirectory(file);
            if (psiDir == null) continue;
            children.add((AbstractTreeNode)new PsiDirectoryNode(project, psiDir, node.getSettings()));
        }
    }

    private static boolean hasExternalEntries(ProjectFileIndex index, OrderEntry orderEntry) {
        VirtualFile[] files;
        for (VirtualFile file : files = orderEntry.getFiles(OrderRootType.CLASSES)) {
            if (index.isInContent(PathUtil.getLocalFile((VirtualFile)file))) continue;
            return true;
        }
        return false;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(IdeBundle.message((String)"node.projectview.external.libraries", (Object[])new Object[0]));
        presentation.setIcons(Icons.LIBRARY_ICON);
    }
}

