/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.nodes.AbstractProjectNode;
import com.intellij.ide.projectView.impl.nodes.PackageUtil;
import com.intellij.ide.projectView.impl.nodes.PackageViewLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleGroupNode;
import com.intellij.ide.projectView.impl.nodes.PackageViewModuleNode;
import com.intellij.ide.projectView.impl.nodes.ProjectViewDirectoryHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPackage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class PackageViewProjectNode
extends AbstractProjectNode {
    public PackageViewProjectNode(Project project, ViewSettings viewSettings) {
        super(project, project, viewSettings);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        Collection<AbstractTreeNode> collection;
        if (this.getSettings().isShowModules()) {
            ArrayList<Module> allModules = new ArrayList<Module>(Arrays.asList(ModuleManager.getInstance((Project)this.getProject()).getModules()));
            Iterator it = allModules.iterator();
            while (it.hasNext()) {
                Module module = (Module)it.next();
                VirtualFile[] sourceRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
                if (sourceRoots.length != 0) continue;
                it.remove();
            }
            collection = this.modulesAndGroups(allModules.toArray(new Module[allModules.size()]));
            if (collection == null) throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/PackageViewProjectNode.getChildren must not return null");
            return collection;
        }
        ArrayList<VirtualFile> sourceRoots = new ArrayList<VirtualFile>();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)this.myProject);
        sourceRoots.addAll(Arrays.asList(projectRootManager.getContentSourceRoots()));
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        ArrayList<AbstractTreeNode> children = new ArrayList<AbstractTreeNode>();
        HashSet<PsiPackage> topLevelPackages = new HashSet<PsiPackage>();
        for (VirtualFile root : sourceRoots) {
            PsiDirectory directory = psiManager.findDirectory(root);
            if (directory == null) continue;
            PsiPackage directoryPackage = JavaDirectoryService.getInstance().getPackage(directory);
            if (directoryPackage == null || PackageUtil.isPackageDefault(directoryPackage)) {
                PsiDirectory[] subdirectories;
                for (PsiDirectory subdirectory : subdirectories = directory.getSubdirectories()) {
                    PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(subdirectory);
                    if (aPackage == null || PackageUtil.isPackageDefault(aPackage)) continue;
                    topLevelPackages.add(aPackage);
                }
                children.addAll(ProjectViewDirectoryHelper.getInstance(this.myProject).getDirectoryChildren(directory, this.getSettings(), false));
                continue;
            }
            topLevelPackages.add(directoryPackage);
        }
        for (PsiPackage psiPackage : topLevelPackages) {
            PackageUtil.addPackageAsChild(children, psiPackage, null, this.getSettings(), false);
        }
        if (this.getSettings().isShowLibraryContents()) {
            children.add((AbstractTreeNode)new PackageViewLibrariesNode(this.getProject(), null, this.getSettings()));
        }
        if ((collection = children) != null) return collection;
        throw new IllegalStateException("@NotNull method com/intellij/ide/projectView/impl/nodes/PackageViewProjectNode.getChildren must not return null");
    }

    @Override
    protected AbstractTreeNode createModuleGroup(Module module) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return PackageViewProjectNode.createTreeNode(PackageViewModuleNode.class, (Project)this.getProject(), (Object)module, (ViewSettings)this.getSettings());
    }

    @Override
    protected AbstractTreeNode createModuleGroupNode(ModuleGroup moduleGroup) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        return PackageViewProjectNode.createTreeNode(PackageViewModuleGroupNode.class, (Project)this.getProject(), (Object)moduleGroup, (ViewSettings)this.getSettings());
    }
}

