/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoFilter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternProvider;
import com.intellij.psi.search.TodoAttributes;
import com.intellij.psi.search.TodoPattern;
import com.intellij.util.EventDispatcher;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoConfiguration
implements ApplicationComponent,
JDOMExternalizable,
IndexPatternProvider {
    private TodoPattern[] myTodoPatterns;
    private TodoFilter[] myTodoFilters;
    private IndexPattern[] myIndexPatterns;
    private final EventDispatcher<PropertyChangeListener> myPropertyChangeMulticaster = EventDispatcher.create(PropertyChangeListener.class);
    @NonNls
    public static final String PROP_TODO_PATTERNS = "todoPatterns";
    @NonNls
    public static final String PROP_TODO_FILTERS = "todoFilters";
    @NonNls
    private static final String ELEMENT_PATTERN = "pattern";
    @NonNls
    private static final String ELEMENT_FILTER = "filter";

    TodoConfiguration() {
        Extensions.getRootArea().getExtensionPoint("com.intellij.indexPatternProvider").registerExtension((Object)this);
        this.resetToDefaultTodoPatterns();
    }

    public void resetToDefaultTodoPatterns() {
        this.myTodoPatterns = new TodoPattern[]{new TodoPattern("\\btodo\\b.*", TodoAttributes.createDefault(), false)};
        this.myTodoFilters = new TodoFilter[0];
        this.buildIndexPatterns();
    }

    private void buildIndexPatterns() {
        this.myIndexPatterns = new IndexPattern[this.myTodoPatterns.length];
        for (int i = 0; i < this.myTodoPatterns.length; ++i) {
            this.myIndexPatterns[i] = this.myTodoPatterns[i].getIndexPattern();
        }
    }

    public static TodoConfiguration getInstance() {
        return (TodoConfiguration)ApplicationManager.getApplication().getComponent(TodoConfiguration.class);
    }

    @NotNull
    public String getComponentName() {
        if ("TodoConfiguration" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/todo/TodoConfiguration.getComponentName must not return null");
        }
        return "TodoConfiguration";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public TodoPattern[] getTodoPatterns() {
        return this.myTodoPatterns;
    }

    @NotNull
    public IndexPattern[] getIndexPatterns() {
        if (this.myIndexPatterns == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/todo/TodoConfiguration.getIndexPatterns must not return null");
        }
        return this.myIndexPatterns;
    }

    public void setTodoPatterns(TodoPattern[] todoPatterns) {
        this.doSetTodoPatterns(todoPatterns, true);
    }

    private void doSetTodoPatterns(TodoPattern[] todoPatterns, boolean shouldNotifyIndices) {
        PropertyChangeListener multicaster;
        Object[] oldTodoPatterns = this.myTodoPatterns;
        Object[] oldIndexPatterns = this.myIndexPatterns;
        this.myTodoPatterns = todoPatterns;
        this.buildIndexPatterns();
        if (shouldNotifyIndices && !Arrays.deepEquals(this.myIndexPatterns, oldIndexPatterns)) {
            multicaster = (PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster();
            multicaster.propertyChange(new PropertyChangeEvent(this, "indexPatterns", oldTodoPatterns, todoPatterns));
        }
        if (!Arrays.deepEquals(this.myTodoPatterns, oldTodoPatterns)) {
            multicaster = (PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster();
            multicaster.propertyChange(new PropertyChangeEvent(this, PROP_TODO_PATTERNS, oldTodoPatterns, todoPatterns));
        }
    }

    public TodoFilter getTodoFilter(String name) {
        for (TodoFilter filter : this.myTodoFilters) {
            if (!filter.getName().equals(name)) continue;
            return filter;
        }
        return null;
    }

    public TodoFilter[] getTodoFilters() {
        return this.myTodoFilters;
    }

    public void setTodoFilters(TodoFilter[] filters) {
        TodoFilter[] oldFilters = this.myTodoFilters;
        this.myTodoFilters = filters;
        ((PropertyChangeListener)this.myPropertyChangeMulticaster.getMulticaster()).propertyChange(new PropertyChangeEvent(this, PROP_TODO_FILTERS, oldFilters, filters));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeMulticaster.addListener((EventListener)listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myPropertyChangeMulticaster.removeListener((EventListener)listener);
    }

    public void readExternal(Element element) throws InvalidDataException {
        ArrayList<TodoPattern> patternsList = new ArrayList<TodoPattern>();
        ArrayList<TodoFilter> filtersList = new ArrayList<TodoFilter>();
        for (Object o : element.getChildren()) {
            Element child = (Element)o;
            if (ELEMENT_PATTERN.equals(child.getName())) {
                TodoPattern pattern = new TodoPattern();
                pattern.readExternal(child);
                patternsList.add(pattern);
                continue;
            }
            if (!ELEMENT_FILTER.equals(child.getName())) continue;
            TodoPattern[] patterns = patternsList.toArray(new TodoPattern[patternsList.size()]);
            TodoFilter filter = new TodoFilter();
            filter.readExternal(child, patterns);
            filtersList.add(filter);
        }
        this.doSetTodoPatterns(patternsList.toArray(new TodoPattern[patternsList.size()]), false);
        this.setTodoFilters(filtersList.toArray(new TodoFilter[filtersList.size()]));
    }

    public void writeExternal(Element element) throws WriteExternalException {
        Element child;
        for (TodoPattern todoPattern : this.myTodoPatterns) {
            child = new Element(ELEMENT_PATTERN);
            todoPattern.writeExternal(child);
            element.addContent(child);
        }
        for (TodoFilter todoFilter : this.myTodoFilters) {
            child = new Element(ELEMENT_FILTER);
            todoFilter.writeExternal(child, this.myTodoPatterns);
            element.addContent(child);
        }
    }
}

