/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.gotoByName;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.util.gotoByName.ChooseByNameBase;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.statistics.StatisticsInfo;
import com.intellij.psi.statistics.StatisticsManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class ChooseByNamePopup
extends ChooseByNameBase
implements ChooseByNamePopupComponent {
    private static final Key<ChooseByNamePopup> CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY = new Key("ChooseByNamePopup");
    private Component myOldFocusOwner = null;
    private static final Pattern patternToDetectLinesAndColumns = Pattern.compile("(.*?)(?:\\:|@|,|#)(\\d+)?(?:(?:\\D)(\\d+)?)?");

    private ChooseByNamePopup(Project project, ChooseByNameModel model, ChooseByNamePopup oldPopup, PsiElement context, @Nullable String predefinedText) {
        super(project, model, oldPopup != null ? oldPopup.getEnteredText() : predefinedText, context);
        if (oldPopup == null && predefinedText != null) {
            this.setPreselectInitialText(true);
        }
        if (oldPopup != null) {
            this.myOldFocusOwner = oldPopup.myPreviouslyFocusedComponent;
        }
    }

    public String getEnteredText() {
        return this.myTextField.getText();
    }

    @Override
    protected void initUI(ChooseByNamePopupComponent.Callback callback, ModalityState modalityState, boolean allowMultipleSelection) {
        super.initUI(callback, modalityState, allowMultipleSelection);
        if (this.myInitialText != null) {
            this.rebuildList(0, 0, null, ModalityState.current());
        }
        if (this.myOldFocusOwner != null) {
            this.myPreviouslyFocusedComponent = this.myOldFocusOwner;
            this.myOldFocusOwner = null;
        }
    }

    @Override
    protected boolean isCheckboxVisible() {
        return true;
    }

    @Override
    protected boolean isShowListForEmptyPattern() {
        return false;
    }

    @Override
    protected boolean isCloseByFocusLost() {
        return true;
    }

    @Override
    protected void showList() {
        JLayeredPane layeredPane = this.myTextField.getRootPane().getLayeredPane();
        Rectangle bounds = this.myTextFieldPanel.getBounds();
        bounds.y += this.myTextFieldPanel.getHeight();
        Dimension preferredScrollPaneSize = this.myListScrollPane.getPreferredSize();
        preferredScrollPaneSize.width = Math.max(this.myTextFieldPanel.getWidth(), preferredScrollPaneSize.width);
        if (bounds.y + preferredScrollPaneSize.height > layeredPane.getHeight()) {
            preferredScrollPaneSize.height = layeredPane.getHeight() - bounds.y;
        }
        if (preferredScrollPaneSize.width > layeredPane.getWidth() - bounds.x) {
            bounds.x = layeredPane.getX() + Math.max(1, layeredPane.getWidth() - preferredScrollPaneSize.width);
            if (preferredScrollPaneSize.width > layeredPane.getWidth() - bounds.x) {
                preferredScrollPaneSize.width = layeredPane.getWidth() - bounds.x;
                JScrollBar horizontalScrollBar = this.myListScrollPane.getHorizontalScrollBar();
                if (horizontalScrollBar != null) {
                    preferredScrollPaneSize.height = (int)((double)preferredScrollPaneSize.height + horizontalScrollBar.getPreferredSize().getHeight());
                }
            }
        }
        Rectangle prefferedBounds = new Rectangle(bounds.x, bounds.y, preferredScrollPaneSize.width, preferredScrollPaneSize.height);
        if (this.myListScrollPane.isVisible()) {
            this.myListScrollPane.setBounds(prefferedBounds);
        }
        layeredPane.add((Component)this.myListScrollPane, (Object)600);
        layeredPane.moveToFront(this.myListScrollPane);
        this.myListScrollPane.validate();
        this.myListScrollPane.setVisible(true);
    }

    @Override
    protected void hideList() {
        if (this.myListScrollPane.isVisible()) {
            this.myListScrollPane.setVisible(false);
        }
    }

    @Override
    protected void close(boolean isOk) {
        if (this.myDisposedFlag) {
            return;
        }
        if (isOk) {
            this.myModel.saveInitialCheckBoxState(this.myCheckBox.isSelected());
            List<Object> chosenElements = this.getChosenElements();
            if (chosenElements != null) {
                for (Object element : chosenElements) {
                    this.myActionListener.elementChosen(element);
                    String text = this.myModel.getFullName(element);
                    if (text == null) continue;
                    StatisticsManager.getInstance().incUseCount(new StatisticsInfo(this.statisticsContext(), text));
                }
            } else {
                return;
            }
            if (!chosenElements.isEmpty()) {
                String enteredText = this.getEnteredText();
                if (enteredText.indexOf(42) >= 0) {
                    FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.wildcards");
                } else {
                    for (Object element : chosenElements) {
                        String name = this.myModel.getElementName(element);
                        if (name == null || StringUtil.startsWithIgnoreCase((String)name, (String)enteredText)) continue;
                        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.camelprefix");
                        break;
                    }
                }
            } else {
                return;
            }
        }
        this.myDisposedFlag = true;
        this.myAlarm.cancelAllRequests();
        this.myProject.putUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, null);
        this.cleanupUI();
        this.myActionListener.onClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupUI() {
        JLayeredPane layeredPane = null;
        try {
            JRootPane rootPane;
            Component owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (owner != null && SwingUtilities.isDescendingFrom(owner, this.myTextField)) {
                if (this.myPreviouslyFocusedComponent instanceof JComponent && this.myPreviouslyFocusedComponent.isShowing()) {
                    JComponent _component = (JComponent)this.myPreviouslyFocusedComponent;
                    LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(_component);
                }
                if (this.myPreviouslyFocusedComponent != null) {
                    this.myPreviouslyFocusedComponent.requestFocus();
                }
            }
            if ((rootPane = this.myTextFieldPanel.getRootPane()) != null) {
                layeredPane = rootPane.getLayeredPane();
                layeredPane.remove(this.myListScrollPane);
                layeredPane.remove(this.myTextFieldPanel);
            }
        }
        finally {
            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
        }
        if (layeredPane != null) {
            layeredPane.validate();
            layeredPane.repaint();
        }
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model, PsiElement context) {
        return ChooseByNamePopup.createPopup(project, model, context, null);
    }

    public static ChooseByNamePopup createPopup(Project project, ChooseByNameModel model, PsiElement context, @Nullable String predefinedText) {
        ChooseByNamePopup oldPopup = (ChooseByNamePopup)project.getUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        ChooseByNamePopup newPopup = new ChooseByNamePopup(project, model, oldPopup, context, predefinedText);
        project.putUserData(CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)newPopup);
        return newPopup;
    }

    @Override
    public String getNamePattern(String pattern) {
        Matcher matcher;
        if ((pattern.indexOf(58) != -1 || pattern.indexOf(44) != -1 || pattern.indexOf(59) != -1 || pattern.indexOf(35) != -1 || pattern.indexOf(64) != -1) && (matcher = patternToDetectLinesAndColumns.matcher(pattern)).matches()) {
            pattern = matcher.group(1);
        }
        return super.getNamePattern(pattern);
    }

    public int getLinePosition() {
        return this.getLineOrColumn(true);
    }

    private int getLineOrColumn(boolean line) {
        Matcher matcher = patternToDetectLinesAndColumns.matcher(this.getEnteredText());
        if (matcher.matches()) {
            int groupNumber = line ? 2 : 3;
            try {
                String group;
                if (groupNumber <= matcher.groupCount() && (group = matcher.group(groupNumber)) != null) {
                    return Integer.parseInt(group) - 1;
                }
                if (!line && this.getLineOrColumn(true) != -1) {
                    return 0;
                }
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getColumnPosition() {
        return this.getLineOrColumn(false);
    }
}

