/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard.modes;

import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.projectImport.ImportChooserStep;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.Function;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportMode
extends WizardMode {
    @Override
    @NotNull
    public String getDisplayName(WizardContext context) {
        String string = ProjectBundle.message((String)"project.new.wizard.import.title", (Object[])new Object[]{context.getPresentationName()});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/ImportMode.getDisplayName must not return null");
        }
        return string;
    }

    @Override
    @NotNull
    public String getDescription(WizardContext context) {
        String productName = ApplicationNamesInfo.getInstance().getProductName();
        String string = ProjectBundle.message((String)"project.new.wizard.import.description", (Object[])new Object[]{productName, context.getPresentationName(), StringUtil.join(Arrays.asList(Extensions.getExtensions(ProjectImportProvider.PROJECT_IMPORT_PROVIDER)), (Function)new Function<ProjectImportProvider, String>(){

            public String fun(ProjectImportProvider provider) {
                return provider.getName();
            }
        }, (String)", ")});
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/ide/util/newProjectWizard/modes/ImportMode.getDescription must not return null");
        }
        return string;
    }

    @Override
    @Nullable
    protected StepSequence createSteps(WizardContext context, ModulesProvider modulesProvider) {
        StepSequence stepSequence = new StepSequence(null);
        ProjectImportProvider[] providers = (ProjectImportProvider[])Extensions.getExtensions(ProjectImportProvider.PROJECT_IMPORT_PROVIDER);
        stepSequence.addCommonStep(new ImportChooserStep(providers, stepSequence, context));
        for (ProjectImportProvider provider : providers) {
            ModuleWizardStep[] steps = provider.createSteps(context);
            StepSequence sequence = new StepSequence(stepSequence);
            for (ModuleWizardStep step : steps) {
                sequence.addCommonStep(step);
            }
            stepSequence.addSpecificSteps(provider.getId(), sequence);
        }
        return stepSequence;
    }

    @Override
    public boolean isAvailable(WizardContext context) {
        return ((ProjectImportProvider[])Extensions.getExtensions(ProjectImportProvider.PROJECT_IMPORT_PROVIDER)).length > 0;
    }

    @Override
    @Nullable
    public ProjectBuilder getModuleBuilder() {
        return null;
    }

    @Override
    @Nullable
    public JComponent getAdditionalSettings() {
        return null;
    }

    @Override
    public void onChosen(boolean enabled) {
    }
}

