/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageFilter;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.CompositeLanguageFileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class XmlFileViewProvider
extends CompositeLanguageFileViewProvider {
    private Set<Language> myRelevantLanguages = null;
    private final XMLLanguage myLanguage;

    public XmlFileViewProvider(PsiManager manager, VirtualFile virtualFile, boolean physical, XMLLanguage language) {
        super(manager, virtualFile, physical, (Language)language);
        this.myLanguage = language;
        assert (!(this.myLanguage instanceof TemplateLanguage));
    }

    @Override
    public void contentsSynchronized() {
        super.contentsSynchronized();
        this.myRelevantLanguages = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public Set<Language> getLanguages() {
        Set<Language> set;
        if (this.myRelevantLanguages != null) {
            set = this.myRelevantLanguages;
            if (set == null) throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFileViewProvider.getLanguages must not return null");
            return set;
        }
        ArrayList<XMLLanguage> relevantLanguages = new ArrayList<XMLLanguage>(1);
        relevantLanguages.add(this.myLanguage);
        relevantLanguages.addAll(Arrays.asList(this.myLanguage.getLanguageExtensionsForFile(this.getPsi((Language)this.myLanguage))));
        set = this.myRelevantLanguages = new LinkedHashSet<Language>(relevantLanguages);
        if (this.myRelevantLanguages != null) return set;
        throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFileViewProvider.getLanguages must not return null");
    }

    @Override
    protected boolean isRelevantLanguage(Language lang) {
        return this.myLanguage == lang || super.isRelevantLanguage(lang);
    }

    @Override
    @NotNull
    public LanguageFilter[] getLanguageExtensions() {
        LanguageFilter[] languageFilterArray = this.myLanguage.getLanguageExtensions();
        if (languageFilterArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/xml/XmlFileViewProvider.getLanguageExtensions must not return null");
        }
        return languageFilterArray;
    }

    @Override
    protected XmlFileViewProvider cloneInner(VirtualFile copy) {
        return new XmlFileViewProvider(this.getManager(), copy, false, this.myLanguage);
    }
}

