/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.mock.MockGlobalSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.file.impl.FileManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.FactoryMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MockFileManager
implements FileManager {
    private final PsiManagerEx myManager;
    private final FactoryMap<VirtualFile, FileViewProvider> myViewProviders = new FactoryMap<VirtualFile, FileViewProvider>(){

        protected FileViewProvider create(VirtualFile key) {
            return new SingleRootFileViewProvider(MockFileManager.this.myManager, key);
        }
    };

    @Override
    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file, boolean physical) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.createFileViewProvider must not be null");
        }
        SingleRootFileViewProvider singleRootFileViewProvider = new SingleRootFileViewProvider(this.myManager, file, physical);
        if (singleRootFileViewProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockFileManager.createFileViewProvider must not return null");
        }
        return singleRootFileViewProvider;
    }

    public MockFileManager(PsiManagerEx manager) {
        this.myManager = manager;
    }

    @Override
    public void dispose() {
        throw new UnsupportedOperationException("Method dispose is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void runStartupActivity() {
        throw new UnsupportedOperationException("Method runStartupActivity is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile findFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.findFile must not be null");
        }
        return this.getCachedPsiFile(vFile);
    }

    @Override
    @Nullable
    public PsiDirectory findDirectory(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.findDirectory must not be null");
        }
        throw new UnsupportedOperationException("Method findDirectory is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public void reloadFromDisk(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.reloadFromDisk must not be null");
        }
        throw new UnsupportedOperationException("Method reloadFromDisk is not yet implemented in " + this.getClass().getName());
    }

    @Override
    @Nullable
    public PsiFile getCachedPsiFile(@NotNull VirtualFile vFile) {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.getCachedPsiFile must not be null");
        }
        FileViewProvider provider = this.findCachedViewProvider(vFile);
        return provider.getPsi(provider.getBaseLanguage());
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.getResolveScope must not be null");
        }
        MockGlobalSearchScope mockGlobalSearchScope = new MockGlobalSearchScope();
        if (mockGlobalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockFileManager.getResolveScope must not return null");
        }
        return mockGlobalSearchScope;
    }

    @Override
    @NotNull
    public GlobalSearchScope getUseScope(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.getUseScope must not be null");
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)element.getProject());
        if (globalSearchScope == null) {
            throw new IllegalStateException("@NotNull method com/intellij/mock/MockFileManager.getUseScope must not return null");
        }
        return globalSearchScope;
    }

    @Override
    public void cleanupForNextTest() {
        this.myViewProviders.clear();
    }

    @Override
    public FileViewProvider findViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.findViewProvider must not be null");
        }
        throw new UnsupportedOperationException("Method findViewProvider is not yet implemented in " + this.getClass().getName());
    }

    @Override
    public FileViewProvider findCachedViewProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.findCachedViewProvider must not be null");
        }
        return (FileViewProvider)this.myViewProviders.get((Object)file);
    }

    @Override
    public void setViewProvider(@NotNull VirtualFile virtualFile, FileViewProvider fileViewProvider) {
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/mock/MockFileManager.setViewProvider must not be null");
        }
        this.myViewProviders.put((Object)virtualFile, (Object)fileViewProvider);
    }

    @Override
    public List<PsiFile> getAllCachedFiles() {
        throw new UnsupportedOperationException("Method getAllCachedFiles is not yet implemented in " + this.getClass().getName());
    }
}

