/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.concurrency.JobScheduler;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.IdeNotificationArea;
import com.intellij.notification.impl.NotificationModelListener;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.notification.impl.ui.NotificationsListPanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationComponent
extends JLabel
implements NotificationModelListener {
    private static final Icon EMPTY_ICON = IconLoader.getIcon((String)"/ide/notifications.png");
    private static final Icon READ_ICON = IconLoader.getIcon((String)"/ide/read_notifications.png");
    private static final Icon ERROR_ICON = IconLoader.getIcon((String)"/ide/error_notifications.png");
    private static final Icon WARNING_ICON = IconLoader.getIcon((String)"/ide/warning_notifications.png");
    private static final Icon INFO_ICON = IconLoader.getIcon((String)"/ide/info_notifications.png");
    private WeakReference<JBPopup> myPopupRef;
    private BlinkIconWrapper myCurrentIcon;
    private boolean myBlinkIcon;
    private IdeNotificationArea myArea;

    public NotificationComponent(@NotNull IdeNotificationArea area) {
        if (area == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationComponent.<init> must not be null");
        }
        this.myBlinkIcon = true;
        this.myArea = area;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (UIUtil.isActionClick((MouseEvent)e)) {
                    NotificationComponent.this.toggleList();
                }
            }
        });
        this.myCurrentIcon = new BlinkIconWrapper(EMPTY_ICON, false);
        this.setIcon(this.myCurrentIcon);
        JobScheduler.getScheduler().scheduleAtFixedRate(new IconBlinker(), 1L, 1L, TimeUnit.SECONDS);
    }

    private static NotificationsManagerImpl getManager() {
        return NotificationsManagerImpl.getNotificationsManagerImpl();
    }

    @Override
    public void removeNotify() {
        NotificationComponent.getManager().removeListener(this);
        this.cancelPopup();
        super.removeNotify();
    }

    private void cancelPopup() {
        if (this.myPopupRef != null) {
            JBPopup popup = (JBPopup)this.myPopupRef.get();
            if (popup != null) {
                popup.cancel();
            }
            this.myPopupRef = null;
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        NotificationComponent.getManager().addListener(this);
    }

    private void toggleList() {
        JBPopup popup = null;
        if (this.myPopupRef != null) {
            popup = (JBPopup)this.myPopupRef.get();
            this.myPopupRef = null;
        }
        if (popup != null && popup.isVisible()) {
            popup.cancel();
        } else {
            this.myPopupRef = new WeakReference<JBPopup>(NotificationsListPanel.show(this.getProject(), this));
        }
    }

    public void updateStatus() {
        NotificationsManagerImpl manager = NotificationComponent.getManager();
        Icon icon = EMPTY_ICON;
        NotificationType maximumType = manager.getMaximumType(this.getProject());
        if (maximumType != null) {
            switch (maximumType) {
                case WARNING: {
                    icon = WARNING_ICON;
                    break;
                }
                case ERROR: {
                    icon = ERROR_ICON;
                    break;
                }
                default: {
                    icon = INFO_ICON;
                }
            }
        }
        this.myCurrentIcon = new BlinkIconWrapper(icon, false);
        this.setIcon(this.myCurrentIcon);
        if (manager.count(this.getProject()) == 0) {
            this.cancelPopup();
        }
        this.repaint();
    }

    @Nullable
    public Project getProject() {
        return this.myArea.getProject();
    }

    @Override
    public void notificationsAdded(Notification ... notifications) {
        if (notifications == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationComponent.notificationsAdded must not be null");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationComponent.this.updateStatus();
            }
        });
    }

    @Override
    public void notificationsRead(Notification ... notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationComponent.notificationsRead must not be null");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationComponent.this.updateStatus();
            }
        });
    }

    @Override
    public void notificationsRemoved(Notification ... notifications) {
        if (notifications == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationComponent.notificationsRemoved must not be null");
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotificationComponent.this.updateStatus();
            }
        });
    }

    private void blinkIcon(boolean visible) {
        this.myCurrentIcon.setPaint(visible);
    }

    private class BlinkIconWrapper
    implements Icon {
        private Icon myOriginal;
        private boolean myPaint;
        private boolean myBlink;
        private BufferedImage myGrayscaleImage;

        private BlinkIconWrapper(Icon original, boolean blink) {
            if (original == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationComponent$BlinkIconWrapper.<init> must not be null");
            }
            this.myOriginal = original;
            this.myBlink = blink;
        }

        public void setPaint(boolean paint) {
            if (paint != this.myPaint) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        NotificationComponent.this.repaint();
                    }
                });
            }
            this.myPaint = paint;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (!NotificationComponent.this.myBlinkIcon) {
                if (this.myGrayscaleImage == null) {
                    this.myGrayscaleImage = new BufferedImage(this.myOriginal.getIconWidth(), this.myOriginal.getIconHeight(), 10);
                    Graphics2D gi = this.myGrayscaleImage.createGraphics();
                    gi.setComposite(AlphaComposite.getInstance(3, 0.2f));
                    this.myOriginal.paintIcon(c, gi, 0, 0);
                    gi.dispose();
                }
                g.drawImage(this.myGrayscaleImage, x, y, null);
            } else if (!this.myBlink || !this.myPaint) {
                this.myOriginal.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return this.myOriginal.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.myOriginal.getIconHeight();
        }
    }

    private class IconBlinker
    implements Runnable {
        private boolean myVisible;

        private IconBlinker() {
        }

        @Override
        public void run() {
            this.myVisible = !this.myVisible;
            NotificationComponent.this.blinkIcon(this.myVisible);
        }
    }
}

