/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification.impl.ui;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.ui.MessageType;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotificationsUtil {
    private NotificationsUtil() {
    }

    public static String buildHtml(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsUtil.buildHtml must not be null");
        }
        return "<html><b>" + notification.getTitle() + "</b><p>" + notification.getContent() + "</p></html>";
    }

    @Nullable
    public static HyperlinkListener wrapListener(final @NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsUtil.wrapListener must not be null");
        }
        NotificationListener listener = notification.getListener();
        if (listener == null) {
            return null;
        }
        return new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                NotificationListener listener1;
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && (listener1 = notification.getListener()) != null) {
                    listener1.hyperlinkUpdate(notification, e);
                }
            }
        };
    }

    public static Icon getIcon(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsUtil.getIcon must not be null");
        }
        Icon icon = notification.getIcon();
        if (icon != null) {
            return icon;
        }
        switch (notification.getType()) {
            case ERROR: {
                return MessageType.ERROR.getDefaultIcon();
            }
            case WARNING: {
                return MessageType.WARNING.getDefaultIcon();
            }
        }
        return MessageType.INFO.getDefaultIcon();
    }

    public static Color getBackground(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/notification/impl/ui/NotificationsUtil.getBackground must not be null");
        }
        switch (notification.getType()) {
            case ERROR: {
                return MessageType.ERROR.getPopupBackground();
            }
            case WARNING: {
                return MessageType.WARNING.getPopupBackground();
            }
        }
        return MessageType.INFO.getPopupBackground();
    }
}

