/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.actionSystem.impl.WeakTimerListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.ex.WeakKeymapManagerListener;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ActionToolbarImpl
extends JPanel
implements ActionToolbar {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.ActionToolbarImpl");
    private final ArrayList<Rectangle> myComponentBounds = new ArrayList();
    private Dimension myMinimumButtonSize;
    private int myLayoutPolicy;
    private int myOrientation;
    private final ActionGroup myActionGroup;
    private final String myPlace;
    private final MyKeymapManagerListener myKeymapManagerListener;
    private final MyTimerListener myTimerListener;
    private ArrayList<AnAction> myNewVisibleActions;
    protected ArrayList<AnAction> myVisibleActions;
    private final PresentationFactory myPresentationFactory;
    private boolean myAdjustTheSameSize;
    private final ActionButtonLook myButtonLook = null;
    private final DataManager myDataManager;
    protected final ActionManagerEx myActionManager;
    private Rectangle myAutoPopupRec;
    private static final Icon myAutoPopupIcon = IconLoader.getIcon((String)"/ide/link.png");
    private static final Icon mySecondaryGroupIcon = IconLoader.getIcon((String)"/general/secondaryGroup.png");
    private final DefaultActionGroup mySecondaryActions = new DefaultActionGroup();
    private ActionButton mySecondaryActionsButton;
    private final KeymapManagerEx myKeymapManager;
    private int myFirstOusideIndex = -1;
    private JBPopup myPopup;
    private JComponent myTargetComponent;
    private boolean myReservePlaceAutoPopupIcon = true;

    public ActionToolbarImpl(String place, ActionGroup actionGroup, boolean horizontal, DataManager dataManager, ActionManagerEx actionManager, KeymapManagerEx keymapManager) {
        super(null);
        this.myActionManager = actionManager;
        this.myKeymapManager = keymapManager;
        this.setMinimumButtonSize(DEFAULT_MINIMUM_BUTTON_SIZE);
        this.setLayoutPolicy(2);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.myPlace = place;
        this.myActionGroup = actionGroup;
        this.myPresentationFactory = new PresentationFactory();
        this.myKeymapManagerListener = new MyKeymapManagerListener();
        this.myTimerListener = new MyTimerListener();
        this.myVisibleActions = new ArrayList();
        this.myNewVisibleActions = new ArrayList();
        this.myDataManager = dataManager;
        this.setLayout(new BorderLayout());
        this.setOrientation(horizontal ? 0 : 1);
        this.mySecondaryActions.getTemplatePresentation().setIcon(mySecondaryGroupIcon);
        this.mySecondaryActions.setPopup(true);
        this.updateActions();
        keymapManager.addKeymapManagerListener(new WeakKeymapManagerListener(keymapManager, this.myKeymapManagerListener));
        actionManager.addTimerListener(500, new WeakTimerListener(actionManager, this.myTimerListener));
        this.enableEvents(48L);
    }

    private void updateActions() {
        Application app = ApplicationManager.getApplication();
        if (!app.isUnitTestMode() && !app.isHeadlessEnvironment()) {
            if (app.isDispatchThread()) {
                this.updateActionsImmediately();
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)this, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ActionToolbarImpl.this.updateActionsImmediately();
                    }
                });
            }
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public int getLayoutPolicy() {
        return this.myLayoutPolicy;
    }

    public void setLayoutPolicy(int layoutPolicy) {
        if (layoutPolicy != 0 && layoutPolicy != 1 && layoutPolicy != 2) {
            throw new IllegalArgumentException("wrong layoutPolicy: " + layoutPolicy);
        }
        this.myLayoutPolicy = layoutPolicy;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myLayoutPolicy == 2 && this.myAutoPopupRec != null) {
            if (this.myOrientation == 0) {
                int dy = this.myAutoPopupRec.height / 2 - myAutoPopupIcon.getIconHeight() / 2;
                myAutoPopupIcon.paintIcon(this, g, (int)this.myAutoPopupRec.getMaxX() - myAutoPopupIcon.getIconWidth() - 1, this.myAutoPopupRec.y + dy);
            } else {
                int dx = this.myAutoPopupRec.width / 2 - myAutoPopupIcon.getIconWidth() / 2;
                myAutoPopupIcon.paintIcon(this, g, this.myAutoPopupRec.x + dx, (int)this.myAutoPopupRec.getMaxY() - myAutoPopupIcon.getIconWidth() - 1);
            }
        }
    }

    private void fillToolBar(ArrayList<AnAction> actions, boolean layoutSecondaries) {
        for (int i = 0; i < actions.size(); ++i) {
            AnAction action = actions.get(i);
            if (layoutSecondaries && !this.myActionGroup.isPrimary(action)) {
                this.mySecondaryActions.add(action);
                continue;
            }
            if (action instanceof Separator) {
                if (i <= 0 || i >= actions.size() - 1) continue;
                this.add(new MySeparator());
                continue;
            }
            if (action instanceof CustomComponentAction) {
                this.add(((CustomComponentAction)action).createCustomComponent(this.myPresentationFactory.getPresentation(action)));
                continue;
            }
            ActionButton button = this.createToolbarButton(action);
            this.add(button);
        }
        if (this.mySecondaryActions.getChildrenCount() > 0) {
            this.mySecondaryActionsButton = new SecondaryButton((AnAction)this.mySecondaryActions, this.myPresentationFactory.getPresentation((AnAction)this.mySecondaryActions), this.myPlace, DEFAULT_MINIMUM_BUTTON_SIZE);
            this.mySecondaryActionsButton.setNoIconsInPopup(true);
            this.add(this.mySecondaryActionsButton);
        }
    }

    public ActionButton createToolbarButton(AnAction action, ActionButtonLook look, String place, Presentation presentation, Dimension minimumSize) {
        if (action.displayTextInToolbar()) {
            return new ActionButtonWithText(action, presentation, place, minimumSize);
        }
        ActionButton actionButton = new ActionButton(action, presentation, place, minimumSize){

            @Override
            protected DataContext getDataContext() {
                return ActionToolbarImpl.this.getToolbarDataContext();
            }
        };
        actionButton.setLook(look);
        return actionButton;
    }

    private ActionButton createToolbarButton(AnAction action) {
        return this.createToolbarButton(action, this.myButtonLook, this.myPlace, this.myPresentationFactory.getPresentation(action), this.myMinimumButtonSize);
    }

    @Override
    public void doLayout() {
        int componentCount;
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
        }
        LOG.assertTrue((componentCount = this.getComponentCount()) <= this.myComponentBounds.size());
        for (int i = componentCount - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            component.setBounds(this.myComponentBounds.get(i));
        }
    }

    @Override
    public void validate() {
        if (!this.isValid()) {
            this.calculateBounds(this.getSize(), this.myComponentBounds);
            super.validate();
        }
    }

    private int getMaxButtonWidth() {
        int width = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Dimension dimension = this.getComponent(i).getPreferredSize();
            width = Math.max(width, dimension.width);
        }
        return width;
    }

    public int getMaxButtonHeight() {
        int height = 0;
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Dimension dimension = this.getComponent(i).getPreferredSize();
            height = Math.max(height, dimension.height);
        }
        return height;
    }

    private void calculateBoundsNowrapImpl(ArrayList<Rectangle> bounds) {
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.myAdjustTheSameSize) {
            int maxWidth = this.getMaxButtonWidth();
            int maxHeight = this.getMaxButtonHeight();
            if (this.myOrientation == 0) {
                int xOffset = 0;
                for (int i = 0; i < componentCount; ++i) {
                    Rectangle r = bounds.get(i);
                    r.setBounds(xOffset, (height - maxHeight) / 2, maxWidth, maxHeight);
                    xOffset += maxWidth;
                }
            } else {
                int yOffset = 0;
                for (int i = 0; i < componentCount; ++i) {
                    Rectangle r = bounds.get(i);
                    r.setBounds((width - maxWidth) / 2, yOffset, maxWidth, maxHeight);
                    yOffset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int maxHeight = this.getMaxButtonHeight();
            int xOffset = 0;
            boolean yOffset = false;
            for (int i = 0; i < componentCount; ++i) {
                Component component = this.getComponent(i);
                Dimension d = component.getPreferredSize();
                Rectangle r = bounds.get(i);
                r.setBounds(xOffset, 0 + (maxHeight - d.height) / 2, d.width, d.height);
                xOffset += d.width;
            }
        } else {
            int maxWidth = this.getMaxButtonWidth();
            boolean xOffset = false;
            int yOffset = 0;
            for (int i = 0; i < componentCount; ++i) {
                Component component = this.getComponent(i);
                Dimension d = component.getPreferredSize();
                Rectangle r = bounds.get(i);
                r.setBounds(0 + (maxWidth - d.width) / 2, yOffset, d.width, d.height);
                yOffset += d.height;
            }
        }
    }

    private void calculateBoundsAutoImp(Dimension sizeToFit, ArrayList<Rectangle> bounds) {
        boolean actualLayout;
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        boolean bl = actualLayout = bounds == this.myComponentBounds;
        if (actualLayout) {
            this.myAutoPopupRec = null;
        }
        int autoButtonSize = myAutoPopupIcon.getIconWidth();
        boolean full = false;
        if (this.myOrientation == 0) {
            int eachX = 0;
            int eachY = 0;
            for (int i = 0; i < componentCount; ++i) {
                Component eachComp = this.getComponent(i);
                boolean isLast = i == componentCount - 1;
                Rectangle eachBound = new Rectangle(eachComp.getPreferredSize());
                if (!full) {
                    boolean inside;
                    if (isLast) {
                        inside = eachX + eachBound.width <= sizeToFit.width;
                    } else {
                        boolean bl2 = inside = eachX + eachBound.width + autoButtonSize <= sizeToFit.width;
                    }
                    if (inside) {
                        if (eachComp == this.mySecondaryActionsButton) {
                            assert (isLast);
                            if (sizeToFit.width != Integer.MAX_VALUE) {
                                eachBound.x = sizeToFit.width - eachBound.width;
                                eachX = (int)eachBound.getMaxX();
                            } else {
                                eachBound.x = eachX;
                            }
                        } else {
                            eachBound.x = eachX;
                            eachX += eachBound.width;
                        }
                        eachBound.y = eachY;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(eachX, eachY, sizeToFit.width - eachX - 1, sizeToFit.height - 1);
                        this.myFirstOusideIndex = i;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds.get(i).setBounds(eachBound);
            }
        } else {
            int eachX = 0;
            int eachY = 0;
            for (int i = 0; i < componentCount; ++i) {
                Rectangle eachBound = new Rectangle(this.getComponent(i).getPreferredSize());
                if (!full) {
                    boolean outside;
                    if (i < componentCount - 1) {
                        outside = eachY + eachBound.height + autoButtonSize < sizeToFit.height;
                    } else {
                        boolean bl3 = outside = eachY + eachBound.height < sizeToFit.height;
                    }
                    if (outside) {
                        eachBound.x = eachX;
                        eachBound.y = eachY;
                        eachY += eachBound.height;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    if (this.myAutoPopupRec == null) {
                        this.myAutoPopupRec = new Rectangle(eachX, eachY, sizeToFit.width - 1, sizeToFit.height - eachY - 1);
                        this.myFirstOusideIndex = i;
                    }
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                bounds.get(i).setBounds(eachBound);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateBoundsWrapImpl(Dimension sizeToFit, ArrayList<Rectangle> bounds) {
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            try {
                this.setLayoutPolicy(0);
                this.calculateBoundsNowrapImpl(bounds);
            }
            finally {
                this.setLayoutPolicy(1);
            }
            return;
        }
        int componentCount = this.getComponentCount();
        LOG.assertTrue(componentCount <= bounds.size());
        if (this.myAdjustTheSameSize) {
            if (this.myOrientation == 0) {
                int maxWidth = this.getMaxButtonWidth();
                int maxHeight = this.getMaxButtonHeight();
                int xOffset = 0;
                int yOffset = 0;
                int maxRowWidth = Math.max(sizeToFit.width, componentCount * maxWidth / 3);
                for (int i = 0; i < componentCount; ++i) {
                    if (xOffset + maxWidth > maxRowWidth) {
                        xOffset = 0;
                        yOffset += maxHeight;
                    }
                    Rectangle each = bounds.get(i);
                    each.setBounds(xOffset, maxWidth, yOffset, maxHeight);
                    xOffset += maxWidth;
                }
            } else {
                int maxWidth = this.getMaxButtonWidth();
                int maxHeight = this.getMaxButtonHeight();
                int xOffset = 0;
                int yOffset = 0;
                int maxRowHeight = Math.max(sizeToFit.height, componentCount * this.myMinimumButtonSize.height / 3);
                for (int i = 0; i < componentCount; ++i) {
                    if (yOffset + maxHeight > maxRowHeight) {
                        yOffset = 0;
                        xOffset += maxWidth;
                    }
                    Rectangle each = bounds.get(i);
                    each.setBounds(xOffset, maxWidth, yOffset, maxHeight);
                    yOffset += maxHeight;
                }
            }
        } else if (this.myOrientation == 0) {
            int rowHeight = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i = 0; i < componentCount; ++i) {
                dims[i] = this.getComponent(i).getPreferredSize();
                int height = dims[i].height;
                rowHeight = Math.max(rowHeight, height);
            }
            int xOffset = 0;
            int yOffset = 0;
            int maxRowWidth = Math.max(this.getWidth(), componentCount * this.myMinimumButtonSize.width / 3);
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = dims[i];
                if (xOffset + d.width > maxRowWidth) {
                    xOffset = 0;
                    yOffset += rowHeight;
                }
                Rectangle each = bounds.get(i);
                each.setBounds(xOffset, yOffset + (rowHeight - d.height) / 2, d.width, d.height);
                xOffset += d.width;
            }
        } else {
            int rowWidth = 0;
            Dimension[] dims = new Dimension[componentCount];
            for (int i = 0; i < componentCount; ++i) {
                dims[i] = this.getComponent(i).getPreferredSize();
                int width = dims[i].width;
                rowWidth = Math.max(rowWidth, width);
            }
            int xOffset = 0;
            int yOffset = 0;
            int maxRowHeight = Math.max(this.getHeight(), componentCount * this.myMinimumButtonSize.height / 3);
            for (int i = 0; i < componentCount; ++i) {
                Dimension d = dims[i];
                if (yOffset + d.height > maxRowHeight) {
                    yOffset = 0;
                    xOffset += rowWidth;
                }
                Rectangle each = bounds.get(i);
                each.setBounds(xOffset + (rowWidth - d.width) / 2, yOffset, d.width, d.height);
                yOffset += d.height;
            }
        }
    }

    private void calculateBounds(Dimension size2Fit, ArrayList<Rectangle> bounds) {
        bounds.clear();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            bounds.add(new Rectangle());
        }
        if (this.myLayoutPolicy == 0) {
            this.calculateBoundsNowrapImpl(bounds);
        } else if (this.myLayoutPolicy == 1) {
            this.calculateBoundsWrapImpl(size2Fit, bounds);
        } else if (this.myLayoutPolicy == 2) {
            this.calculateBoundsAutoImp(size2Fit, bounds);
        } else {
            throw new IllegalStateException("unknonw layoutPolicy: " + this.myLayoutPolicy);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        ArrayList<Rectangle> bounds = new ArrayList<Rectangle>();
        this.calculateBounds(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE), bounds);
        int xLeft = Integer.MAX_VALUE;
        int yTop = Integer.MAX_VALUE;
        int xRight = Integer.MIN_VALUE;
        int yBottom = Integer.MIN_VALUE;
        for (int i = bounds.size() - 1; i >= 0; --i) {
            Rectangle each = bounds.get(i);
            if (each.x == Integer.MAX_VALUE) continue;
            xLeft = Math.min(xLeft, each.x);
            yTop = Math.min(yTop, each.y);
            xRight = Math.max(xRight, each.x + each.width);
            yBottom = Math.max(yBottom, each.y + each.height);
        }
        Dimension dimension = new Dimension(xRight - xLeft, yBottom - yTop);
        if (this.myLayoutPolicy == 2 && this.myReservePlaceAutoPopupIcon) {
            if (this.myOrientation == 0) {
                dimension.width += myAutoPopupIcon.getIconWidth();
            } else {
                dimension.height += myAutoPopupIcon.getIconHeight();
            }
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.myLayoutPolicy == 2) {
            return new Dimension(myAutoPopupIcon.getIconWidth(), this.myMinimumButtonSize.height);
        }
        return super.getMinimumSize();
    }

    public void adjustTheSameSize(boolean value) {
        if (this.myAdjustTheSameSize == value) {
            return;
        }
        this.myAdjustTheSameSize = value;
        this.revalidate();
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionToolbarImpl.setMinimumButtonSize must not be null");
        }
        this.myMinimumButtonSize = size;
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof ActionButton)) continue;
            ActionButton button = (ActionButton)component;
            button.setMinimumButtonSize(size);
        }
        this.revalidate();
    }

    public void setOrientation(int orientation) {
        if (0 != orientation && 1 != orientation) {
            throw new IllegalArgumentException("wrong orientation: " + orientation);
        }
        this.myOrientation = orientation;
    }

    public void updateActionsImmediately() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myNewVisibleActions.clear();
        DataContext dataContext = this.getDataContext();
        Utils.expandActionGroup(this.myActionGroup, this.myNewVisibleActions, this.myPresentationFactory, dataContext, this.myPlace, this.myActionManager);
        if (!this.myNewVisibleActions.equals(this.myVisibleActions)) {
            boolean changeBarVisibility = this.myNewVisibleActions.isEmpty() || this.myVisibleActions.isEmpty();
            ArrayList<AnAction> temp = this.myVisibleActions;
            this.myVisibleActions = this.myNewVisibleActions;
            this.myNewVisibleActions = temp;
            this.removeAll();
            this.mySecondaryActions.removeAll();
            this.mySecondaryActionsButton = null;
            this.fillToolBar(this.myVisibleActions, this.getLayoutPolicy() == 2 && this.myOrientation == 0);
            if (changeBarVisibility) {
                this.revalidate();
            } else {
                Container parent = this.getParent();
                if (parent != null) {
                    parent.invalidate();
                    parent.validate();
                }
            }
            this.repaint();
        }
    }

    public void setTargetComponent(JComponent component) {
        this.myTargetComponent = component;
        if (this.myTargetComponent != null && this.myTargetComponent.isVisible()) {
            ApplicationManager.getApplication().invokeLater((Runnable)new DumbAwareRunnable(){

                public void run() {
                    ActionToolbarImpl.this.updateActions();
                }
            }, ModalityState.stateForComponent((Component)this.myTargetComponent));
        }
    }

    protected DataContext getToolbarDataContext() {
        return this.getDataContext();
    }

    protected DataContext getDataContext() {
        return this.myTargetComponent != null ? this.myDataManager.getDataContext((Component)this.myTargetComponent) : ((DataManagerImpl)this.myDataManager).getDataContextTest(this);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        super.processMouseMotionEvent(e);
        if (this.getLayoutPolicy() != 2) {
            return;
        }
        if (this.myAutoPopupRec != null && this.myAutoPopupRec.contains(e.getPoint())) {
            this.showAutoPopup();
        }
    }

    private void showAutoPopup() {
        Point location;
        ActionGroup group;
        if (this.isPopupShowing()) {
            return;
        }
        if (this.myOrientation == 0) {
            group = this.myActionGroup;
        } else {
            DefaultActionGroup outside = new DefaultActionGroup();
            for (int i = this.myFirstOusideIndex; i < this.myVisibleActions.size(); ++i) {
                outside.add(this.myVisibleActions.get(i));
            }
            group = outside;
        }
        PopupToolbar popupToolbar = new PopupToolbar(this.myPlace, group, true, this.myDataManager, this.myActionManager, this.myKeymapManager){

            @Override
            protected void onOtherActionPerformed() {
                ActionToolbarImpl.this.hidePopup();
            }

            @Override
            protected DataContext getDataContext() {
                return ActionToolbarImpl.this.getDataContext();
            }
        };
        popupToolbar.setLayoutPolicy(0);
        if (this.myOrientation == 0) {
            location = this.getLocationOnScreen();
        } else {
            location = this.getLocationOnScreen();
            location.y = location.y + this.getHeight() - popupToolbar.getPreferredSize().height;
        }
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)popupToolbar, null);
        builder.setResizable(false).setRequestFocus(false).setTitle(null).setCancelOnClickOutside(true).setCancelOnOtherWindowOpen(true).setCancelCallback((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                return ActionToolbarImpl.this.myActionManager.isActionPopupStackEmpty();
            }
        }).setCancelOnMouseOutCallback(new MouseChecker(){

            public boolean check(MouseEvent event) {
                return ActionToolbarImpl.this.myAutoPopupRec != null && ActionToolbarImpl.this.myActionManager.isActionPopupStackEmpty() && !new RelativeRectangle((Component)ActionToolbarImpl.this, ActionToolbarImpl.this.myAutoPopupRec).contains(new RelativePoint(event));
            }
        });
        builder.addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                ActionToolbarImpl.this.processClosed();
            }
        });
        this.myPopup = builder.createPopup();
        Disposer.register((Disposable)this.myPopup, (Disposable)popupToolbar);
        this.myPopup.showInScreenCoordinates((Component)this, location);
        final Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            final ComponentAdapter componentAdapter = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    ActionToolbarImpl.this.hidePopup();
                }
            };
            window.addComponentListener(componentAdapter);
            Disposer.register((Disposable)popupToolbar, (Disposable)new Disposable(){

                public void dispose() {
                    window.removeComponentListener(componentAdapter);
                }
            });
        }
    }

    private boolean isPopupShowing() {
        return this.myPopup != null && this.myPopup.getContent() != null;
    }

    private void hidePopup() {
        if (this.myPopup != null) {
            this.myPopup.cancel();
            this.processClosed();
        }
    }

    private void processClosed() {
        if (this.myPopup == null) {
            return;
        }
        Disposer.dispose((Disposable)this.myPopup);
        this.myPopup = null;
        this.updateActionsImmediately();
    }

    public void setReservePlaceAutoPopupIcon(boolean reserve) {
        this.myReservePlaceAutoPopupIcon = reserve;
    }

    public void setSecondaryActionsTooltip(String secondaryActionsTooltip) {
        this.mySecondaryActions.getTemplatePresentation().setDescription(secondaryActionsTooltip);
    }

    private static class SecondaryButton
    extends ActionButton {
        private SecondaryButton(AnAction action, Presentation presentation, String place, @NotNull Dimension minimumSize) {
            if (minimumSize == null) {
                throw new IllegalArgumentException("Argument 3 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/ActionToolbarImpl$SecondaryButton.<init> must not be null");
            }
            super(action, presentation, place, minimumSize);
        }

        @Override
        protected void paintButtonLook(Graphics g) {
            Color bright = new Color(255, 255, 255, 200);
            Color dark = new Color(64, 64, 64, 110);
            int padding = 3;
            g.setColor(bright);
            g.drawLine(0, padding, 0, this.getHeight() - padding - 1);
            g.setColor(dark);
            g.drawLine(1, padding, 1, this.getHeight() - padding - 1);
            super.paintButtonLook(g);
        }
    }

    static abstract class PopupToolbar
    extends ActionToolbarImpl
    implements AnActionListener,
    Disposable {
        public PopupToolbar(String place, ActionGroup actionGroup, boolean horizontal, DataManager dataManager, ActionManagerEx actionManager, KeymapManagerEx keymapManager) {
            super(place, actionGroup, horizontal, dataManager, actionManager, keymapManager);
            this.myActionManager.addAnActionListener(this);
        }

        public void dispose() {
            this.myActionManager.removeAnActionListener(this);
        }

        @Override
        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        @Override
        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            if (!this.myVisibleActions.contains(action)) {
                this.onOtherActionPerformed();
            }
        }

        protected abstract void onOtherActionPerformed();

        @Override
        public void beforeEditorTyping(char c, DataContext dataContext) {
        }
    }

    private final class MyTimerListener
    implements TimerListener {
        private MyTimerListener() {
        }

        public ModalityState getModalityState() {
            return ModalityState.stateForComponent((Component)ActionToolbarImpl.this);
        }

        public void run() {
            Dialog dialog;
            if (!ActionToolbarImpl.this.isShowing()) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] selectedPath = menuSelectionManager.getSelectedPath();
            if (selectedPath.length > 0) {
                return;
            }
            Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
            if (window instanceof Dialog && (dialog = (Dialog)window).isModal() && !SwingUtilities.isDescendingFrom(ActionToolbarImpl.this, dialog)) {
                return;
            }
            ActionToolbarImpl.this.updateActionsImmediately();
        }
    }

    private final class MyKeymapManagerListener
    implements KeymapManagerListener {
        private MyKeymapManagerListener() {
        }

        public void activeKeymapChanged(Keymap keymap) {
            int componentCount = ActionToolbarImpl.this.getComponentCount();
            for (int i = 0; i < componentCount; ++i) {
                Component component = ActionToolbarImpl.this.getComponent(i);
                if (!(component instanceof ActionButton)) continue;
                ((ActionButton)component).updateToolTipText();
            }
        }
    }

    private final class MySeparator
    extends JComponent {
        private final Dimension mySize;

        public MySeparator() {
            this.mySize = ActionToolbarImpl.this.myOrientation == 0 ? new Dimension(6, 24) : new Dimension(24, 6);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.mySize;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(UIUtil.getSeparatorShadow());
            if (this.getParent() != null) {
                if (ActionToolbarImpl.this.myOrientation == 0) {
                    UIUtil.drawLine((Graphics)g, (int)3, (int)2, (int)3, (int)(this.getParent().getSize().height - 2));
                } else {
                    UIUtil.drawLine((Graphics)g, (int)2, (int)3, (int)(this.getParent().getSize().width - 2), (int)3);
                }
            }
        }
    }
}

