/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.Utils");
    @NonNls
    public static final String NOTHING_HERE = "Nothing here";
    public static final AnAction EMPTY_MENU_FILLER = new AnAction("Nothing here"){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(AnActionEvent e) {
        }

        public void update(AnActionEvent e) {
            e.getPresentation().setEnabled(false);
            super.update(e);
        }
    };

    private Utils() {
    }

    private static void handleUpdateException(AnAction action, Presentation presentation, Throwable exc) {
        String id = ActionManager.getInstance().getId(action);
        if (id != null) {
            LOG.error("update failed for AnAction with ID=" + id, exc);
        } else {
            LOG.error("update failed for ActionGroup: " + action + "[" + presentation.getText() + "]", exc);
        }
    }

    public static void expandActionGroup(@NotNull ActionGroup group, ArrayList<AnAction> list, PresentationFactory presentationFactory, DataContext context, String place, ActionManager actionManager) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/Utils.expandActionGroup must not be null");
        }
        Presentation presentation = presentationFactory.getPresentation((AnAction)group);
        AnActionEvent e = new AnActionEvent(null, context, place, presentation, actionManager, 0);
        if (!Utils.doUpdate((AnAction)group, e, presentation)) {
            return;
        }
        if (!presentation.isVisible()) {
            return;
        }
        AnAction[] children = group.getChildren(e);
        for (int i = 0; i < children.length; ++i) {
            AnAction child = children[i];
            if (child == null) {
                String groupId = ActionManager.getInstance().getId((AnAction)group);
                LOG.error("action is null: i=" + i + " group=" + group + " group id=" + groupId);
                continue;
            }
            presentation = presentationFactory.getPresentation(child);
            AnActionEvent e1 = new AnActionEvent(null, context, place, presentation, actionManager, 0);
            e1.setInjectedContext(child.isInInjectedContext());
            if (!Utils.doUpdate(child, e1, presentation) || !presentation.isVisible()) continue;
            if (child instanceof ActionGroup) {
                ActionGroup actionGroup = (ActionGroup)child;
                if (actionGroup.isPopup()) {
                    boolean enabled = actionGroup.canBePerformed(context) || Utils.hasVisibleChildren(actionGroup, presentationFactory, context, place);
                    presentation.setEnabled(enabled);
                    list.add(child);
                    continue;
                }
                Utils.expandActionGroup((ActionGroup)child, list, presentationFactory, context, place, actionManager);
                continue;
            }
            if (child instanceof Separator) {
                if (list.isEmpty() || list.get(list.size() - 1) instanceof Separator) continue;
                list.add(child);
                continue;
            }
            list.add(child);
        }
    }

    private static boolean doUpdate(AnAction action, AnActionEvent e, Presentation presentation) throws ProcessCanceledException {
        boolean result;
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            result = !ActionUtil.performDumbAwareUpdate((AnAction)action, (AnActionEvent)e, (boolean)false);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable exc) {
            Utils.handleUpdateException(action, presentation, exc);
            return false;
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime > 10L && LOG.isDebugEnabled()) {
            LOG.debug("Action " + action + ": updated in " + (endTime - startTime) + " ms");
        }
        return result;
    }

    private static boolean hasVisibleChildren(ActionGroup group, PresentationFactory factory, DataContext context, String place) {
        AnAction[] children;
        AnActionEvent event = new AnActionEvent(null, context, place, factory.getPresentation((AnAction)group), ActionManager.getInstance(), 0);
        event.setInjectedContext(group.isInInjectedContext());
        for (AnAction anAction : children = group.getChildren(event)) {
            ActionGroup childGroup;
            Project project;
            if (anAction instanceof Separator || (project = (Project)PlatformDataKeys.PROJECT.getData(context)) != null && DumbService.getInstance((Project)project).isDumb() && !(anAction instanceof DumbAware) && !(anAction instanceof ActionGroup)) continue;
            LOG.assertTrue(anAction != null, (Object)("Null action found in group " + group));
            Presentation presentation = factory.getPresentation(anAction);
            Utils.updateGroupChild(context, place, anAction, presentation);
            if (!(anAction instanceof ActionGroup ? (!(childGroup = (ActionGroup)anAction).isPopup() || presentation.isVisible()) && Utils.hasVisibleChildren(childGroup, factory, context, place) : presentation.isVisible())) continue;
            return true;
        }
        return false;
    }

    public static void updateGroupChild(DataContext context, String place, AnAction anAction, Presentation presentation) {
        AnActionEvent event1 = new AnActionEvent(null, context, place, presentation, ActionManager.getInstance(), 0);
        event1.setInjectedContext(anAction.isInInjectedContext());
        Utils.doUpdate(anAction, event1, presentation);
    }

    public static void fillMenu(final @NotNull ActionGroup group, final JComponent component, boolean enableMnemonics, final PresentationFactory presentationFactory, DataContext context, final String place, boolean isWindowMenu, final boolean mayDataContextBeInvalid) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/actionSystem/impl/Utils.fillMenu must not be null");
        }
        final ActionCallback menuBuilt = new ActionCallback();
        ArrayList<AnAction> list = new ArrayList<AnAction>();
        Utils.expandActionGroup(group, list, presentationFactory, context, place, ActionManager.getInstance());
        boolean fixMacScreenMenu = SystemInfo.isMacSystemMenu && isWindowMenu && Registry.is((String)"actionSystem.mac.screenMenuNotUpdatedFix");
        final ArrayList<JMenuItem> children = new ArrayList<JMenuItem>();
        for (int i = 0; i < list.size(); ++i) {
            AnAction action = list.get(i);
            if (action instanceof Separator) {
                if (i <= 0 || i >= list.size() - 1) continue;
                component.add(new JPopupMenu.Separator());
                continue;
            }
            if (action instanceof ActionGroup && (!((ActionGroup)action).canBePerformed(context) || Utils.hasVisibleChildren((ActionGroup)action, presentationFactory, context, place))) {
                ActionMenu menu = new ActionMenu(context, place, (ActionGroup)action, presentationFactory, enableMnemonics);
                component.add(menu);
                children.add(menu);
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action, presentationFactory.getPresentation(action), place, context, enableMnemonics, !fixMacScreenMenu);
            component.add(each);
            children.add(each);
        }
        if (list.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context, enableMnemonics, !fixMacScreenMenu);
            component.add(each);
            children.add(each);
        }
        if (fixMacScreenMenu) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (Component each : children) {
                        if (each.getParent() == null || !(each instanceof ActionMenuItem)) continue;
                        ((ActionMenuItem)each).prepare();
                    }
                    menuBuilt.setDone();
                }
            });
        } else {
            menuBuilt.setDone();
        }
        menuBuilt.doWhenDone(new Runnable(){

            @Override
            public void run() {
                if (!mayDataContextBeInvalid) {
                    return;
                }
                if (IdeFocusManager.getInstance(null).isFocusBeingTransferred()) {
                    IdeFocusManager.getInstance(null).doWhenFocusSettlesDown(new Runnable(){

                        @Override
                        public void run() {
                            if (!component.isShowing()) {
                                return;
                            }
                            DataContext context = DataManager.getInstance().getDataContext();
                            Utils.expandActionGroup(group, new ArrayList<AnAction>(), presentationFactory, context, place, ActionManager.getInstance());
                            for (Component each : children) {
                                if (each instanceof ActionMenuItem) {
                                    ((ActionMenuItem)each).updateContext(context);
                                    continue;
                                }
                                if (!(each instanceof ActionMenu)) continue;
                                ((ActionMenu)each).updateContext(context);
                            }
                        }
                    });
                }
            }
        });
    }
}

