/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ImportOldConfigsPanel;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.ui.UIUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.PropertyResourceBundle;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ConfigImportHelper {
    @NonNls
    private static final String BUILD_NUMBER_FILE = "build.txt";
    @NonNls
    private static final String PLUGINS_PATH = "plugins";
    @NonNls
    private static final String BIN_FOLDER = "bin";

    private ConfigImportHelper() {
    }

    public static void importConfigsTo(String newConfigPath) {
        block1: {
            File oldConfigDir;
            ImportOldConfigsPanel dlg;
            File instHome;
            do {
                dlg = UIUtil.hasJdk6Dialogs() ? new ImportOldConfigsPanel() : new ImportOldConfigsPanel(JOptionPane.getRootFrame());
                UIUtil.setToolkitModal((JDialog)dlg);
                AppUIUtil.updateDialogIcon(dlg);
                dlg.setVisible(true);
                if (!dlg.isImportEnabled()) break block1;
            } while (!ConfigImportHelper.validateOldConfigDir(instHome = dlg.getSelectedFile(), oldConfigDir = ConfigImportHelper.getOldConfigDir(instHome)));
            ConfigImportHelper.doImport(newConfigPath, oldConfigDir);
        }
    }

    public static void doImport(String newConfigPath, File oldConfigDir) {
        try {
            ConfigImportHelper.xcopy(oldConfigDir, new File(newConfigPath));
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.unable.to.import.settings", (Object[])new Object[]{e.getMessage()}), ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), 2);
        }
    }

    public static boolean validateOldConfigDir(File instHome, File oldConfigDir) {
        if (oldConfigDir == null) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.invalid.installation.home", (Object[])new Object[]{instHome.getAbsolutePath(), ApplicationNamesInfo.getInstance().getFullProductName()}));
            return false;
        }
        if (!oldConfigDir.exists()) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), ApplicationBundle.message((String)"error.no.settings.path", (Object[])new Object[]{oldConfigDir.getAbsolutePath()}), ApplicationBundle.message((String)"title.settings.import.failed", (Object[])new Object[0]), 2);
            return false;
        }
        return true;
    }

    public static void xcopy(File src, File dest) throws IOException {
        src = src.getCanonicalFile();
        dest = dest.getCanonicalFile();
        if (!src.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{src.getAbsolutePath()}));
        }
        if (!dest.isDirectory()) {
            throw new IOException(ApplicationBundle.message((String)"config.import.invalid.directory.error", (Object[])new Object[]{dest.getAbsolutePath()}));
        }
        FileUtil.copyDir((File)src, (File)dest);
        File plugins = new File(dest, PLUGINS_PATH);
        if (plugins.exists()) {
            FileUtil.delete((File)plugins);
        }
    }

    @Nullable
    public static File getOldConfigDir(File oldInstallHome) {
        File[] launchFileCandidates;
        int oldBuildNumber = ConfigImportHelper.getBuildNumber(oldInstallHome);
        if (oldBuildNumber != -1 && oldBuildNumber <= 600) {
            return new File(oldInstallHome, "config");
        }
        for (File file : launchFileCandidates = ConfigImportHelper.getLaunchFilesCandidates(oldInstallHome)) {
            File probableConfig;
            String configDir;
            if (!file.exists() || (configDir = PathManager.substituteVars((String)ConfigImportHelper.getConfigFromLaxFile(file), (String)oldInstallHome.getPath())) == null || !(probableConfig = new File(configDir)).exists()) continue;
            return probableConfig;
        }
        return null;
    }

    private static File[] getLaunchFilesCandidates(File instHome) {
        File bin = new File(instHome, BIN_FOLDER);
        return new File[]{new File(bin, "idea.properties"), new File(bin, "idea.lax"), new File(bin, "idea.bat"), new File(bin, "idea.sh"), new File(new File(instHome, "Contents"), "Info.plist"), new File(new File(new File(bin, "idea.app"), "Contents"), "Info.plist"), new File(new File(new File(instHome, "idea.app"), "Contents"), "Info.plist")};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getConfigFromLaxFile(File file) {
        String configParam;
        if (file.getName().endsWith(".properties")) {
            try {
                PropertyResourceBundle bundle;
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(file));
                try {
                    bundle = new PropertyResourceBundle(fis);
                }
                finally {
                    ((InputStream)fis).close();
                }
                return bundle.getString("idea.config.path");
            }
            catch (IOException e) {
                return null;
            }
        }
        String fileContent = ConfigImportHelper.getContent(file);
        int idx = fileContent.indexOf(configParam = "idea.config.path=");
        if (idx == -1) {
            configParam = "<key>idea.config.path</key>";
            idx = fileContent.indexOf(configParam);
            if (idx == -1) {
                return null;
            }
            if ((idx = fileContent.indexOf("<string>", idx)) == -1) {
                return null;
            }
            return ConfigImportHelper.fixDirName(fileContent.substring(idx += "<string>".length(), fileContent.indexOf("</string>", idx)), true);
        }
        String configDir = "";
        if (fileContent.length() > (idx += configParam.length())) {
            if (fileContent.charAt(idx) == '\"') {
                ++idx;
                while (fileContent.length() > idx && fileContent.charAt(idx) != '\"' && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            } else {
                while (fileContent.length() > idx && !Character.isSpaceChar(fileContent.charAt(idx)) && fileContent.charAt(idx) != '\n' && fileContent.charAt(idx) != '\r') {
                    configDir = configDir + fileContent.charAt(idx);
                    ++idx;
                }
            }
        }
        if ((configDir = ConfigImportHelper.fixDirName(configDir, true)).length() > 0) {
            configDir = new File(configDir).getPath();
        }
        return configDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static String getContent(File file) {
        try {
            StringBuffer content = new StringBuffer();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    content.append(line);
                    content.append('\n');
                }
            }
            finally {
                reader.close();
            }
            return content.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String fixDirName(String dir, boolean replaceUserHome) {
        if (StringUtil.startsWithChar((CharSequence)dir, (char)'\"') && StringUtil.endsWithChar((CharSequence)dir, (char)'\"')) {
            dir = dir.substring(1, dir.length() - 1);
        }
        if (replaceUserHome && (dir.startsWith("~\\") || dir.startsWith("~//") || StringUtil.startsWithConcatenationOf((String)dir, (String)"~", (String)File.separator))) {
            dir = SystemProperties.getUserHome() + dir.substring(1);
        }
        return dir;
    }

    public static boolean isInstallationHome(String installationHome) {
        File[] files;
        boolean quickTest;
        String mainJarName = StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getProductName()) + ".jar";
        boolean bl = quickTest = new File(new File(installationHome, "lib"), mainJarName).exists() && new File(installationHome, BIN_FOLDER).exists();
        if (!quickTest) {
            return false;
        }
        for (File file : files = ConfigImportHelper.getLaunchFilesCandidates(new File(installationHome))) {
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private static int getBuildNumber(File installDirectory) {
        File buildTxt = new File(installDirectory = installDirectory.getAbsoluteFile(), BUILD_NUMBER_FILE);
        if (!buildTxt.exists() || buildTxt.isDirectory()) {
            buildTxt = new File(new File(installDirectory, BIN_FOLDER), BUILD_NUMBER_FILE);
        }
        if (buildTxt.exists() && !buildTxt.isDirectory()) {
            int buildNumber = -1;
            String buildNumberText = ConfigImportHelper.getContent(buildTxt);
            if (buildNumberText != null) {
                try {
                    if (buildNumberText.length() > 1) {
                        buildNumberText = buildNumberText.trim();
                        buildNumber = Integer.parseInt(buildNumberText);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return buildNumber;
        }
        return -1;
    }
}

