/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ProjectTopics;
import com.intellij.history.LocalHistory;
import com.intellij.history.core.LocalVcs;
import com.intellij.history.core.changes.Change;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.impl.ChangeRange;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoProvider;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.command.undo.UnexpectedUndoException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.io.IOException;

public class FileUndoProvider
extends VirtualFileAdapter
implements UndoProvider {
    public static final Logger LOG = Logger.getInstance((String)("#" + FileUndoProvider.class.getName()));
    private final Key<DocumentReference> DELETION_WAS_UNDOABLE = new Key("DeletionWasUndoable");
    private final Project myProject;
    private boolean myIsInsideCommand;
    private LocalVcs myLocalHistory;
    private IdeaGateway myGateway;
    private Change myLastChange;

    public FileUndoProvider() {
        this(null, null);
    }

    public FileUndoProvider(Project project, MessageBus bus) {
        this.myProject = project;
        if (this.myProject == null) {
            return;
        }
        this.myLocalHistory = LocalHistoryComponent.getLocalVcsFor(this.myProject);
        this.myGateway = LocalHistoryComponent.getGatewayFor(this.myProject);
        FileUndoProvider.getFileManager().addVirtualFileListener((VirtualFileListener)this, (Disposable)project);
        this.listenForModuleChanges(bus.connect((Disposable)project));
        this.listenForLocalHistory();
    }

    private void listenForLocalHistory() {
        this.myLocalHistory.addListener(new LocalVcs.Listener(){

            @Override
            public void onChange(Change c) {
                FileUndoProvider.this.myLastChange = c;
            }
        });
    }

    private void listenForModuleChanges(MessageBusConnection bus) {
        bus.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void beforeRootsChange(ModuleRootEvent event) {
            }

            public void rootsChanged(ModuleRootEvent event) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)FileUndoProvider.this.myProject)).invalidateAllGlobalActions();
            }
        });
    }

    private static VirtualFileManager getFileManager() {
        return VirtualFileManager.getInstance();
    }

    @Override
    public void commandStarted(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = true;
    }

    @Override
    public void commandFinished(Project p) {
        if (this.myProject != p) {
            return;
        }
        this.myIsInsideCommand = false;
    }

    public void fileCreated(VirtualFileEvent e) {
        this.processEvent(e);
    }

    public void propertyChanged(VirtualFilePropertyEvent e) {
        if (!e.getPropertyName().equals("name")) {
            return;
        }
        this.processEvent((VirtualFileEvent)e);
    }

    public void fileMoved(VirtualFileMoveEvent e) {
        this.processEvent((VirtualFileEvent)e);
    }

    private void processEvent(VirtualFileEvent e) {
        if (this.shouldNotProcess(e)) {
            return;
        }
        if (this.isUndoable(e)) {
            this.registerUndoableAction(e);
        } else {
            this.registerNonUndoableAction(e);
        }
    }

    public void beforeContentsChange(VirtualFileEvent e) {
        if (this.shouldNotProcess(e)) {
            return;
        }
        if (this.isUndoable(e)) {
            return;
        }
        this.registerNonUndoableAction(e);
    }

    public void beforeFileDeletion(VirtualFileEvent e) {
        if (this.shouldNotProcess(e)) {
            return;
        }
        if (this.isUndoable(e)) {
            if (this.nonUndoableDeletion(e)) {
                return;
            }
            VirtualFile file = e.getFile();
            file.putUserData(this.DELETION_WAS_UNDOABLE, (Object)this.createDocumentReference(e));
            LocalHistoryComponent.getComponentInstance(this.myProject).registerUnsavedDocuments(file);
        } else {
            this.registerNonUndoableAction(e);
        }
    }

    private boolean nonUndoableDeletion(VirtualFileEvent e) {
        return LocalHistory.hasUnavailableContent((Project)this.myProject, (VirtualFile)e.getFile());
    }

    public void fileDeleted(VirtualFileEvent e) {
        VirtualFile f = e.getFile();
        DocumentReference ref = (DocumentReference)f.getUserData(this.DELETION_WAS_UNDOABLE);
        if (ref != null) {
            this.registerUndoableAction(ref);
            f.putUserData(this.DELETION_WAS_UNDOABLE, null);
        }
    }

    private boolean shouldNotProcess(VirtualFileEvent e) {
        return this.isProjectClosed() || !LocalHistory.isUnderControl((Project)this.myProject, (VirtualFile)e.getFile()) || !this.myIsInsideCommand;
    }

    private boolean isProjectClosed() {
        return this.myProject.isDisposed();
    }

    private boolean isUndoable(VirtualFileEvent e) {
        return !e.isFromRefresh();
    }

    private void registerUndoableAction(VirtualFileEvent e) {
        this.registerUndoableAction(this.createDocumentReference(e));
    }

    private void registerUndoableAction(DocumentReference ref) {
        this.getUndoManager().undoableActionPerformed(new MyUndoableAction(ref));
    }

    private void registerNonUndoableAction(VirtualFileEvent e) {
        this.getUndoManager().nonundoableActionPerformed(this.createDocumentReference(e), true);
    }

    private DocumentReference createDocumentReference(VirtualFileEvent e) {
        return DocumentReferenceManager.getInstance().create(e.getFile());
    }

    private UndoManagerImpl getUndoManager() {
        if (this.myProject != null) {
            return (UndoManagerImpl)UndoManager.getInstance((Project)this.myProject);
        }
        return (UndoManagerImpl)UndoManager.getGlobalInstance();
    }

    private class MyUndoableAction
    implements UndoableAction {
        private final DocumentReference[] myReferences;
        private ChangeRange myActionChangeRange;
        private ChangeRange myUndoChangeRange;

        public MyUndoableAction(DocumentReference r) {
            this.myReferences = new DocumentReference[]{r};
            this.myActionChangeRange = new ChangeRange(FileUndoProvider.this.myGateway, FileUndoProvider.this.myLocalHistory, FileUndoProvider.this.myLastChange);
        }

        public void undo() throws UnexpectedUndoException {
            try {
                this.myUndoChangeRange = this.myActionChangeRange.revert(this.myUndoChangeRange);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new UnexpectedUndoException(e.getMessage());
            }
        }

        public void redo() throws UnexpectedUndoException {
            try {
                this.myActionChangeRange = this.myUndoChangeRange.revert(this.myActionChangeRange);
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new UnexpectedUndoException(e.getMessage());
            }
        }

        public DocumentReference[] getAffectedDocuments() {
            return this.myReferences;
        }

        public boolean isGlobal() {
            return true;
        }
    }
}

