/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.CommonBundle;
import com.intellij.openapi.command.impl.EditorAndState;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.impl.UndoRedo;
import com.intellij.openapi.command.impl.UndoRedoStacksHolder;
import com.intellij.openapi.fileEditor.FileEditor;

class Undo
extends UndoRedo {
    public Undo(UndoManagerImpl manager, FileEditor editor) {
        super(manager, editor);
    }

    @Override
    protected UndoRedoStacksHolder getStackHolder() {
        return this.myManager.getUndoStacksHolder();
    }

    @Override
    protected UndoRedoStacksHolder getReverseStackHolder() {
        return this.myManager.getRedoStacksHolder();
    }

    @Override
    protected String getActionName() {
        return CommonBundle.message((String)"undo.dialog.title", (Object[])new Object[0]);
    }

    @Override
    protected String getActionName(String commandName) {
        return CommonBundle.message((String)"undo.command.confirmation.text", (Object[])new Object[]{commandName});
    }

    @Override
    protected void performAction() {
        this.myUndoableGroup.undo();
    }

    @Override
    protected EditorAndState getBeforeState() {
        return this.myUndoableGroup.getStateAfter();
    }

    @Override
    protected EditorAndState getAfterState() {
        return this.myUndoableGroup.getStateBefore();
    }

    @Override
    protected void setBeforeState(EditorAndState state) {
        this.myUndoableGroup.setStateAfter(state);
    }
}

