/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.UnknownMacroNotification;
import com.intellij.openapi.components.impl.stores.XmlElementStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.StreamProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SystemProperties;
import com.intellij.util.UniqueFileNamesProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.fs.FileSystem;
import com.intellij.util.io.fs.IFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.swing.event.HyperlinkEvent;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.impl.stores.StorageUtil");
    private static final boolean ourDumpChangedComponentStates = "true".equals(System.getProperty("log.externally.changed.component.states"));

    private StorageUtil() {
    }

    public static void notifyUnknownMacros(@NotNull TrackingPathMacroSubstitutor substitutor, final @NotNull Project project, @Nullable String componentName) {
        if (substitutor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.notifyUnknownMacros must not be null");
        }
        if (project == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.notifyUnknownMacros must not be null");
        }
        Collection macros = substitutor.getUnknownMacros(componentName);
        if (!macros.isEmpty()) {
            UnknownMacroNotification[] notifications;
            for (UnknownMacroNotification notification : notifications = (UnknownMacroNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(UnknownMacroNotification.class, project)) {
                macros = ContainerUtil.subtract(macros, notification.getMacros());
            }
            if (!macros.isEmpty()) {
                Notifications.Bus.notify((Notification)new UnknownMacroNotification("Load Error", "Load error: undefined path variables!", String.format("<p><i>%s</i> %s undefined. <a href=\"define\">Fix it</a>.</p>", StringUtil.join((Collection)macros, (String)", "), macros.size() == 1 ? "is" : "are"), NotificationType.ERROR, new NotificationListener(){

                    public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                        if (notification == null) {
                            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil$1.hyperlinkUpdate must not be null");
                        }
                        if (event == null) {
                            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil$1.hyperlinkUpdate must not be null");
                        }
                        ((ProjectEx)project).checkUnknownMacros(true);
                    }
                }, macros), (NotificationDisplayType)NotificationDisplayType.STICKY_BALLOON, (Project)project);
            }
        }
    }

    static void save(final IFile file, Parent element, final Object requestor) throws StateStorage.StateStorageException {
        final String filePath = file.getCanonicalPath();
        try {
            final Ref refIOException = Ref.create(null);
            Pair<String, String> pair = StorageUtil.loadFile(file);
            final byte[] text = JDOMUtil.writeParent((Parent)element, (String)((String)pair.second)).getBytes("UTF-8");
            if (file.exists()) {
                if (new String(text).equals(pair.first)) {
                    return;
                }
                IFile backupFile = StorageUtil.deleteBackup(filePath);
                file.renameTo(backupFile);
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!file.exists()) {
                        file.createParentDirs();
                    }
                    try {
                        VirtualFile virtualFile = StorageUtil.getOrCreateVirtualFile(requestor, file);
                        OutputStream outputStream = null;
                        try {
                            outputStream = virtualFile.getOutputStream(requestor);
                            outputStream.write(text);
                            outputStream.flush();
                        }
                        finally {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        refIOException.set((Object)e);
                    }
                    StorageUtil.deleteBackup(filePath);
                }
            });
            if (refIOException.get() != null) {
                throw new StateStorage.StateStorageException((Throwable)refIOException.get());
            }
        }
        catch (IOException e) {
            throw new StateStorage.StateStorageException((Throwable)e);
        }
    }

    static IFile deleteBackup(String path) {
        IFile backupFile = FileSystem.FILE_SYSTEM.createFile(path + "~");
        if (backupFile.exists()) {
            backupFile.delete();
        }
        return backupFile;
    }

    static VirtualFile getOrCreateVirtualFile(Object requestor, IFile ioFile) throws IOException {
        VirtualFile vFile = StorageUtil.getVirtualFile(ioFile);
        if (vFile == null) {
            vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ioFile);
        }
        if (vFile == null) {
            IFile parentFile = ioFile.getParentFile();
            VirtualFile parentVFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(parentFile);
            if (parentVFile == null) {
                throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])new Object[]{parentFile.getPath()}));
            }
            vFile = parentVFile.createChildData(requestor, ioFile.getName());
        }
        return vFile;
    }

    @Nullable
    static VirtualFile getVirtualFile(IFile ioFile) {
        return LocalFileSystem.getInstance().findFileByIoFile(ioFile);
    }

    @Deprecated
    public static byte[] printDocument(Document document) throws StateStorage.StateStorageException {
        try {
            return StorageUtil.printDocumentToString(document).getBytes("UTF-8");
        }
        catch (IOException e) {
            throw new StateStorage.StateStorageException((Throwable)e);
        }
    }

    public static Pair<String, String> loadFile(@NotNull IFile file) throws IOException {
        String fileText;
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.loadFile must not be null");
        }
        if (!file.exists()) {
            return Pair.create(null, (Object)SystemProperties.getLineSeparator());
        }
        int ndx = (fileText = new String(file.loadBytes(), "UTF-8")).indexOf(10);
        return Pair.create((Object)fileText, (Object)(ndx == -1 ? SystemProperties.getLineSeparator() : (ndx - 1 >= 0 ? (fileText.charAt(ndx - 1) == '\r' ? "\r\n" : "\n") : "\n")));
    }

    public static boolean contentEquals(@NotNull Document document, @NotNull IFile file) {
        if (document == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.contentEquals must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.contentEquals must not be null");
        }
        try {
            Pair<String, String> pair = StorageUtil.loadFile(file);
            return pair.first == null ? false : ((String)pair.first).equals(StorageUtil.printDocumentToString(document, (String)pair.second));
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static boolean contentEquals(@NotNull Element element, @NotNull IFile file) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.contentEquals must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.contentEquals must not be null");
        }
        try {
            Pair<String, String> pair = StorageUtil.loadFile(file);
            return pair.first == null ? false : ((String)pair.first).equals(StorageUtil.printElement(element, (String)pair.second));
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
            return false;
        }
    }

    public static String printDocumentToString(Document document, String lineSeparator) {
        return JDOMUtil.writeDocument((Document)document, (String)lineSeparator);
    }

    @Deprecated
    public static String printDocumentToString(Document document) {
        return StorageUtil.printDocumentToString(document, SystemProperties.getLineSeparator());
    }

    static String printElement(Element element, String lineSeparator) throws StateStorage.StateStorageException {
        return JDOMUtil.writeElement((Element)element, (String)lineSeparator);
    }

    @NotNull
    public static Set<String> getMacroNames(@NotNull Element e) {
        if (e == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/components/impl/stores/StorageUtil.getMacroNames must not be null");
        }
        Set<String> set = PathMacrosCollector.getMacroNames(e, new NotNullFunction<Object, Boolean>(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public Boolean fun(Object o) {
                Boolean bl;
                if (o instanceof Attribute) {
                    Attribute attribute = (Attribute)o;
                    Element parent = attribute.getParent();
                    String parentName = parent.getName();
                    if (("value".equals(attribute.getName()) || "name".equals(attribute.getName())) && "env".equals(parentName)) {
                        bl = false;
                        if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil$3.fun must not return null");
                        return bl;
                    }
                    if ("MESSAGE".equals(parentName) && "value".equals(attribute.getName())) {
                        bl = false;
                        if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil$3.fun must not return null");
                        return bl;
                    }
                    if ("option".equals(parentName) && "LAST_COMMIT_MESSAGE".equals(parent.getAttributeValue("name"))) {
                        bl = false;
                        if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil$3.fun must not return null");
                        return bl;
                    }
                    if ("replaceConfiguration".equals(parentName) || "searchConfiguration".equals(parentName)) {
                        bl = false;
                        if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil$3.fun must not return null");
                        return bl;
                    }
                }
                if ((bl = Boolean.valueOf(true)) != null) return bl;
                throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil$3.fun must not return null");
            }
        }, new NotNullFunction<Object, Boolean>(){

            /*
             * Enabled aggressive block sorting
             */
            @NotNull
            public Boolean fun(Object o) {
                Boolean bl;
                Element parent;
                if (o instanceof Attribute && (parent = ((Attribute)o).getParent()) != null && "option".equals(parent.getName())) {
                    Element grandParent = parent.getParentElement();
                    bl = grandParent != null && "configuration".equals(grandParent.getName());
                    if (bl == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil$4.fun must not return null");
                    return bl;
                }
                bl = false;
                if (bl != null) return bl;
                throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil$4.fun must not return null");
            }
        });
        if (set == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/components/impl/stores/StorageUtil.getMacroNames must not return null");
        }
        return set;
    }

    @Nullable
    public static Document loadDocument(byte[] bytes) {
        try {
            return bytes == null || bytes.length == 0 ? null : JDOMUtil.loadDocument((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (JDOMException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Document loadDocument(InputStream stream) {
        if (stream == null) {
            return null;
        }
        try {
            Document document = JDOMUtil.loadDocument((InputStream)stream);
            return document;
        }
        catch (JDOMException e) {
            Document document = null;
            return document;
        }
        catch (IOException e) {
            Document document = null;
            return document;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendContent(StreamProvider streamProvider, String fileSpec, Document copy, RoamingType roamingType, boolean async) throws IOException {
        byte[] content = StorageUtil.printDocument(copy);
        ByteArrayInputStream in = new ByteArrayInputStream(content);
        try {
            if (streamProvider.isEnabled()) {
                streamProvider.saveContent(fileSpec, (InputStream)in, (long)content.length, roamingType, async);
            }
        }
        finally {
            in.close();
        }
    }

    public static void logStateDiffInfo(Set<Pair<VirtualFile, StateStorage>> changedFiles, Set<String> componentNames) throws IOException {
        if (!ApplicationManagerEx.getApplicationEx().isInternal() && !ourDumpChangedComponentStates) {
            return;
        }
        try {
            File logDirectory = StorageUtil.createLogDirectory();
            logDirectory.mkdirs();
            for (String string : componentNames) {
                for (Pair<VirtualFile, StateStorage> pair : changedFiles) {
                    Element state;
                    StateStorage storage = (StateStorage)pair.second;
                    if (!(storage instanceof XmlElementStorage) || (state = ((XmlElementStorage)storage).getState(string)) == null) continue;
                    File logFile = new File(logDirectory, "prev_" + string + ".xml");
                    FileUtil.writeToFile((File)logFile, (byte[])JDOMUtil.writeElement((Element)state, (String)"\n").getBytes());
                }
            }
            for (Pair pair : changedFiles) {
                File logFile = new File(logDirectory, "new_" + ((VirtualFile)pair.first).getName());
                FileUtil.copy((File)new File(((VirtualFile)pair.first).getPath()), (File)logFile);
            }
        }
        catch (Throwable e) {
            LOG.info(e);
        }
    }

    static File createLogDirectory() {
        UniqueFileNamesProvider namesProvider = new UniqueFileNamesProvider();
        File statesDir = new File(PathManager.getSystemPath(), "log/componentStates");
        File[] children = statesDir.listFiles();
        if (children != null) {
            if (children.length > 10) {
                File childToDelete = null;
                for (File child : children) {
                    if (childToDelete != null && childToDelete.lastModified() <= child.lastModified()) continue;
                    childToDelete = child;
                }
                if (childToDelete != null) {
                    FileUtil.delete(childToDelete);
                }
            }
            for (File child : children) {
                namesProvider.reserveFileName(child.getName());
            }
        }
        return new File(statesDir, namesProvider.suggestName("state-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()) + "-" + ApplicationInfo.getInstance().getBuild().asString()));
    }
}

