/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.actions.TextComponentEditorAction;
import com.intellij.util.StringBuilderSpinAllocator;

public class ToggleCaseAction
extends TextComponentEditorAction {
    public ToggleCaseAction() {
        super((EditorActionHandler)new Handler());
    }

    private static class Handler
    extends EditorWriteActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executeWriteAction(Editor editor, DataContext dataContext) {
            int[] ends;
            int[] starts;
            SelectionModel selectionModel = editor.getSelectionModel();
            LogicalPosition blockStart = null;
            LogicalPosition blockEnd = null;
            if (selectionModel.hasBlockSelection()) {
                starts = selectionModel.getBlockSelectionStarts();
                ends = selectionModel.getBlockSelectionEnds();
                blockStart = selectionModel.getBlockStart();
                blockEnd = selectionModel.getBlockEnd();
            } else {
                if (!selectionModel.hasSelection()) {
                    selectionModel.selectWordAtCaret(true);
                }
                starts = new int[]{selectionModel.getSelectionStart()};
                ends = new int[]{selectionModel.getSelectionEnd()};
            }
            selectionModel.removeBlockSelection();
            selectionModel.removeSelection();
            for (int i = 0; i < starts.length; ++i) {
                int startOffset = starts[i];
                int endOffset = ends[i];
                StringBuilder builder = StringBuilderSpinAllocator.alloc();
                try {
                    String text = ((Object)editor.getDocument().getCharsSequence().subSequence(startOffset, endOffset)).toString();
                    Handler.toCase(builder, text, true);
                    if (text.equals(builder.toString())) {
                        Handler.toCase(builder, text, false);
                    }
                    editor.getDocument().replaceString(startOffset, endOffset, (CharSequence)builder.toString());
                    continue;
                }
                finally {
                    StringBuilderSpinAllocator.dispose((StringBuilder)builder);
                }
            }
            if (blockStart != null) {
                selectionModel.setBlockSelection(blockStart, blockEnd);
            } else {
                selectionModel.setSelection(starts[0], ends[0]);
            }
        }

        private static void toCase(StringBuilder builder, String text, boolean lower) {
            builder.setLength(0);
            boolean prevIsSlash = false;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (!prevIsSlash) {
                    c = lower ? Character.toLowerCase(c) : Character.toUpperCase(c);
                }
                prevIsSlash = c == '\\';
                builder.append(c);
            }
        }
    }
}

