/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.ex.util;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.IterationState;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;

public class EditorUtil {
    private EditorUtil() {
    }

    public static int getLastVisualLineColumnNumber(Editor editor, int line) {
        int lastLine;
        VisualPosition visStart = new VisualPosition(line, 0);
        LogicalPosition logStart = editor.visualToLogicalPosition(visStart);
        int lastLogLine = logStart.line;
        while (lastLogLine < editor.getDocument().getLineCount() - 1) {
            logStart = new LogicalPosition(logStart.line + 1, logStart.column);
            VisualPosition tryVisible = editor.logicalToVisualPosition(logStart);
            if (tryVisible.line != visStart.line) break;
            lastLogLine = logStart.line;
        }
        if ((lastLine = editor.getDocument().getLineCount() - 1) < 0) {
            return 0;
        }
        return editor.offsetToVisualPosition((int)editor.getDocument().getLineEndOffset((int)Math.min((int)lastLogLine, (int)lastLine))).column;
    }

    public static float calcVerticalScrollProportion(Editor editor) {
        Rectangle viewRect = editor.getScrollingModel().getVisibleAreaOnScrollingFinished();
        if (viewRect.height == 0) {
            return 0.0f;
        }
        LogicalPosition pos = editor.getCaretModel().getLogicalPosition();
        Point location = editor.logicalPositionToXY(pos);
        return (float)(location.y - viewRect.y) / (float)viewRect.height;
    }

    public static void setVerticalScrollProportion(Editor editor, float proportion) {
        Rectangle viewRect = editor.getScrollingModel().getVisibleArea();
        LogicalPosition caretPosition = editor.getCaretModel().getLogicalPosition();
        Point caretLocation = editor.logicalPositionToXY(caretPosition);
        int yPos = caretLocation.y;
        yPos = (int)((float)yPos - (float)viewRect.height * proportion);
        editor.getScrollingModel().scrollVertically(yPos);
    }

    public static void fillVirtualSpaceUntilCaret(Editor editor) {
        LogicalPosition position = editor.getCaretModel().getLogicalPosition();
        EditorUtil.fillVirtualSpaceUntil(editor, position.column, position.line);
    }

    public static void fillVirtualSpaceUntil(final Editor editor, int columnNumber, int lineNumber) {
        final int offset = editor.logicalPositionToOffset(new LogicalPosition(lineNumber, columnNumber));
        final String filler = EditorModificationUtil.calcStringToFillVitualSpace((Editor)editor);
        if (filler.length() > 0) {
            new WriteAction(){

                protected void run(Result result) throws Throwable {
                    editor.getDocument().insertString(offset, (CharSequence)filler);
                    editor.getCaretModel().moveToOffset(offset + filler.length());
                }
            }.execute();
        }
    }

    public static int calcOffset(Editor editor, CharSequence text, int start, int end, int columnNumber, int tabSize) {
        boolean useOptimization = true;
        boolean hasNonTabs = false;
        boolean hasTabs = false;
        int maxScanIndex = Math.min(start + columnNumber + 1, end);
        for (int i = start; i < maxScanIndex; ++i) {
            if (text.charAt(i) == '\t') {
                hasTabs = true;
                if (!hasNonTabs) continue;
                useOptimization = false;
                break;
            }
            hasNonTabs = true;
        }
        if (editor == null || useOptimization) {
            int offset;
            if (!hasTabs) {
                return Math.min(start + columnNumber, end);
            }
            int shift = 0;
            for (offset = start; offset < end && offset + shift < start + columnNumber; ++offset) {
                if (text.charAt(offset) != '\t') continue;
                shift += EditorUtil.getTabLength(offset + shift - start, tabSize) - 1;
            }
            if (offset + shift > start + columnNumber) {
                --offset;
            }
            return offset;
        }
        EditorEx editorImpl = (EditorEx)editor;
        int offset = start;
        IterationState state = new IterationState(editorImpl, offset, false);
        int fontType = state.getMergedAttributes().getFontType();
        int column = 0;
        int x = 0;
        int spaceSize = EditorUtil.getSpaceWidth(fontType, editorImpl);
        while (column < columnNumber) {
            char c;
            if (offset >= state.getEndOffset()) {
                state.advance();
                fontType = state.getMergedAttributes().getFontType();
            }
            char c2 = c = offset < end ? (char)text.charAt(offset++) : (char)' ';
            if (c == '\t') {
                int prevX = x;
                x = EditorUtil.nextTabStop(x, editorImpl);
                column += (x - prevX) / spaceSize;
                continue;
            }
            x += EditorUtil.charWidth(c, fontType, editorImpl);
            ++column;
        }
        if (column == columnNumber && offset < end && text.charAt(offset) == '\t' && (EditorUtil.nextTabStop(x, editorImpl) - x) / spaceSize == 0) {
            ++offset;
        }
        if (column > columnNumber) {
            --offset;
        }
        return offset;
    }

    private static int getTabLength(int colNumber, int tabSize) {
        if (tabSize <= 0) {
            tabSize = 1;
        }
        return tabSize - colNumber % tabSize;
    }

    public static int calcColumnNumber(Editor editor, CharSequence text, int start, int offset, int tabSize) {
        boolean useOptimization = true;
        boolean hasNonTabs = false;
        for (int i = start; i < offset; ++i) {
            if (text.charAt(i) == '\t') {
                if (!hasNonTabs) continue;
                useOptimization = false;
                break;
            }
            hasNonTabs = true;
        }
        if (editor == null || useOptimization) {
            int shift = 0;
            for (int i = start; i < offset; ++i) {
                char c = text.charAt(i);
                assert (c != '\n' && c != '\r');
                if (c != '\t') continue;
                shift += EditorUtil.getTabLength(i + shift - start, tabSize) - 1;
            }
            return offset - start + shift;
        }
        EditorEx editorImpl = (EditorEx)editor;
        return editorImpl.calcColumnNumber(text, start, offset, tabSize);
    }

    public static void setHandCursor(Editor view) {
        Cursor c = Cursor.getPredefinedCursor(12);
        if (view.getContentComponent().getCursor() != c) {
            view.getContentComponent().setCursor(c);
        }
    }

    public static FontInfo fontForChar(char c, int style, Editor editor) {
        EditorColorsScheme colorsScheme = editor.getColorsScheme();
        return ComplementaryFontsRegistry.getFontAbleToDisplay(c, colorsScheme.getEditorFontSize(), style, colorsScheme.getEditorFontName());
    }

    public static int charWidth(char c, int fontType, Editor editor) {
        return EditorUtil.fontForChar(c, fontType, editor).charWidth(c, editor.getContentComponent());
    }

    public static int getSpaceWidth(int fontType, Editor editor) {
        int width = EditorUtil.charWidth(' ', fontType, editor);
        return width > 0 ? width : 1;
    }

    public static int getTabSize(Editor editor) {
        return editor.getSettings().getTabSize(editor.getProject());
    }

    public static int nextTabStop(int x, Editor editor) {
        int tabSize = EditorUtil.getTabSize(editor);
        if (tabSize <= 0) {
            tabSize = 1;
        }
        int nTabs = x / (tabSize *= EditorUtil.getSpaceWidth(0, editor));
        return (nTabs + 1) * tabSize;
    }
}

