/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContextMenuImpl
extends JPanel
implements Disposable {
    @NonNls
    public static final String ACTION_GROUP = "EditorContextBarMenu";
    private ActionGroup myActionGroup;
    private final JComponent myComponent;
    private boolean myVisible;
    private boolean myShow;
    private int myCurrentOpacity;
    private Timer myTimer;
    private EditorImpl myEditor;
    private ContextMenuPanel myContextMenuPanel;
    private boolean myDisposed;
    private JLayeredPane myLayeredPane;

    public ContextMenuImpl(JLayeredPane layeredPane, final @NotNull JScrollPane container, @NotNull EditorImpl editor) {
        if (container == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/openapi/editor/impl/ContextMenuImpl.<init> must not be null");
        }
        if (editor == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/ContextMenuImpl.<init> must not be null");
        }
        this.myVisible = false;
        this.myShow = false;
        this.setLayout(new BorderLayout(0, 0));
        this.myEditor = editor;
        this.myLayeredPane = layeredPane;
        ActionManager actionManager = ActionManager.getInstance();
        editor.addEditorMouseListener((EditorMouseListener)new EditorMouseAdapter(){

            public void mouseExited(EditorMouseEvent e) {
                if (!ContextMenuImpl.isInsideActivationArea(container, e.getMouseEvent().getPoint())) {
                    ContextMenuImpl.this.toggleContextToolbar(false);
                }
            }
        });
        editor.addEditorMouseMotionListener((EditorMouseMotionListener)new EditorMouseMotionAdapter(){

            public void mouseMoved(EditorMouseEvent e) {
                ContextMenuImpl.this.toggleContextToolbar(ContextMenuImpl.isInsideActivationArea(container, e.getMouseEvent().getPoint()));
            }
        });
        AnAction action = actionManager.getAction(ACTION_GROUP);
        if (action == null) {
            action = new DefaultActionGroup();
            actionManager.registerAction(ACTION_GROUP, action);
        }
        if (action instanceof ActionGroup) {
            this.myActionGroup = (ActionGroup)action;
        }
        this.myComponent = this.createComponent();
        this.add(this.myComponent);
        this.setVisible(false);
        this.setOpaque(false);
    }

    private static boolean isInsideActivationArea(JScrollPane container, Point p) {
        JViewport viewport = container.getViewport();
        Rectangle r = viewport.getBounds();
        Point viewPosition = viewport.getViewPosition();
        Rectangle activationArea = new Rectangle(0, 0, r.width, 150);
        return activationArea.contains(p.x, p.y - viewPosition.y);
    }

    private void toggleContextToolbar(boolean show) {
        Component toolbar = this.myComponent.getComponent(0);
        int count = ((Container)toolbar).getComponentCount();
        if (count == 0) {
            return;
        }
        if (this.myShow != show) {
            this.myShow = show;
            this.restartTimer();
        }
    }

    private void restartTimer() {
        if (this.myTimer != null && this.myTimer.isRunning()) {
            this.myTimer.stop();
        }
        this.myTimer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ContextMenuImpl.this.myDisposed) {
                    return;
                }
                if (ContextMenuImpl.this.myTimer != null && ContextMenuImpl.this.myTimer.isRunning()) {
                    ContextMenuImpl.this.myTimer.stop();
                }
                ContextMenuImpl.this.myTimer = new Timer(50, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ContextMenuImpl.this.myShow) {
                            if (ContextMenuImpl.this.myVisible) {
                                ContextMenuImpl.this.scheduleHide();
                                return;
                            }
                            if (ContextMenuImpl.this.myLayeredPane.getIndexOf(ContextMenuImpl.this) == -1) {
                                ContextMenuImpl.this.myCurrentOpacity = 0;
                                ContextMenuImpl.this.myLayeredPane.add((Component)ContextMenuImpl.this, JLayeredPane.POPUP_LAYER);
                                ContextMenuImpl.this.setVisible(true);
                                ContextMenuImpl.this.myLayeredPane.revalidate();
                            }
                            ContextMenuImpl.this.myCurrentOpacity += 20;
                            if (ContextMenuImpl.this.myCurrentOpacity > 100) {
                                ContextMenuImpl.this.myCurrentOpacity = 100;
                                ContextMenuImpl.this.myVisible = true;
                                ContextMenuImpl.this.myTimer.stop();
                                ContextMenuImpl.this.scheduleHide();
                            }
                            ContextMenuImpl.this.repaint();
                        } else {
                            if (!ContextMenuImpl.this.myVisible) {
                                if (ContextMenuImpl.this.myTimer != null && ContextMenuImpl.this.myTimer.isRunning()) {
                                    ContextMenuImpl.this.myTimer.stop();
                                }
                                return;
                            }
                            ContextMenuImpl.this.myCurrentOpacity -= 20;
                            if (ContextMenuImpl.this.myCurrentOpacity < 0) {
                                ContextMenuImpl.this.myCurrentOpacity = 0;
                                ContextMenuImpl.this.myVisible = false;
                                ContextMenuImpl.this.myLayeredPane.remove(ContextMenuImpl.this);
                                ContextMenuImpl.this.myLayeredPane.revalidate();
                            }
                            ContextMenuImpl.this.repaint();
                        }
                    }
                });
                ContextMenuImpl.this.myTimer.setRepeats(true);
                ContextMenuImpl.this.myTimer.start();
            }
        });
        this.myTimer.setRepeats(false);
        this.myTimer.start();
    }

    public void dispose() {
        this.myDisposed = true;
        this.myEditor = null;
        if (this.myTimer != null) {
            this.myTimer.stop();
            this.myTimer = null;
        }
    }

    public static boolean mayShowToolbar(@Nullable Document document) {
        if (document == null) {
            return false;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(document);
        return file != null && file.isValid() && (file.getFileSystem() == LocalFileSystem.getInstance() || file instanceof HttpVirtualFile);
    }

    private void scheduleHide() {
        if (this.myTimer != null && this.myTimer.isRunning()) {
            this.myTimer.stop();
        }
        this.myTimer = new Timer(1500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PointerInfo pointerInfo;
                if (ContextMenuImpl.this.myDisposed) {
                    return;
                }
                if (ContextMenuImpl.this.myComponent.isVisible() && (pointerInfo = MouseInfo.getPointerInfo()) != null) {
                    Point location = pointerInfo.getLocation();
                    SwingUtilities.convertPointFromScreen(location, ContextMenuImpl.this.myComponent);
                    if (!ContextMenuImpl.this.myComponent.getBounds().contains(location)) {
                        ContextMenuImpl.this.toggleContextToolbar(false);
                    } else {
                        ContextMenuImpl.this.scheduleHide();
                    }
                }
            }
        });
        this.myTimer.setRepeats(false);
        this.myTimer.start();
    }

    private ActionToolbar createToolbar(ActionGroup group) {
        ActionToolbarImpl actionToolbar = new ActionToolbarImpl("ContextToolbar", group, true, DataManager.getInstance(), ActionManagerEx.getInstanceEx(), KeymapManagerEx.getInstanceEx()){

            @Override
            public void paint(Graphics g) {
                if (ContextMenuImpl.this.myContextMenuPanel.isPaintChildren()) {
                    this.paintChildren(g);
                }
            }

            @Override
            protected void paintChildren(Graphics g) {
                if (ContextMenuImpl.this.myContextMenuPanel.isPaintChildren()) {
                    super.paintChildren(g);
                }
            }

            @Override
            public boolean isOpaque() {
                return ContextMenuImpl.this.myContextMenuPanel.isPaintChildren();
            }

            @Override
            public ActionButton createToolbarButton(AnAction action, ActionButtonLook look, String place, Presentation presentation, Dimension minimumSize) {
                ActionButton result = new ActionButton(action, presentation, place, minimumSize){

                    @Override
                    public void paintComponent(Graphics g) {
                        ActionButtonLook look;
                        if (ContextMenuImpl.this.myContextMenuPanel.isPaintChildren()) {
                            look = this.getButtonLook();
                            look.paintIcon(g, this, this.getIcon());
                        }
                        if (ContextMenuImpl.this.myContextMenuPanel.isShown() && this.getPopState() == 1) {
                            look = this.getButtonLook();
                            look.paintBackground(g, this);
                            look.paintIcon(g, this, this.getIcon());
                        }
                    }

                    @Override
                    public boolean isOpaque() {
                        return ContextMenuImpl.this.myContextMenuPanel.isPaintChildren() || this.getPopState() == 1;
                    }

                    @Override
                    public void paint(Graphics g) {
                        Graphics2D g2 = (Graphics2D)g;
                        this.paintComponent(g2);
                    }
                };
                result.setLook(look);
                return result;
            }
        };
        actionToolbar.setTargetComponent(this.myEditor.getContentComponent());
        return actionToolbar;
    }

    private JComponent createComponent() {
        ActionToolbar toolbar = this.createToolbar(this.myActionGroup);
        toolbar.setMinimumButtonSize(new Dimension(20, 20));
        toolbar.setReservePlaceAutoPopupIcon(false);
        this.myContextMenuPanel = new ContextMenuPanel(this);
        this.myContextMenuPanel.setLayout(new BorderLayout(0, 0));
        this.myContextMenuPanel.add(toolbar.getComponent());
        return this.myContextMenuPanel;
    }

    private static class ContextMenuPanel
    extends JPanel {
        private final ContextMenuImpl myContextMenu;
        private BufferedImage myBufferedImage;
        private boolean myPaintChildren = false;

        private ContextMenuPanel(ContextMenuImpl contextMenu) {
            this.myContextMenu = contextMenu;
            this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.setOpaque(false);
        }

        @Override
        public void invalidate() {
            super.invalidate();
            this.myBufferedImage = null;
        }

        @Override
        public void revalidate() {
            super.revalidate();
            this.myBufferedImage = null;
        }

        @Override
        protected void paintChildren(Graphics g) {
            if (this.myPaintChildren) {
                super.paintChildren(g);
            }
        }

        public boolean isPaintChildren() {
            return this.myPaintChildren;
        }

        @Override
        public void paint(Graphics g) {
            Rectangle r = this.getBounds();
            if (this.myBufferedImage == null) {
                this.myBufferedImage = new BufferedImage(r.width, r.height, 2);
                Graphics graphics = this.myBufferedImage.getGraphics();
                Graphics2D g2d2 = (Graphics2D)graphics;
                Composite old = g2d2.getComposite();
                g2d2.setComposite(AlphaComposite.getInstance(3, 0.2f));
                g2d2.setColor(Color.GRAY);
                g2d2.fillRoundRect(0, 0, r.width - 1, r.height - 1, 6, 6);
                g2d2.setComposite(old);
                this.myPaintChildren = true;
                this.paintChildren(g2d2);
                this.myPaintChildren = false;
            }
            Graphics2D g2 = (Graphics2D)g;
            Composite old = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(10, (float)this.myContextMenu.myCurrentOpacity / 100.0f));
            g2.drawImage(this.myBufferedImage, 0, 0, this.myBufferedImage.getWidth(null), this.myBufferedImage.getHeight(null), null);
            g2.setComposite(old);
        }

        public boolean isShown() {
            return this.myContextMenu.myCurrentOpacity == 100;
        }
    }
}

