/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.ide.ui.LafManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.actionSystem.DocCommandGroupId;
import com.intellij.openapi.editor.ex.EditorMarkupModel;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.ex.ErrorStripeEvent;
import com.intellij.openapi.editor.ex.ErrorStripeListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.MarkupModelImpl;
import com.intellij.openapi.editor.markup.ErrorStripeRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.PopupHandler;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class EditorMarkupModelImpl
extends MarkupModelImpl
implements EditorMarkupModel {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorMarkupModelImpl");
    private static final TooltipGroup ERROR_STRIPE_TOOLTIP_GROUP = new TooltipGroup("ERROR_STRIPE_TOOLTIP_GROUP", 0);
    private static final Icon ERRORS_FOUND_ICON = IconLoader.getIcon((String)"/general/errorsFound.png");
    private final EditorImpl myEditor;
    private MyErrorPanel myErrorPanel;
    private ErrorStripeRenderer myErrorStripeRenderer;
    private final List<ErrorStripeListener> myErrorMarkerListeners;
    private ErrorStripeListener[] myCachedErrorMarkerListeners;
    private List<RangeHighlighter> myCachedSortedHighlighters;
    private final MarkSpots myMarkSpots;
    private int myScrollBarHeight;
    private static final Comparator<RangeHighlighter> LAYER_COMPARATOR = new Comparator<RangeHighlighter>(){

        @Override
        public int compare(RangeHighlighter o1, RangeHighlighter o2) {
            return o1.getLayer() - o2.getLayer();
        }
    };
    @NotNull
    private ErrorStripTooltipRendererProvider myTooltipRendererProvider;
    private static int myMinMarkHeight = 3;

    EditorMarkupModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl.<init> must not be null");
        }
        super((DocumentImpl)editor.getDocument());
        this.myErrorStripeRenderer = null;
        this.myErrorMarkerListeners = new ArrayList<ErrorStripeListener>();
        this.myCachedErrorMarkerListeners = null;
        this.myCachedSortedHighlighters = null;
        this.myMarkSpots = new MarkSpots();
        this.myTooltipRendererProvider = new BasicTooltipRendererProvider();
        this.myEditor = editor;
    }

    @Override
    protected void assertDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread(this.myEditor.getComponent());
    }

    private int offsetToLine(int offset) {
        Document document = this.myEditor.getDocument();
        if (offset > document.getTextLength()) {
            offset = document.getTextLength();
        }
        int lineNumber = document.getLineNumber(offset);
        return this.myEditor.logicalToVisualPosition((LogicalPosition)new LogicalPosition((int)lineNumber, (int)0)).line;
    }

    public static int getMinHeight() {
        return myMinMarkHeight;
    }

    @Override
    public void setErrorStripeVisible(boolean val) {
        if (val) {
            this.myErrorPanel = new MyErrorPanel();
            this.myEditor.getPanel().add((Component)this.myErrorPanel, this.myEditor.getVerticalScrollbarOrientation() == 0 ? "West" : "East");
        } else if (this.myErrorPanel != null) {
            this.myEditor.getPanel().remove(this.myErrorPanel);
            this.myErrorPanel = null;
        }
    }

    @Override
    public void setErrorPanelPopupHandler(@NotNull PopupHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl.setErrorPanelPopupHandler must not be null");
        }
        if (this.myErrorPanel != null) {
            this.myErrorPanel.setPopupHandler(handler);
        }
    }

    @Override
    public void setErrorStripTooltipRendererProvider(@NotNull ErrorStripTooltipRendererProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl.setErrorStripTooltipRendererProvider must not be null");
        }
        this.myTooltipRendererProvider = provider;
    }

    @Override
    @NotNull
    public ErrorStripTooltipRendererProvider getErrorStripTooltipRendererProvider() {
        ErrorStripTooltipRendererProvider errorStripTooltipRendererProvider = this.myTooltipRendererProvider;
        if (errorStripTooltipRendererProvider == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorMarkupModelImpl.getErrorStripTooltipRendererProvider must not return null");
        }
        return errorStripTooltipRendererProvider;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        EditorImpl editorImpl = this.myEditor;
        if (editorImpl == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/EditorMarkupModelImpl.getEditor must not return null");
        }
        return editorImpl;
    }

    @Override
    public void setErrorStripeRenderer(ErrorStripeRenderer renderer) {
        this.assertIsDispatchThread();
        this.myErrorStripeRenderer = renderer;
        if (this.myErrorPanel != null) {
            this.myErrorPanel.repaint();
        }
    }

    private void assertIsDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread(this.myEditor.getComponent());
    }

    @Override
    public ErrorStripeRenderer getErrorStripeRenderer() {
        return this.myErrorStripeRenderer;
    }

    @Override
    public void dispose() {
        this.myErrorStripeRenderer = null;
        super.dispose();
    }

    public void repaint() {
        this.markDirtied();
        EditorImpl.MyScrollBar scrollBar = this.myEditor.getVerticalScrollBar();
        this.myScrollBarHeight = scrollBar.getSize().height;
        if (this.myErrorPanel != null) {
            this.myErrorPanel.repaint();
        }
    }

    private List<RangeHighlighter> getSortedHighlighters() {
        if (this.myCachedSortedHighlighters == null) {
            this.myCachedSortedHighlighters = new ArrayList<RangeHighlighter>();
            for (RangeHighlighter highlighter : this.getAllHighlighters()) {
                if (highlighter.getErrorStripeMarkColor() == null || !highlighter.isValid()) continue;
                this.myCachedSortedHighlighters.add(highlighter);
            }
            MarkupModel docMarkup = this.getDocument().getMarkupModel(this.myEditor.getProject());
            for (RangeHighlighter highlighter : docMarkup.getAllHighlighters()) {
                if (highlighter.getErrorStripeMarkColor() == null || !highlighter.isValid()) continue;
                this.myCachedSortedHighlighters.add(highlighter);
            }
            if (!this.myCachedSortedHighlighters.isEmpty()) {
                ContainerUtil.quickSort(this.myCachedSortedHighlighters, (Comparator)new Comparator<RangeHighlighter>(){

                    @Override
                    public int compare(RangeHighlighter h1, RangeHighlighter h2) {
                        return h1.getStartOffset() - h2.getStartOffset();
                    }
                });
            }
        }
        return this.myCachedSortedHighlighters;
    }

    private void showTooltip(MouseEvent e, TooltipRenderer tooltipObject) {
        TooltipController tooltipController = TooltipController.getInstance();
        tooltipController.showTooltipByMouseMove(this.myEditor, e, tooltipObject, this.myEditor.getVerticalScrollbarOrientation() == 1, ERROR_STRIPE_TOOLTIP_GROUP);
    }

    private ErrorStripeListener[] getCachedErrorMarkerListeners() {
        if (this.myCachedErrorMarkerListeners == null) {
            this.myCachedErrorMarkerListeners = this.myErrorMarkerListeners.toArray(new ErrorStripeListener[this.myErrorMarkerListeners.size()]);
        }
        return this.myCachedErrorMarkerListeners;
    }

    private void fireErrorMarkerClicked(RangeHighlighter marker, MouseEvent e) {
        ErrorStripeListener[] listeners;
        ErrorStripeEvent event = new ErrorStripeEvent(this.getEditor(), e, marker);
        for (ErrorStripeListener listener : listeners = this.getCachedErrorMarkerListeners()) {
            listener.errorMarkerClicked(event);
        }
    }

    @Override
    public void addErrorMarkerListener(@NotNull ErrorStripeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl.addErrorMarkerListener must not be null");
        }
        this.myCachedErrorMarkerListeners = null;
        this.myErrorMarkerListeners.add(listener);
    }

    @Override
    public void removeErrorMarkerListener(@NotNull ErrorStripeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl.removeErrorMarkerListener must not be null");
        }
        this.myCachedErrorMarkerListeners = null;
        boolean success = this.myErrorMarkerListeners.remove(listener);
        LOG.assertTrue(success);
    }

    public void markDirtied() {
        this.myCachedSortedHighlighters = null;
        this.myMarkSpots.clear();
    }

    @Override
    public int getMinMarkHeight() {
        return myMinMarkHeight;
    }

    @Override
    public void setMinMarkHeight(int minMarkHeight) {
        myMinMarkHeight = minMarkHeight;
    }

    private static class BasicTooltipRendererProvider
    implements ErrorStripTooltipRendererProvider {
        private BasicTooltipRendererProvider() {
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull Collection<RangeHighlighter> highlighters) {
            if (highlighters == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider.calcTooltipRenderer must not be null");
            }
            LineTooltipRenderer bigRenderer = null;
            Set tooltips = null;
            for (RangeHighlighter highlighter : highlighters) {
                Object tooltipObject = highlighter.getErrorStripeTooltip();
                if (tooltipObject == null) continue;
                String text = tooltipObject.toString();
                if (tooltips == null) {
                    tooltips = new THashSet();
                }
                if (!tooltips.add(text)) continue;
                if (bigRenderer == null) {
                    bigRenderer = new LineTooltipRenderer(text);
                    continue;
                }
                bigRenderer.addBelow(text);
            }
            return bigRenderer;
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider.calcTooltipRenderer must not be null");
            }
            return new LineTooltipRenderer(text);
        }

        @Override
        public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
            if (text == null) {
                throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/EditorMarkupModelImpl$BasicTooltipRendererProvider.calcTooltipRenderer must not be null");
            }
            return new LineTooltipRenderer(text, width);
        }
    }

    private class MyErrorPanel
    extends JPanel
    implements MouseMotionListener,
    MouseListener {
        private PopupHandler myHandler;

        private MyErrorPanel() {
            this.setOpaque(true);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(ERRORS_FOUND_ICON.getIconWidth() + 2, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void paintComponent(Graphics g) {
            if (EditorMarkupModelImpl.this.getEditor().isDisposed()) {
                return;
            }
            ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintStart();
            try {
                LafManager lafManager = LafManager.getInstance();
                if (lafManager == null || lafManager.isUnderAquaLookAndFeel()) {
                    g.setColor(new Color(0xF0F0F0));
                    Rectangle clipBounds = g.getClipBounds();
                    g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
                } else {
                    super.paintComponent(g);
                }
                if (EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                    EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
                    int top = scrollBar.getDecScrollButtonHeight();
                    EditorMarkupModelImpl.this.myErrorStripeRenderer.paint((Component)this, g, new Rectangle(0, 0, this.getWidth(), top));
                }
                EditorMarkupModelImpl.this.myMarkSpots.repaint(g, ERRORS_FOUND_ICON.getIconWidth());
            }
            finally {
                ((ApplicationImpl)ApplicationManager.getApplication()).editorPaintFinish();
            }
        }

        @Override
        public void mouseClicked(final MouseEvent e) {
            CommandProcessor.getInstance().executeCommand(EditorMarkupModelImpl.this.myEditor.getProject(), new Runnable(){

                @Override
                public void run() {
                    MyErrorPanel.this.doMouseClicked(e);
                }
            }, EditorBundle.message((String)"move.caret.command.name", (Object[])new Object[0]), (Object)DocCommandGroupId.noneGroupId((Document)EditorMarkupModelImpl.this.getDocument()), UndoConfirmationPolicy.DEFAULT, EditorMarkupModelImpl.this.getDocument());
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        private void doMouseClicked(MouseEvent e) {
            EditorMarkupModelImpl.this.myEditor.getContentComponent().requestFocus();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            EditorMarkupModelImpl.this.myMarkSpots.doClick(e, this.getWidth());
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
            int buttonHeight = scrollBar.getDecScrollButtonHeight();
            int lineCount = EditorMarkupModelImpl.this.getDocument().getLineCount() + EditorMarkupModelImpl.this.myEditor.getSettings().getAdditionalLinesCount();
            if (lineCount == 0) {
                return;
            }
            if (e.getY() < buttonHeight && EditorMarkupModelImpl.this.myErrorStripeRenderer != null) {
                String tooltipMessage = EditorMarkupModelImpl.this.myErrorStripeRenderer.getTooltipMessage();
                if (tooltipMessage != null) {
                    EditorMarkupModelImpl.this.showTooltip(e, EditorMarkupModelImpl.this.myTooltipRendererProvider.calcTooltipRenderer(tooltipMessage));
                }
                return;
            }
            if (EditorMarkupModelImpl.this.myMarkSpots.showToolTipByMouseMove(e, this.getWidth())) {
                this.setCursor(Cursor.getPredefinedCursor(12));
                return;
            }
            this.cancelMyToolTips(e);
            if (this.getCursor().equals(Cursor.getPredefinedCursor(12))) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }

        private void cancelMyToolTips(MouseEvent e) {
            TooltipController tooltipController = TooltipController.getInstance();
            if (!tooltipController.shouldSurvive(e)) {
                tooltipController.cancelTooltip(ERROR_STRIPE_TOOLTIP_GROUP);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.cancelMyToolTips(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.cancelMyToolTips(e);
        }

        public void setPopupHandler(PopupHandler handler) {
            if (this.myHandler != null) {
                this.removeMouseListener((MouseListener)this.myHandler);
            }
            this.myHandler = handler;
            this.addMouseListener((MouseListener)handler);
        }
    }

    private class MarkSpots {
        private List<MarkSpot> mySpots;
        private int myEditorScrollbarTop = -1;
        private int myEditorTargetHeight = -1;
        private int myEditorSourceHeight = -1;

        private MarkSpots() {
        }

        private void recalcEditorDimensions() {
            EditorImpl.MyScrollBar scrollBar = EditorMarkupModelImpl.this.myEditor.getVerticalScrollBar();
            this.myEditorScrollbarTop = scrollBar.getDecScrollButtonHeight() + 1;
            int bottom = scrollBar.getIncScrollButtonHeight();
            this.myEditorTargetHeight = EditorMarkupModelImpl.this.myScrollBarHeight - this.myEditorScrollbarTop - bottom;
            this.myEditorSourceHeight = ((EditorMarkupModelImpl)EditorMarkupModelImpl.this).myEditor.getPreferredSize().height;
        }

        private void clear() {
            this.mySpots = null;
            this.myEditorScrollbarTop = -1;
            this.myEditorSourceHeight = -1;
            this.myEditorTargetHeight = -1;
        }

        public boolean showToolTipByMouseMove(MouseEvent e, double width) {
            this.recalcMarkSpots();
            List<MarkSpot> nearestMarkSpots = this.getNearestMarkSpots(e, width);
            if (nearestMarkSpots.isEmpty()) {
                return false;
            }
            THashSet highlighters = new THashSet(nearestMarkSpots.size() + 4);
            for (MarkSpot markSpot : nearestMarkSpots) {
                highlighters.addAll(Arrays.asList(markSpot.highlighters));
            }
            TooltipRenderer bigRenderer = EditorMarkupModelImpl.this.myTooltipRendererProvider.calcTooltipRenderer((Collection<RangeHighlighter>)highlighters);
            if (bigRenderer != null) {
                EditorMarkupModelImpl.this.showTooltip(e, bigRenderer);
                return true;
            }
            return false;
        }

        private PositionedRangeHighlighter getPositionedRangeHighlighter(RangeHighlighter mark) {
            int visStartLine = EditorMarkupModelImpl.this.offsetToLine(mark.getStartOffset());
            int visEndLine = EditorMarkupModelImpl.this.offsetToLine(mark.getEndOffset());
            int yStartPosition = this.visibleLineToYPosition(visStartLine);
            int yEndPosition = this.visibleLineToYPosition(visEndLine);
            if (yEndPosition - yStartPosition < EditorMarkupModelImpl.this.getMinMarkHeight()) {
                yEndPosition = yStartPosition + EditorMarkupModelImpl.this.getMinMarkHeight();
            }
            return new PositionedRangeHighlighter(mark, yStartPosition, yEndPosition);
        }

        private int visibleLineToYPosition(int lineNumber) {
            if (this.myEditorScrollbarTop == -1) {
                this.recalcEditorDimensions();
            }
            if (this.myEditorSourceHeight < this.myEditorTargetHeight) {
                return this.myEditorScrollbarTop + lineNumber * EditorMarkupModelImpl.this.myEditor.getLineHeight();
            }
            int lineCount = this.myEditorSourceHeight / EditorMarkupModelImpl.this.myEditor.getLineHeight();
            return this.myEditorScrollbarTop + (int)((float)lineNumber / (float)lineCount * (float)this.myEditorTargetHeight);
        }

        private void recalcMarkSpots() {
            if (this.mySpots != null) {
                return;
            }
            List sortedHighlighters = EditorMarkupModelImpl.this.getSortedHighlighters();
            this.mySpots = new ArrayList<MarkSpot>();
            if (sortedHighlighters.isEmpty()) {
                return;
            }
            PriorityQueue<PositionedRangeHighlighter> startQueue = new PriorityQueue<PositionedRangeHighlighter>(5, new Comparator<PositionedRangeHighlighter>(){

                @Override
                public int compare(PositionedRangeHighlighter o1, PositionedRangeHighlighter o2) {
                    return o1.yStart - o2.yStart;
                }
            });
            PriorityQueue<PositionedRangeHighlighter> endQueue = new PriorityQueue<PositionedRangeHighlighter>(5, new Comparator<PositionedRangeHighlighter>(){

                @Override
                public int compare(PositionedRangeHighlighter o1, PositionedRangeHighlighter o2) {
                    return o1.yEnd - o2.yEnd;
                }
            });
            int index = 0;
            MarkSpot currentSpot = null;
            while (!startQueue.isEmpty() || !endQueue.isEmpty() || index != sortedHighlighters.size()) {
                boolean addingNew;
                PositionedRangeHighlighter positionedMark;
                LOG.assertTrue(startQueue.size() == endQueue.size());
                if (index != sortedHighlighters.size()) {
                    RangeHighlighter mark = (RangeHighlighter)sortedHighlighters.get(index);
                    if (!mark.isValid() || mark.getErrorStripeMarkColor() == null) {
                        sortedHighlighters.remove(index);
                        continue;
                    }
                    PositionedRangeHighlighter positioned = this.getPositionedRangeHighlighter(mark);
                    if (!endQueue.isEmpty() && ((PositionedRangeHighlighter)endQueue.peek()).yEnd <= positioned.yStart) {
                        positionedMark = (PositionedRangeHighlighter)endQueue.peek();
                        addingNew = false;
                    } else {
                        positionedMark = positioned;
                        addingNew = true;
                    }
                } else if (!endQueue.isEmpty()) {
                    positionedMark = (PositionedRangeHighlighter)endQueue.peek();
                    addingNew = false;
                } else {
                    LOG.error("cant be");
                    return;
                }
                if (addingNew) {
                    PositionedRangeHighlighter positioned;
                    if (currentSpot == null) {
                        currentSpot = new MarkSpot(positionedMark.yStart, -1);
                    } else {
                        currentSpot.yEnd = positionedMark.yStart;
                        if (currentSpot.yEnd != currentSpot.yStart) {
                            this.spitOutMarkSpot(currentSpot, startQueue);
                        }
                        currentSpot = new MarkSpot(positionedMark.yStart, -1);
                    }
                    while (index != sortedHighlighters.size() && (positioned = this.getPositionedRangeHighlighter((RangeHighlighter)sortedHighlighters.get(index))).yStart == positionedMark.yStart) {
                        startQueue.add(positioned);
                        endQueue.add(positioned);
                        ++index;
                    }
                    continue;
                }
                currentSpot.yEnd = positionedMark.yEnd;
                this.spitOutMarkSpot(currentSpot, startQueue);
                currentSpot = new MarkSpot(positionedMark.yEnd, -1);
                block2: while (!endQueue.isEmpty() && ((PositionedRangeHighlighter)endQueue.peek()).yEnd == positionedMark.yEnd) {
                    PositionedRangeHighlighter highlighter = (PositionedRangeHighlighter)endQueue.remove();
                    Iterator iterator = startQueue.iterator();
                    while (iterator.hasNext()) {
                        PositionedRangeHighlighter positioned = (PositionedRangeHighlighter)iterator.next();
                        if (positioned != highlighter) continue;
                        iterator.remove();
                        continue block2;
                    }
                }
                if (!startQueue.isEmpty()) continue;
                currentSpot = null;
            }
        }

        private void spitOutMarkSpot(MarkSpot currentSpot, Queue<PositionedRangeHighlighter> startQueue) {
            this.mySpots.add(currentSpot);
            MarkSpot.access$402(currentSpot, new RangeHighlighter[startQueue.size()]);
            int i = 0;
            for (PositionedRangeHighlighter positioned : startQueue) {
                ((MarkSpot)currentSpot).highlighters[i++] = positioned.highlighter;
            }
            Arrays.sort(currentSpot.highlighters, LAYER_COMPARATOR);
        }

        private void repaint(Graphics g, int width) {
            this.recalcMarkSpots();
            for (int i = 0; i < this.mySpots.size(); ++i) {
                MarkSpot markSpot = this.mySpots.get(i);
                int yStart = markSpot.yStart;
                RangeHighlighter mark = markSpot.highlighters[markSpot.highlighters.length - 1];
                int yEnd = markSpot.yEnd;
                Color color = mark.getErrorStripeMarkColor();
                int x = 1;
                int paintWidth = width;
                if (mark.isThinErrorStripeMark()) {
                    x += (paintWidth /= 2) / 2;
                }
                g.setColor(color);
                g.fillRect(x + 1, yStart, paintWidth - 2, yEnd - yStart);
                Color brighter = color.brighter();
                Color darker = color.darker();
                g.setColor(brighter);
                UIUtil.drawLine((Graphics)g, (int)x, (int)yStart, (int)x, (int)(yEnd - 1));
                if (i == 0 || !this.isAdjacent(this.mySpots.get(i - 1), markSpot) || this.wider(markSpot, this.mySpots.get(i - 1))) {
                    UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)yStart, (int)(x + paintWidth - 2), (int)yStart);
                }
                g.setColor(darker);
                if (i == this.mySpots.size() - 1 || !this.isAdjacent(markSpot, this.mySpots.get(i + 1)) || this.wider(markSpot, this.mySpots.get(i + 1))) {
                    UIUtil.drawLine((Graphics)g, (int)(x + 1), (int)(yEnd - 1), (int)(x + paintWidth - 2), (int)(yEnd - 1));
                }
                UIUtil.drawLine((Graphics)g, (int)(x + paintWidth - 2), (int)yStart, (int)(x + paintWidth - 2), (int)(yEnd - 1));
            }
        }

        private boolean isAdjacent(MarkSpot markTop, MarkSpot markBottom) {
            return markTop.yEnd >= markBottom.yStart;
        }

        private boolean wider(MarkSpot markTop, MarkSpot markBottom) {
            RangeHighlighter highlighterTop = markTop.highlighters[markTop.highlighters.length - 1];
            RangeHighlighter highlighterBottom = markBottom.highlighters[markBottom.highlighters.length - 1];
            return !highlighterTop.isThinErrorStripeMark() && highlighterBottom.isThinErrorStripeMark();
        }

        public void doClick(MouseEvent e, int width) {
            this.recalcMarkSpots();
            RangeHighlighter marker = this.getNearestRangeHighlighter(e, width);
            if (marker == null) {
                return;
            }
            int offset = marker.getStartOffset();
            Document doc = EditorMarkupModelImpl.this.myEditor.getDocument();
            if (doc.getLineCount() > 0) {
                int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
                EditorMarkupModelImpl.this.myEditor.getCaretModel().moveToOffset(lineEnd);
            }
            EditorMarkupModelImpl.this.myEditor.getCaretModel().moveToOffset(offset);
            EditorMarkupModelImpl.this.myEditor.getSelectionModel().removeSelection();
            ScrollingModel scrollingModel = EditorMarkupModelImpl.this.myEditor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.CENTER);
            scrollingModel.enableAnimation();
            EditorMarkupModelImpl.this.fireErrorMarkerClicked(marker, e);
        }

        private RangeHighlighter getNearestRangeHighlighter(MouseEvent e, int width) {
            List<MarkSpot> nearestSpots = this.getNearestMarkSpots(e, width);
            RangeHighlighter nearestMarker = null;
            int yPos = 0;
            for (MarkSpot markSpot : nearestSpots) {
                for (RangeHighlighter highlighter : markSpot.highlighters) {
                    int newYPos = this.visibleLineToYPosition(EditorMarkupModelImpl.this.offsetToLine(highlighter.getStartOffset()));
                    if (nearestMarker != null && Math.abs(yPos - e.getY()) <= Math.abs(newYPos - e.getY())) continue;
                    nearestMarker = highlighter;
                    yPos = newYPos;
                }
            }
            return nearestMarker;
        }

        private List<MarkSpot> getNearestMarkSpots(MouseEvent e, double width) {
            List nearestSpot = null;
            for (MarkSpot markSpot : this.mySpots) {
                if (!markSpot.near(e, width)) continue;
                if (nearestSpot == null) {
                    nearestSpot = new SmartList();
                }
                nearestSpot.add(markSpot);
            }
            return nearestSpot == null ? Collections.emptyList() : nearestSpot;
        }

        private class PositionedRangeHighlighter {
            private final RangeHighlighter highlighter;
            private final int yStart;
            private final int yEnd;

            private PositionedRangeHighlighter(RangeHighlighter highlighter, int yStart, int yEnd) {
                this.highlighter = highlighter;
                this.yStart = yStart;
                this.yEnd = yEnd;
            }

            public String toString() {
                return "PR[" + this.yStart + "-" + this.yEnd + ")";
            }
        }
    }

    private static class MarkSpot {
        private final int yStart;
        private int yEnd;
        private RangeHighlighter[] highlighters = RangeHighlighter.EMPTY_ARRAY;

        private MarkSpot(int yStart, int yEnd) {
            this.yStart = yStart;
            this.yEnd = yEnd;
        }

        private boolean near(MouseEvent e, double width) {
            int x = e.getX();
            int y = e.getY();
            return 0 <= x && (double)x < width && this.yStart - EditorMarkupModelImpl.getMinHeight() <= y && y < this.yEnd + EditorMarkupModelImpl.getMinHeight();
        }

        static /* synthetic */ RangeHighlighter[] access$402(MarkSpot x0, RangeHighlighter[] x1) {
            x0.highlighters = x1;
            return x1;
        }
    }
}

