/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldRegionImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.MultiMap;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FoldingModelImpl
implements FoldingModelEx,
PrioritizedDocumentListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.editor.impl.EditorFoldingModelImpl");
    private boolean myIsFoldingEnabled;
    private final EditorImpl myEditor;
    private final FoldRegionsTree myFoldTree;
    private TextAttributes myFoldTextAttributes;
    private boolean myIsBatchFoldingProcessing;
    private boolean myDoNotCollapseCaret;
    private boolean myFoldRegionsProcessed;
    private int mySavedCaretX;
    private int mySavedCaretY;
    private int mySavedCaretShift;
    private boolean myCaretPositionSaved;
    private final MultiMap<FoldingGroup, FoldRegion> myGroups = new MultiMap();
    private static final Comparator<FoldRegion> BY_END_OFFSET = new Comparator<FoldRegion>(){

        @Override
        public int compare(FoldRegion r1, FoldRegion r2) {
            int end2;
            int end1 = r1.getEndOffset();
            if (end1 < (end2 = r2.getEndOffset())) {
                return -1;
            }
            if (end1 > end2) {
                return 1;
            }
            return 0;
        }
    };
    private static final Comparator<? super FoldRegion> BY_END_OFFSET_REVERSE = Collections.reverseOrder(BY_END_OFFSET);

    public FoldingModelImpl(EditorImpl editor) {
        this.myEditor = editor;
        this.myIsFoldingEnabled = true;
        this.myIsBatchFoldingProcessing = false;
        this.myDoNotCollapseCaret = false;
        this.myFoldTree = new FoldRegionsTree();
        this.myFoldRegionsProcessed = false;
        this.refreshSettings();
    }

    @NotNull
    public List<FoldRegion> getGroupedRegions(@NotNull FoldingGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.getGroupedRegions must not be null");
        }
        List list = (List)this.myGroups.get((Object)group);
        if (list == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/FoldingModelImpl.getGroupedRegions must not return null");
        }
        return list;
    }

    @NotNull
    public FoldRegion getFirstRegion(@NotNull FoldingGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.getFirstRegion must not be null");
        }
        List<FoldRegion> regions = this.getGroupedRegions(group);
        FoldRegion main = regions.get(0);
        for (int i = 1; i < regions.size(); ++i) {
            FoldRegion region = regions.get(i);
            if (main.getStartOffset() <= region.getStartOffset()) continue;
            main = region;
        }
        FoldRegion foldRegion = main;
        if (foldRegion == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/FoldingModelImpl.getFirstRegion must not return null");
        }
        return foldRegion;
    }

    public int getEndOffset(@NotNull FoldingGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.getEndOffset must not be null");
        }
        List<FoldRegion> regions = this.getGroupedRegions(group);
        int endOffset = 0;
        for (FoldRegion region : regions) {
            if (!region.isValid()) continue;
            endOffset = Math.max(endOffset, region.getEndOffset());
        }
        return endOffset;
    }

    public void refreshSettings() {
        this.myFoldTextAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.FOLDED_TEXT_ATTRIBUTES);
    }

    @Override
    public boolean isFoldingEnabled() {
        return this.myIsFoldingEnabled;
    }

    public boolean isOffsetCollapsed(int offset) {
        FoldingModelImpl.assertReadAccess();
        return this.getCollapsedRegionAtOffset(offset) != null;
    }

    private void assertIsDispatchThread() {
        ApplicationManagerEx.getApplicationEx().assertIsDispatchThread(this.myEditor.getComponent());
    }

    private static void assertReadAccess() {
        ApplicationManagerEx.getApplicationEx().assertReadAccessAllowed();
    }

    @Override
    public void setFoldingEnabled(boolean isEnabled) {
        this.assertIsDispatchThread();
        this.myIsFoldingEnabled = isEnabled;
    }

    public FoldRegion addFoldRegion(int startOffset, int endOffset, @NotNull String placeholderText) {
        if (placeholderText == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.addFoldRegion must not be null");
        }
        FoldRegion region = this.createFoldRegion(startOffset, endOffset, placeholderText, null);
        return this.addFoldRegion(region) ? region : null;
    }

    public boolean addFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.addFoldRegion must not be null");
        }
        this.assertIsDispatchThread();
        if (this.isFoldingEnabled()) {
            if (!this.myIsBatchFoldingProcessing) {
                LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
                return false;
            }
            this.myFoldRegionsProcessed = true;
            if (this.myFoldTree.addRegion(region)) {
                FoldingGroup group = region.getGroup();
                if (group != null) {
                    this.myGroups.putValue((Object)group, (Object)region);
                }
                return true;
            }
        }
        return false;
    }

    public void runBatchFoldingOperation(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.runBatchFoldingOperation must not be null");
        }
        this.runBatchFoldingOperation(operation, false);
    }

    private void runBatchFoldingOperation(Runnable operation, boolean dontCollapseCaret) {
        this.assertIsDispatchThread();
        boolean oldDontCollapseCaret = this.myDoNotCollapseCaret;
        this.myDoNotCollapseCaret |= dontCollapseCaret;
        boolean oldBatchFlag = this.myIsBatchFoldingProcessing;
        if (!oldBatchFlag) {
            this.mySavedCaretShift = this.myEditor.visibleLineNumberToYPosition(this.myEditor.getCaretModel().getVisualPosition().line) - this.myEditor.getScrollingModel().getVerticalScrollOffset();
        }
        this.myIsBatchFoldingProcessing = true;
        this.myFoldTree.myCachedLastIndex = -1;
        operation.run();
        this.myFoldTree.myCachedLastIndex = -1;
        if (!oldBatchFlag) {
            if (this.myFoldRegionsProcessed) {
                this.notifyBatchFoldingProcessingDone();
                this.myFoldRegionsProcessed = false;
            }
            this.myIsBatchFoldingProcessing = false;
        }
        this.myDoNotCollapseCaret = oldDontCollapseCaret;
    }

    public void runBatchFoldingOperationDoNotCollapseCaret(@NotNull Runnable operation) {
        if (operation == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.runBatchFoldingOperationDoNotCollapseCaret must not be null");
        }
        this.runBatchFoldingOperation(operation, true);
    }

    public void flushCaretShift() {
        this.mySavedCaretShift = -1;
    }

    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldingModelImpl.assertReadAccess();
        FoldRegion[] foldRegionArray = this.myFoldTree.fetchAllRegions();
        if (foldRegionArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/editor/impl/FoldingModelImpl.getAllFoldRegions must not return null");
        }
        return foldRegionArray;
    }

    public FoldRegion getCollapsedRegionAtOffset(int offset) {
        return this.myFoldTree.fetchOutermost(offset);
    }

    int getLastTopLevelIndexBefore(int offset) {
        return this.myFoldTree.getLastTopLevelIndexBefore(offset);
    }

    @Override
    public FoldRegion getFoldingPlaceholderAt(Point p) {
        FoldingModelImpl.assertReadAccess();
        LogicalPosition pos = this.myEditor.xyToLogicalPosition(p);
        int line = pos.line;
        if (line >= this.myEditor.getDocument().getLineCount()) {
            return null;
        }
        if (this.myEditor.xyToVisualPosition(p).equals((Object)this.myEditor.logicalToVisualPosition(pos))) {
            return null;
        }
        int offset = this.myEditor.logicalPositionToOffset(pos);
        return this.myFoldTree.fetchOutermost(offset);
    }

    @Override
    public FoldRegion[] getAllFoldRegionsIncludingInvalid() {
        FoldingModelImpl.assertReadAccess();
        return this.myFoldTree.fetchAllRegionsIncludingInvalid();
    }

    public void removeFoldRegion(@NotNull FoldRegion region) {
        if (region == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.removeFoldRegion must not be null");
        }
        this.assertIsDispatchThread();
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be added or removed inside batchFoldProcessing() only.");
        }
        region.setExpanded(true);
        FoldingGroup group = region.getGroup();
        if (group != null) {
            this.myGroups.removeValue((Object)group, (Object)region);
        }
        this.myFoldTree.removeRegion(region);
        this.myFoldRegionsProcessed = true;
    }

    public void expandFoldRegion(FoldRegion region) {
        int savedOffset;
        FoldRegion[] allCollapsed;
        this.assertIsDispatchThread();
        if (region.isExpanded()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        if (this.myCaretPositionSaved && (allCollapsed = this.myFoldTree.fetchCollapsedAt(savedOffset = this.myEditor.logicalPositionToOffset(new LogicalPosition(this.mySavedCaretY, this.mySavedCaretX)))).length == 1 && allCollapsed[0] == region) {
            LogicalPosition pos = new LogicalPosition(this.mySavedCaretY, this.mySavedCaretX);
            this.myEditor.getCaretModel().moveToLogicalPosition(pos);
        }
        this.myFoldRegionsProcessed = true;
        ((FoldRegionImpl)region).setExpandedInternal(true);
    }

    public void collapseFoldRegion(FoldRegion region) {
        LogicalPosition caretPosition;
        int caretOffset;
        this.assertIsDispatchThread();
        if (!region.isExpanded()) {
            return;
        }
        if (!this.myIsBatchFoldingProcessing) {
            LOG.error("Fold regions must be collapsed or expanded inside batchFoldProcessing() only.");
        }
        if (this.myFoldTree.contains(region, caretOffset = this.myEditor.logicalPositionToOffset(caretPosition = this.myEditor.getCaretModel().getLogicalPosition()))) {
            if (this.myDoNotCollapseCaret) {
                return;
            }
            if (!this.myCaretPositionSaved) {
                this.mySavedCaretX = caretPosition.column;
                this.mySavedCaretY = caretPosition.line;
                this.myCaretPositionSaved = true;
            }
        }
        int selectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
        if (this.myFoldTree.contains(region, selectionStart - 1) || this.myFoldTree.contains(region, selectionEnd)) {
            this.myEditor.getSelectionModel().removeSelection();
        }
        this.myFoldRegionsProcessed = true;
        ((FoldRegionImpl)region).setExpandedInternal(false);
    }

    private void notifyBatchFoldingProcessingDone() {
        this.myFoldTree.rebuild();
        this.myEditor.updateCaretCursor();
        this.myEditor.recalcSizeAndRepaint();
        if (this.myEditor.getGutterComponentEx().isFoldingOutlineShown()) {
            this.myEditor.getGutterComponentEx().repaint();
        }
        LogicalPosition caretPosition = this.myEditor.getCaretModel().getLogicalPosition();
        int caretOffset = this.myEditor.logicalPositionToOffset(caretPosition);
        boolean hasBlockSelection = this.myEditor.getSelectionModel().hasBlockSelection();
        int selectionStart = this.myEditor.getSelectionModel().getSelectionStart();
        int selectionEnd = this.myEditor.getSelectionModel().getSelectionEnd();
        int column = -1;
        int line = -1;
        FoldRegion collapsed = this.myFoldTree.fetchOutermost(caretOffset);
        if (this.myCaretPositionSaved) {
            int savedOffset = this.myEditor.logicalPositionToOffset(new LogicalPosition(this.mySavedCaretY, this.mySavedCaretX));
            FoldRegion collapsedAtSaved = this.myFoldTree.fetchOutermost(savedOffset);
            column = this.mySavedCaretX;
            int n = line = collapsedAtSaved != null ? collapsedAtSaved.getDocument().getLineNumber(collapsedAtSaved.getStartOffset()) : this.mySavedCaretY;
        }
        if (collapsed != null && column == -1) {
            line = collapsed.getDocument().getLineNumber(collapsed.getStartOffset());
            column = this.myEditor.getCaretModel().getVisualPosition().column;
        }
        boolean oldCaretPositionSaved = this.myCaretPositionSaved;
        if (column != -1) {
            LogicalPosition log = new LogicalPosition(line, 0);
            VisualPosition vis = this.myEditor.logicalToVisualPosition(log);
            VisualPosition pos = new VisualPosition(vis.line, column);
            this.myEditor.getCaretModel().moveToVisualPosition(pos);
        } else {
            this.myEditor.getCaretModel().moveToLogicalPosition(caretPosition);
        }
        this.myCaretPositionSaved = oldCaretPositionSaved;
        if (!hasBlockSelection) {
            this.myEditor.getSelectionModel().setSelection(selectionStart, selectionEnd);
        }
        if (this.mySavedCaretShift > 0) {
            this.myEditor.getScrollingModel().disableAnimation();
            int scrollTo = this.myEditor.visibleLineNumberToYPosition(this.myEditor.getCaretModel().getVisualPosition().line) - this.mySavedCaretShift;
            this.myEditor.getScrollingModel().scrollVertically(scrollTo);
            this.myEditor.getScrollingModel().enableAnimation();
        }
    }

    public void rebuild() {
        this.myFoldTree.rebuild();
    }

    private void updateCachedOffsets() {
        this.myFoldTree.updateCachedOffsets();
    }

    public int getFoldedLinesCountBefore(int offset) {
        return this.myFoldTree.getFoldedLinesCountBefore(offset);
    }

    @Override
    public FoldRegion[] fetchTopLevel() {
        return this.myFoldTree.fetchTopLevel();
    }

    @Override
    public FoldRegion fetchOutermost(int offset) {
        return this.myFoldTree.fetchOutermost(offset);
    }

    public FoldRegion[] fetchCollapsedAt(int offset) {
        return this.myFoldTree.fetchCollapsedAt(offset);
    }

    @Override
    public boolean intersectsRegion(int startOffset, int endOffset) {
        return this.myFoldTree.intersectsRegion(startOffset, endOffset);
    }

    public FoldRegion[] fetchVisible() {
        return this.myFoldTree.fetchVisible();
    }

    @Override
    public int getLastCollapsedRegionBefore(int offset) {
        return this.myFoldTree.getLastTopLevelIndexBefore(offset);
    }

    @Override
    public TextAttributes getPlaceholderAttributes() {
        return this.myFoldTextAttributes;
    }

    public void flushCaretPosition() {
        this.myCaretPositionSaved = false;
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        if (((DocumentEx)event.getDocument()).isInBulkUpdate()) {
            this.myFoldTree.clear();
        } else {
            this.updateCachedOffsets();
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public FoldRegion createFoldRegion(int startOffset, int endOffset, @NotNull String placeholder, FoldingGroup group) {
        if (placeholder == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/openapi/editor/impl/FoldingModelImpl.createFoldRegion must not be null");
        }
        return new FoldRegionImpl(this.myEditor, startOffset, endOffset, placeholder, group);
    }

    class FoldRegionsTree {
        private FoldRegion[] myCachedVisible;
        private FoldRegion[] myCachedTopLevelRegions;
        private int[] myCachedEndOffsets;
        private int[] myCachedStartOffsets;
        private int[] myCachedFoldedLines;
        private int myCachedLastIndex = -1;
        private ArrayList<FoldRegion> myRegions = CollectionFactory.arrayList();

        FoldRegionsTree() {
        }

        private void clear() {
            this.myCachedVisible = null;
            this.myCachedTopLevelRegions = null;
            this.myCachedEndOffsets = null;
            this.myCachedStartOffsets = null;
            this.myCachedFoldedLines = null;
            this.myRegions = new ArrayList();
        }

        private boolean isFoldingEnabled() {
            return FoldingModelImpl.this.isFoldingEnabled() && this.myCachedVisible != null;
        }

        void rebuild() {
            FoldRegion[] visibleArrayed;
            ArrayList<FoldRegion> topLevels = new ArrayList<FoldRegion>(this.myRegions.size() / 2);
            ArrayList<FoldRegion> visible = new ArrayList<FoldRegion>(this.myRegions.size());
            FoldRegion[] regions = this.myRegions.toArray(new FoldRegion[this.myRegions.size()]);
            FoldRegion currentToplevel = null;
            for (FoldRegion region : regions) {
                if (!region.isValid()) continue;
                visible.add(region);
                if (region.isExpanded() || currentToplevel != null && currentToplevel.getEndOffset() >= region.getStartOffset()) continue;
                currentToplevel = region;
                topLevels.add(region);
            }
            this.myCachedTopLevelRegions = topLevels.isEmpty() ? FoldRegion.EMPTY_ARRAY : topLevels.toArray(new FoldRegion[topLevels.size()]);
            Arrays.sort(this.myCachedTopLevelRegions, BY_END_OFFSET);
            block1: for (FoldRegion visibleRegion : visibleArrayed = visible.toArray(new FoldRegion[visible.size()])) {
                for (FoldRegion topLevelRegion : this.myCachedTopLevelRegions) {
                    if (!this.contains(topLevelRegion, visibleRegion)) continue;
                    visible.remove(visibleRegion);
                    continue block1;
                }
            }
            this.myCachedVisible = visible.toArray(new FoldRegion[visible.size()]);
            Arrays.sort(this.myCachedVisible, BY_END_OFFSET_REVERSE);
            this.updateCachedOffsets();
        }

        void updateCachedOffsets() {
            if (FoldingModelImpl.this.isFoldingEnabled()) {
                if (this.myCachedVisible == null) {
                    this.rebuild();
                    return;
                }
                for (FoldRegion foldRegion : this.myCachedVisible) {
                    if (foldRegion.isValid()) continue;
                    this.rebuild();
                    return;
                }
                int length = this.myCachedTopLevelRegions.length;
                if (this.myCachedEndOffsets == null || this.myCachedEndOffsets.length != length) {
                    if (length != 0) {
                        this.myCachedEndOffsets = new int[length];
                        this.myCachedStartOffsets = new int[length];
                        this.myCachedFoldedLines = new int[length];
                    } else {
                        this.myCachedEndOffsets = ArrayUtil.EMPTY_INT_ARRAY;
                        this.myCachedStartOffsets = ArrayUtil.EMPTY_INT_ARRAY;
                        this.myCachedFoldedLines = ArrayUtil.EMPTY_INT_ARRAY;
                    }
                }
                int sum = 0;
                for (int i = 0; i < length; ++i) {
                    FoldRegion region = this.myCachedTopLevelRegions[i];
                    this.myCachedStartOffsets[i] = region.getStartOffset();
                    this.myCachedEndOffsets[i] = region.getEndOffset() - 1;
                    this.myCachedFoldedLines[i] = sum += region.getDocument().getLineNumber(region.getEndOffset()) - region.getDocument().getLineNumber(region.getStartOffset());
                }
            }
        }

        boolean addRegion(FoldRegion range) {
            FoldRegion region;
            int i;
            int fastIndex;
            int n = fastIndex = this.myCachedLastIndex != -1 && FoldingModelImpl.this.myIsBatchFoldingProcessing ? this.myCachedLastIndex + 1 : Collections.binarySearch(this.myRegions, range, RangeMarker.BY_START_OFFSET);
            if (fastIndex < 0) {
                fastIndex = -fastIndex - 1;
            }
            for (i = fastIndex - 1; i >= 0 && (region = this.myRegions.get(i)).getEndOffset() >= range.getStartOffset(); --i) {
                if (!region.isValid() || !this.intersects(region, range)) continue;
                return false;
            }
            for (i = fastIndex; i < this.myRegions.size(); ++i) {
                region = this.myRegions.get(i);
                if (range.getStartOffset() >= region.getStartOffset() && (range.getStartOffset() != region.getStartOffset() || range.getEndOffset() <= region.getEndOffset())) continue;
                for (int j = i + 1; j < this.myRegions.size(); ++j) {
                    FoldRegion next = this.myRegions.get(j);
                    if (next.getEndOffset() < range.getEndOffset() || !next.isValid()) continue;
                    if (next.getStartOffset() >= range.getStartOffset()) break;
                    return false;
                }
                this.myCachedLastIndex = i;
                this.myRegions.add(this.myCachedLastIndex, range);
                return true;
            }
            this.myCachedLastIndex = this.myRegions.size();
            this.myRegions.add(this.myCachedLastIndex, range);
            return true;
        }

        FoldRegion fetchOutermost(int offset) {
            if (!this.isFoldingEnabled()) {
                return null;
            }
            int[] starts = this.myCachedStartOffsets;
            int[] ends = this.myCachedEndOffsets;
            int start = 0;
            int end = ends.length - 1;
            while (start <= end) {
                int i = (start + end) / 2;
                if (offset < starts[i]) {
                    end = i - 1;
                    continue;
                }
                if (offset > ends[i]) {
                    start = i + 1;
                    continue;
                }
                return this.myCachedTopLevelRegions[i];
            }
            return null;
        }

        FoldRegion[] fetchVisible() {
            if (!this.isFoldingEnabled()) {
                return FoldRegion.EMPTY_ARRAY;
            }
            return this.myCachedVisible;
        }

        FoldRegion[] fetchTopLevel() {
            if (!this.isFoldingEnabled()) {
                return null;
            }
            return this.myCachedTopLevelRegions;
        }

        private boolean contains(FoldRegion outer, FoldRegion inner) {
            return outer.getStartOffset() < inner.getStartOffset() && outer.getEndOffset() > inner.getStartOffset();
        }

        private boolean intersects(FoldRegion r1, FoldRegion r2) {
            int s1 = r1.getStartOffset();
            int s2 = r2.getStartOffset();
            int e1 = r1.getEndOffset();
            int e2 = r2.getEndOffset();
            return s1 == s2 && e1 == e2 || s1 < s2 && s2 < e1 && e1 < e2 || s2 < s1 && s1 < e2 && e2 < e1;
        }

        private boolean contains(FoldRegion region, int offset) {
            return region.getStartOffset() < offset && region.getEndOffset() > offset;
        }

        public FoldRegion[] fetchCollapsedAt(int offset) {
            if (!this.isFoldingEnabled()) {
                return FoldRegion.EMPTY_ARRAY;
            }
            ArrayList<FoldRegion> allCollapsed = new ArrayList<FoldRegion>();
            for (FoldRegion region : this.myRegions) {
                if (region.isExpanded() || !this.contains(region, offset)) continue;
                allCollapsed.add(region);
            }
            return allCollapsed.toArray(new FoldRegion[allCollapsed.size()]);
        }

        boolean intersectsRegion(int startOffset, int endOffset) {
            if (!FoldingModelImpl.this.isFoldingEnabled()) {
                return true;
            }
            for (FoldRegion region : this.myRegions) {
                boolean contains2;
                boolean contains1 = this.contains(region, startOffset);
                if (contains1 == (contains2 = this.contains(region, endOffset))) continue;
                return true;
            }
            return false;
        }

        FoldRegion[] fetchAllRegions() {
            if (!this.isFoldingEnabled()) {
                return FoldRegion.EMPTY_ARRAY;
            }
            return this.myRegions.toArray(new FoldRegion[this.myRegions.size()]);
        }

        void removeRegion(FoldRegion range) {
            this.myRegions.remove(range);
        }

        int getFoldedLinesCountBefore(int offset) {
            int idx = this.getLastTopLevelIndexBefore(offset);
            if (idx == -1) {
                return 0;
            }
            return this.myCachedFoldedLines[idx];
        }

        public int getLastTopLevelIndexBefore(int offset) {
            if (!this.isFoldingEnabled()) {
                return -1;
            }
            int start = 0;
            int end = this.myCachedEndOffsets.length - 1;
            while (start <= end) {
                int i = (start + end) / 2;
                if (offset < this.myCachedEndOffsets[i]) {
                    end = i - 1;
                    continue;
                }
                if (offset > this.myCachedEndOffsets[i]) {
                    start = i + 1;
                    continue;
                }
                return i;
            }
            return end;
        }

        public FoldRegion[] fetchAllRegionsIncludingInvalid() {
            if (!FoldingModelImpl.this.isFoldingEnabled()) {
                return FoldRegion.EMPTY_ARRAY;
            }
            return this.myRegions.toArray(new FoldRegion[this.myRegions.size()]);
        }
    }
}

