/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectWizardStepFactory;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.IconLoader;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;

public class JavaModuleType
extends ModuleType<JavaModuleBuilder> {
    public JavaModuleType() {
        this("JAVA_MODULE");
    }

    protected JavaModuleType(@NonNls String id) {
        super(id);
    }

    public JavaModuleBuilder createModuleBuilder() {
        return new JavaModuleBuilder();
    }

    public String getName() {
        return ProjectBundle.message((String)"module.type.java.name", (Object[])new Object[0]);
    }

    public String getDescription() {
        return ProjectBundle.message((String)"module.type.java.description", (Object[])new Object[0]);
    }

    public Icon getBigIcon() {
        return JavaModuleType.getJavaModuleIcon();
    }

    public Icon getNodeIcon(boolean isOpened) {
        return isOpened ? JavaModuleType.getJavaModuleNodeIconOpen() : JavaModuleType.getJavaModuleNodeIconClosed();
    }

    public ModuleWizardStep[] createWizardSteps(final WizardContext wizardContext, JavaModuleBuilder moduleBuilder, ModulesProvider modulesProvider) {
        final ProjectWizardStepFactory wizardFactory = ProjectWizardStepFactory.getInstance();
        ArrayList<ModuleWizardStep> steps = new ArrayList<ModuleWizardStep>();
        steps.add(wizardFactory.createSourcePathsStep(wizardContext, (SourcePathsBuilder)moduleBuilder, JavaModuleType.getWizardIcon(), "reference.dialogs.new.project.fromScratch.source"));
        steps.add(wizardFactory.createProjectJdkStep(wizardContext, (SdkType)JavaSdk.getInstance(), moduleBuilder, (Computable)new Computable<Boolean>(){

            public Boolean compute() {
                Sdk projectJdk = wizardFactory.getNewProjectSdk(wizardContext);
                return projectJdk == null || projectJdk.getSdkType() != JavaSdk.getInstance() ? Boolean.TRUE : Boolean.FALSE;
            }
        }, JavaModuleType.getWizardIcon(), "reference.dialogs.new.project.fromScratch.sdk"));
        ModuleWizardStep supportForFrameworksStep = wizardFactory.createSupportForFrameworksStep(wizardContext, (ModuleBuilder)moduleBuilder);
        if (supportForFrameworksStep != null) {
            steps.add(supportForFrameworksStep);
        }
        Object[] wizardSteps = steps.toArray(new ModuleWizardStep[steps.size()]);
        return (ModuleWizardStep[])ArrayUtil.mergeArrays((Object[])wizardSteps, (Object[])super.createWizardSteps(wizardContext, (ModuleBuilder)moduleBuilder, modulesProvider), ModuleWizardStep.class);
    }

    private static Icon getJavaModuleIcon() {
        return IconHolder.JAVA_MODULE_ICON;
    }

    private static Icon getJavaModuleNodeIconOpen() {
        return JavaModuleOpenIconHolder.JAVA_MODULE_NODE_ICON_OPEN;
    }

    private static Icon getJavaModuleNodeIconClosed() {
        return JavaModuleClosedIconHolder.JAVA_MODULE_NODE_ICON_CLOSED;
    }

    private static Icon getWizardIcon() {
        return WizardIconHolder.WIZARD_ICON;
    }

    public boolean isValidSdk(Module module, Sdk projectSdk) {
        return JavaModuleType.isValidJavaSdk(module);
    }

    public static boolean isValidJavaSdk(Module module) {
        if (ModuleRootManager.getInstance((Module)module).getSourceRoots().length == 0) {
            return true;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("java.lang.Object", module.getModuleWithLibrariesScope()) != null;
    }

    private static class WizardIconHolder {
        private static final Icon WIZARD_ICON = IconLoader.getIcon((String)"/addmodulewizard.png");

        private WizardIconHolder() {
        }
    }

    private static class JavaModuleClosedIconHolder {
        private static final Icon JAVA_MODULE_NODE_ICON_CLOSED = IconLoader.getIcon((String)"/nodes/ModuleClosed.png");

        private JavaModuleClosedIconHolder() {
        }
    }

    private static class JavaModuleOpenIconHolder {
        private static final Icon JAVA_MODULE_NODE_ICON_OPEN = IconLoader.getIcon((String)"/nodes/ModuleOpen.png");

        private JavaModuleOpenIconHolder() {
        }
    }

    private static class IconHolder {
        private static final Icon JAVA_MODULE_ICON = IconLoader.getIcon((String)"/modules/javaModule.png");

        private IconHolder() {
        }
    }
}

